/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter;

import br.com.tracker.dfeconverter.util.PropUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringPortConfig {
    private static final Logger log = LoggerFactory.getLogger(SpringPortConfig.class);
    @Value(value="${app.version}")
    private String appVersion;

    @Bean
    public WebServerFactoryCustomizer<ConfigurableWebServerFactory> webServerFactoryCustomizer() {
        return factory -> {
            MDC.put((String)"appVersion", (String)("v" + this.appVersion));
            try {
                int port = PropUtil.getInt((String)"sync.port", (int)9393);
                PropUtil.logAllProperties((boolean)false);
                factory.setPort(port);
            }
            catch (NumberFormatException ex) {
                log.error("Erro ao converter a porta", (Throwable)ex);
                factory.setPort(9393);
            }
        };
    }
}

