/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.config;

import br.com.tracker.dfeconverter.conditions.HeadlessCondition;
import br.com.tracker.dfeconverter.conditions.NotHeadlessCondition;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.monitor.MonitorPastasParaProcessar;
import br.com.tracker.dfeconverter.monitor.StatusNotifier;
import br.com.tracker.dfeconverter.service.ConfigPort;
import br.com.tracker.dfeconverter.service.SincronizacaoService;
import br.com.tracker.dfeconverter.service.ViewService;
import java.awt.GraphicsEnvironment;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MonitorBeansConfig {
    private final ViewService viewService;
    @Value(value="${app.version}")
    private String appVersion;

    @Bean
    public MonitorPastasParaProcessar monitorBean(StatusNotifier notifier) {
        return new MonitorPastasParaProcessar(notifier, this.appVersion);
    }

    @Bean
    @Conditional(value={HeadlessCondition.class})
    public CommandLineRunner headlessMonitorStarter(MonitorPastasParaProcessar monitor, ConfigPort configPort, SincronizacaoService sincronizacaoService) {
        return args -> {
            Config cfg = configPort.buscar();
            monitor.setDirectories(cfg.getPastasMonitorar());
            monitor.startMonitoring();
            sincronizacaoService.agendaSchedulers(cfg);
        };
    }

    @Bean
    @Conditional(value={NotHeadlessCondition.class})
    public CommandLineRunner notHeadlessMonitorStarter() {
        return args -> this.viewService.iniciaSistema(GraphicsEnvironment.isHeadless());
    }

    public MonitorBeansConfig(ViewService viewService) {
        this.viewService = viewService;
    }
}

