/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.controller;

import br.com.tracker.dfeconverter.exception.ProxyProcessamentoException;
import br.com.tracker.dfeconverter.model.dto.ProxyRuleDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.service.ConfigPort;
import br.com.tracker.dfeconverter.service.ProxyNfeService;
import br.com.tracker.dfeconverter.util.XmlValidator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/proxy"})
public class ProxyController {
    private static final Logger log = LoggerFactory.getLogger(ProxyController.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final ProxyNfeService proxyNfeService;
    private final ConfigPort configService;
    private final ObjectMapper objectMapper;

    @Autowired
    public ProxyController(ProxyNfeService proxyNfeService, ConfigPort configService) {
        this.restTemplate.getMessageConverters().removeIf(c -> c instanceof StringHttpMessageConverter);
        this.restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        this.proxyNfeService = proxyNfeService;
        this.configService = configService;
        this.objectMapper = new ObjectMapper();
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE, RequestMethod.PATCH})
    public ResponseEntity<String> proxyRequest(HttpServletRequest request) {
        try {
            String targetBaseUrl = this.obterTargetBaseUrl();
            String path = request.getRequestURI().substring("/proxy".length());
            String targetUrl = targetBaseUrl + path;
            HttpMethod method = HttpMethod.valueOf((String)request.getMethod());
            if (request.getQueryString() != null) {
                targetUrl = targetUrl + "?" + request.getQueryString();
            }
            List proxyRules = this.obterProxyRules();
            byte[] bodyBytes = this.readRequestBodyAsBytes(request);
            Charset charsetDetectado = this.detectCharset(bodyBytes, request.getCharacterEncoding());
            log.info("Proxy: Request recebida | method={} | path={} | query={} | bodyBytes={} | charsetDetectado={}", new Object[]{method, path, request.getQueryString(), bodyBytes != null ? bodyBytes.length : 0, charsetDetectado.name()});
            Optional<ProxyRuleDTO> matched = proxyRules.stream().filter(r -> r.matches(method, path)).findFirst();
            byte[] bytesParaEnviar = bodyBytes;
            boolean bodyFoiModificado = false;
            if (matched.isPresent() && bodyBytes.length > 0) {
                ProxyRuleDTO rule = matched.get();
                String jsonPath = String.join((CharSequence)".", rule.getJsonPathSegments());
                log.info("Proxy: Regra aplicada | method={} | route={} | jsonPath={}", new Object[]{rule.getMethod(), rule.getRoute(), jsonPath});
                String bodyAsString = new String(bodyBytes, charsetDetectado);
                String cnpj = this.proxyNfeService.extrairCnpjEmitenteDoJson(bodyAsString, rule.getJsonPathSegments());
                if (!"00000000000000".equals(cnpj)) {
                    String bodyModificado = this.proxyNfeService.processarJsonComConverter(bodyAsString, cnpj, rule.getJsonPathSegments(), path, targetUrl);
                    if (bodyModificado != null && !bodyModificado.equals(bodyAsString)) {
                        bytesParaEnviar = bodyModificado.getBytes(charsetDetectado);
                        bodyFoiModificado = true;
                        log.info("Proxy: Body string original={}", (Object)bodyAsString);
                        log.info("Proxy: Body modificado | route={} | charset={} | bytesOriginal={} | bytesModificado={}", new Object[]{path, charsetDetectado.name(), bodyBytes.length, bytesParaEnviar.length});
                        XmlValidator.ValidationResult validationResult = this.validateXmlInBody(bodyModificado);
                        if (!validationResult.isValid()) {
                            log.warn("Proxy: XML com problemas detectado ap\u00f3s convers\u00e3o (requisi\u00e7\u00e3o n\u00e3o bloqueada) | erros={} | avisos={}", (Object)validationResult.getErrorMessage(), (Object)validationResult.getWarningMessage());
                        } else if (validationResult.hasWarnings()) {
                            log.info("Proxy: XML validado com avisos | avisos={}", (Object)validationResult.getWarningMessage());
                        }
                    } else {
                        log.info("Proxy: Nenhuma modifica\u00e7\u00e3o realizada | route={} | mantendo requisi\u00e7\u00e3o original", (Object)path);
                    }
                } else {
                    log.info("Proxy: CNPJ nao extraido | route={} | ignorando processamento e enviando requisicao original", (Object)path);
                }
            }
            HttpHeaders headers = new HttpHeaders();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    String headerValue = request.getHeader(headerName);
                    if (this.isRestrictedHeader(headerName)) continue;
                    headers.add(headerName, headerValue);
                }
            }
            String headersLog = headers.entrySet().stream().map(e -> (String)e.getKey() + "=[" + String.join((CharSequence)",", (Iterable)e.getValue()) + "]").collect(Collectors.joining(" | "));
            log.info("Proxy: Headers encaminhados | targetUrl={} | headers=[{}]", (Object)targetUrl, (Object)headersLog);
            headers.remove((Object)"content-length");
            if (bodyFoiModificado) {
                headers.setContentType(new MediaType(MediaType.APPLICATION_JSON.getType(), MediaType.APPLICATION_JSON.getSubtype(), charsetDetectado));
                log.info("Proxy: Content-Type ajustado | type=application/json | charset={} | motivo=body modificado", (Object)charsetDetectado.name());
            } else {
                String incomingContentType = request.getContentType();
                if (StringUtils.isNotBlank((CharSequence)incomingContentType)) {
                    try {
                        MediaType mt = MediaType.parseMediaType((String)incomingContentType);
                        if (mt.getCharset() == null) {
                            mt = new MediaType(mt.getType(), mt.getSubtype(), charsetDetectado);
                        }
                        headers.setContentType(mt);
                    }
                    catch (Exception e2) {
                        log.warn("Proxy: Content-Type inv\u00e1lido | received={} | erro={}", (Object)incomingContentType, (Object)e2.getMessage());
                    }
                }
            }
            String bodyCompleto = "";
            if (bytesParaEnviar != null && bytesParaEnviar.length > 0) {
                bodyCompleto = new String(bytesParaEnviar, charsetDetectado);
            }
            log.info("Proxy: ENVIANDO >> method={} | targetUrl={} | contentType={} | bodyModificado={} | bodyCompleto=[{}]", new Object[]{method, targetUrl, headers.getContentType(), bodyFoiModificado, bodyCompleto});
            HttpEntity entity = new HttpEntity((Object)bytesParaEnviar, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(targetUrl, method, entity, byte[].class, new Object[0]);
            String responseBody = null;
            if (response.hasBody() && response.getBody() != null) {
                Charset responseCharset = StandardCharsets.UTF_8;
                MediaType contentType = response.getHeaders().getContentType();
                if (contentType != null && contentType.getCharset() != null) {
                    responseCharset = contentType.getCharset();
                }
                responseBody = new String((byte[])response.getBody(), responseCharset);
            }
            log.info("Proxy: RECEBIDO << status={} | contentType={} | bodyBytes={} | bodyCompleto=[{}]", new Object[]{response.getStatusCode(), response.getHeaders().getContentType(), responseBody != null ? responseBody.length() : 0, responseBody != null ? responseBody : "<vazio>"});
            HttpHeaders filteredHeaders = this.filterResponseHeaders(response.getHeaders());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)response.getStatusCode()).headers(filteredHeaders)).body((Object)responseBody);
        }
        catch (HttpStatusCodeException e3) {
            try {
                String respBody = e3.getResponseBodyAsString();
                log.warn("Proxy: ERRO HTTP << status={} | statusText={} | bodyBytes={} | contentType={} | bodyCompleto=[{}]", new Object[]{e3.getStatusCode(), e3.getStatusText(), respBody != null ? respBody.length() : 0, e3.getResponseHeaders().getContentType(), StringUtils.isNotBlank((CharSequence)respBody) ? respBody : "<vazio>"});
                HttpHeaders filteredHeaders = this.filterResponseHeaders(e3.getResponseHeaders());
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)e3.getStatusCode()).headers(filteredHeaders)).body((Object)(StringUtils.isNotBlank((CharSequence)respBody) ? respBody : "Erro sem corpo de resposta"));
            }
            catch (Exception ex) {
                log.error("Proxy: Erro ao processar resposta de erro | exception={} | message={}", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
                String errorMsg = String.format("{\"erro\": \"Falha ao processar erro do servidor destino\", \"status\": \"%s\", \"mensagem\": \"%s\"}", e3.getStatusCode(), e3.getMessage());
                return ResponseEntity.status((HttpStatus)e3.getStatusCode()).body((Object)errorMsg);
            }
        }
        catch (ProxyProcessamentoException e4) {
            log.error("Proxy: Erro de processamento | cnpj={} | action={} | referencia={} | message={}", new Object[]{e4.getCnpjEmitente(), e4.getAction(), e4.getReferencia(), e4.getMessage(), e4});
            return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)String.format("{\"erro\": \"Erro no processamento do proxy\", \"mensagem\": \"%s\", \"cnpj\": \"%s\", \"action\": \"%s\", \"referencia\": \"%s\"}", e4.getMessage(), e4.getCnpjEmitente(), e4.getAction(), e4.getReferencia()));
        }
        catch (Exception e5) {
            log.error("Proxy: Erro geral | exception={} | message={}", new Object[]{e5.getClass().getSimpleName(), e5.getMessage(), e5});
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Erro interno do proxy: " + e5.getMessage()));
        }
    }

    private XmlValidator.ValidationResult validateXmlInBody(String jsonBody) {
        try {
            String xml;
            JsonNode root = this.objectMapper.readTree(jsonBody);
            if (root.isArray() && root.size() > 0) {
                root = root.get(0);
            }
            if ((xml = this.extractXmlFromJson(root)) != null && !xml.isEmpty()) {
                return XmlValidator.validate((String)xml);
            }
            log.debug("Proxy: Nenhum XML encontrado no body para valida\u00e7\u00e3o");
            return new XmlValidator.ValidationResult(true, Collections.emptyList(), Collections.emptyList());
        }
        catch (Exception e) {
            log.warn("Proxy: Erro ao validar XML no body | erro={}", (Object)e.getMessage());
            return new XmlValidator.ValidationResult(true, Collections.emptyList(), Collections.singletonList("N\u00e3o foi poss\u00edvel validar XML: " + e.getMessage()));
        }
    }

    private String extractXmlFromJson(JsonNode node) {
        String[] xmlFields;
        for (String field : xmlFields = new String[]{"xml", "txt_conteudo", "conteudo", "content"}) {
            if (!node.has(field)) continue;
            JsonNode xmlNode = node.get(field);
            if (xmlNode.isTextual()) {
                return xmlNode.asText();
            }
            if (!xmlNode.isObject() || !xmlNode.has("xml")) continue;
            return xmlNode.get("xml").asText();
        }
        if (node.isObject()) {
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String xml;
                String fieldName = (String)fieldNames.next();
                JsonNode childNode = node.get(fieldName);
                if (!childNode.isObject() || (xml = this.extractXmlFromJson(childNode)) == null || xml.isEmpty()) continue;
                return xml;
            }
        }
        return null;
    }

    private HttpHeaders filterResponseHeaders(HttpHeaders originalHeaders) {
        HttpHeaders filtered = new HttpHeaders();
        String[] restrictedResponseHeaders = new String[]{"transfer-encoding", "connection", "server", "x-powered-by"};
        originalHeaders.forEach((key, values) -> {
            boolean isRestricted = Arrays.stream(restrictedResponseHeaders).anyMatch(restricted -> restricted.equalsIgnoreCase((String)key));
            if (!isRestricted) {
                filtered.addAll(key, values);
            }
        });
        return filtered;
    }

    /*
     * Exception decompiling
     */
    private byte[] readRequestBodyAsBytes(HttpServletRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Charset detectCharset(byte[] bodyBytes, String declaredCharset) {
        String asUtf8;
        if (bodyBytes == null || bodyBytes.length == 0) {
            return StandardCharsets.UTF_8;
        }
        if (declaredCharset != null) {
            try {
                return Charset.forName(declaredCharset);
            }
            catch (Exception e) {
                log.warn("Proxy: Charset declarado inv\u00e1lido | declared={} | usando UTF-8 como fallback", (Object)declaredCharset);
            }
        }
        if ((asUtf8 = new String(bodyBytes, StandardCharsets.UTF_8)).indexOf(65533) < 0) {
            return StandardCharsets.UTF_8;
        }
        log.info("Proxy: UTF-8 inv\u00e1lido detectado | usando ISO-8859-1 como fallback");
        return StandardCharsets.ISO_8859_1;
    }

    private String obterTargetBaseUrl() {
        try {
            Config config = this.configService.buscar();
            String targetUrl = config.getProxyTargetBaseUrl();
            if (StringUtils.isBlank((CharSequence)targetUrl)) {
                log.warn("URL de destino do proxy n\u00e3o configurada, usando padr\u00e3o");
                return "https://ws.h.dfe.mastersaf.com.br";
            }
            if (targetUrl.endsWith("/")) {
                targetUrl = targetUrl.substring(0, targetUrl.length() - 1);
            }
            log.debug("Proxy: URL de destino carregada | targetUrl={}", (Object)targetUrl);
            return targetUrl;
        }
        catch (Exception e) {
            log.error("Erro ao buscar configura\u00e7\u00e3o do proxy, usando URL padr\u00e3o", (Throwable)e);
            return "https://ws.h.dfe.mastersaf.com.br";
        }
    }

    private List<ProxyRuleDTO> obterProxyRules() {
        try {
            Config config = this.configService.buscar();
            String raw = config.getProxyConfig();
            if (StringUtils.isBlank((CharSequence)raw)) {
                return Collections.emptyList();
            }
            return Arrays.stream(raw.split(";")).map(String::trim).map(ProxyRuleDTO::fromString).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Erro ao obter regras de proxy da configura\u00e7\u00e3o", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean isRestrictedHeader(String headerName) {
        String[] restrictedHeaders = new String[]{"host", "connection", "content-length", "transfer-encoding", "upgrade"};
        return Arrays.stream(restrictedHeaders).anyMatch(restricted -> restricted.equalsIgnoreCase(headerName));
    }
}

