/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.job;

import br.com.tracker.dfeconverter.job.SchedulerConfig;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class SchedulerConfig {
    @Value(value="${app.version}")
    private String appVersion;

    @Bean
    public ThreadPoolTaskScheduler taskScheduler() {
        1 scheduler = new /* Unavailable Anonymous Inner Class!! */;
        scheduler.setPoolSize(1);
        scheduler.setThreadNamePrefix("SincXmlThread-");
        scheduler.initialize();
        return scheduler;
    }

    private Runnable wrapWithMdc(Runnable task) {
        Map contextMap = MDC.getCopyOfContextMap();
        return () -> {
            try {
                if (contextMap != null) {
                    MDC.setContextMap((Map)contextMap);
                }
                MDC.put((String)"appVersion", (String)("v" + this.appVersion));
                task.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    static /* synthetic */ Runnable access$000(SchedulerConfig x0, Runnable x1) {
        return x0.wrapWithMdc(x1);
    }
}

