/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.model.dto;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;

public class ProxyRuleDTO {
    private final HttpMethod method;
    private final String route;
    private final List<String> jsonPathSegments;

    public ProxyRuleDTO(HttpMethod method, String route, List<String> jsonPathSegments) {
        this.method = method;
        this.route = route;
        this.jsonPathSegments = jsonPathSegments;
    }

    public static ProxyRuleDTO fromString(String raw) {
        if (raw == null) {
            return null;
        }
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        String[] parts = trimmed.split("\\|");
        if (parts.length != 3) {
            return null;
        }
        String methodStr = parts[0].trim().toUpperCase(Locale.ROOT);
        String route = parts[1].trim();
        String path = parts[2].trim();
        try {
            HttpMethod method = HttpMethod.valueOf((String)methodStr);
            List segments = Arrays.stream(path.split("\\.")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            if (route.isEmpty() || segments.isEmpty()) {
                return null;
            }
            return new ProxyRuleDTO(method, route, segments);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean matches(HttpMethod reqMethod, String reqPath) {
        if (reqMethod == null || reqPath == null) {
            return false;
        }
        return this.method == reqMethod && this.route.equals(reqPath);
    }

    public String toString() {
        return this.method + "|" + this.route + "|" + String.join((CharSequence)".", this.jsonPathSegments);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getRoute() {
        return this.route;
    }

    public List<String> getJsonPathSegments() {
        return this.jsonPathSegments;
    }
}

