/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.monitor;

import br.com.tracker.dfeconverter.monitor.StatusNotifier;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MonitorPastasParaProcessar {
    private static final Logger log = LoggerFactory.getLogger(MonitorPastasParaProcessar.class);
    private final List<Path> pathsToWatch;
    private WatchService watchService;
    private final ExecutorService executorService;
    private final AtomicInteger arquivosContagem;
    private volatile boolean running = true;
    private final Object watchServiceLock = new Object();
    private final StatusNotifier notifier;
    private final String appVersion;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> pendingUpdate;
    private final long debounceMs = 500L;

    public MonitorPastasParaProcessar(StatusNotifier notifier, String appVersion) {
        this.pathsToWatch = new CopyOnWriteArrayList();
        this.arquivosContagem = new AtomicInteger();
        this.executorService = Executors.newSingleThreadExecutor();
        this.notifier = notifier;
        this.appVersion = appVersion;
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException ex) {
            log.error("Erro ao inicializar WatchService: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public synchronized void startMonitoring() {
        this.executorService.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public synchronized void setDirectories(String directories) {
        List directoriesList = Arrays.stream(directories.split(";")).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        if (!MonitorPastasParaProcessar.compareListsIgnoringOrder((List)this.pathsToWatch, directoriesList)) {
            try {
                this.reRegisterAllPaths(directoriesList);
                this.updateFileCount();
            }
            catch (IOException ex) {
                log.error("Erro ao registrar diret\u00f3rios: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    public static boolean compareListsIgnoringOrder(List<Path> list1, List<Path> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        return new HashSet<Path>(list1).equals(new HashSet<Path>(list2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reRegisterAllPaths(List<Path> directories) throws IOException {
        Object object = this.watchServiceLock;
        synchronized (object) {
            HashSet<Path> newDirs = new HashSet<Path>(directories);
            this.pathsToWatch.removeIf(p -> !newDirs.contains(p));
            for (Path path : directories) {
                if (!Files.exists(path, new LinkOption[0]) || this.pathsToWatch.contains(path)) continue;
                this.pathsToWatch.add(path);
                path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                log.info("Diret\u00f3rio registrado: {}", (Object)path.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.running = false;
        try {
            Object object = this.watchServiceLock;
            synchronized (object) {
                if (this.watchService != null) {
                    this.watchService.close();
                }
            }
            this.executorService.shutdownNow();
            this.scheduler.shutdownNow();
        }
        catch (IOException ex) {
            log.error("Erro ao fechar WatchService: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void processEvents() {
        if (this.watchService == null) {
            log.warn("WatchService n\u00e3o est\u00e1 inicializado. Abandonando monitoramento.");
            return;
        }
        try {
            while (this.running) {
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (ClosedWatchServiceException cwse) {
                    if (this.running) {
                        log.error("WatchService fechado inesperadamente: {}", (Object)cwse.getMessage(), (Object)cwse);
                    }
                    break;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.arquivosContagem.incrementAndGet();
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.arquivosContagem.decrementAndGet();
                    }
                    this.queueUpdateInformativo();
                }
                boolean valid = key.reset();
                if (valid) continue;
                log.warn("Chave de monitoramento inv\u00e1lida. Encerrando monitoramento para este diret\u00f3rio.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Thread de monitoramento interrompida: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            log.error("Erro inesperado no monitoramento de diret\u00f3rios: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateFileCount() {
        int count = 0;
        for (Path path : this.pathsToWatch) {
            Stream<Path> stream = null;
            try {
                stream = Files.walk(path, new FileVisitOption[0]);
                count += (int)stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().toLowerCase().endsWith(".xml")).count();
            }
            catch (IOException ex) {
                log.error("Erro ao contar arquivos em {}: {}", new Object[]{path.toString(), ex.getMessage(), ex});
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        this.arquivosContagem.set(count);
        this.notifyStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueUpdateInformativo() {
        MonitorPastasParaProcessar monitorPastasParaProcessar = this;
        synchronized (monitorPastasParaProcessar) {
            if (this.pendingUpdate != null && !this.pendingUpdate.isDone()) {
                this.pendingUpdate.cancel(false);
            }
            this.pendingUpdate = this.scheduler.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, 500L, TimeUnit.MILLISECONDS);
        }
    }

    private void notifyStatus(boolean carregando) {
        int aguardando = this.arquivosContagem.get();
        this.notifier.onUpdate(aguardando, carregando);
    }

    static /* synthetic */ String access$000(MonitorPastasParaProcessar x0) {
        return x0.appVersion;
    }

    static /* synthetic */ void access$100(MonitorPastasParaProcessar x0) {
        x0.processEvents();
    }

    static /* synthetic */ void access$200(MonitorPastasParaProcessar x0, boolean x1) {
        x0.notifyStatus(x1);
    }
}

