/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.exception.BadRequestException;
import br.com.tracker.dfeconverter.exception.ConverterNotFoundException;
import br.com.tracker.dfeconverter.exception.IgnorarReformaTributariaException;
import br.com.tracker.dfeconverter.exception.InternalServerErrorException;
import br.com.tracker.dfeconverter.exception.NotFoundException;
import br.com.tracker.dfeconverter.exception.UnauthorizedException;
import br.com.tracker.dfeconverter.exception.XmlMalformadoException;
import br.com.tracker.dfeconverter.model.dto.ProcessamentoDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.ClasseTributariaDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterNfeDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterRelatorioDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.model.entity.Evento;
import br.com.tracker.dfeconverter.model.enums.ModuloDfeConverterEnum;
import br.com.tracker.dfeconverter.model.enums.StatusDfeConverterEnum;
import br.com.tracker.dfeconverter.model.enums.StatusEvento;
import br.com.tracker.dfeconverter.model.enums.TipoDocumento;
import br.com.tracker.dfeconverter.model.enums.TipoDocumentoImportar;
import br.com.tracker.dfeconverter.service.ArquivoService;
import br.com.tracker.dfeconverter.service.EventoService;
import br.com.tracker.dfeconverter.service.NfeService;
import br.com.tracker.dfeconverter.service.RelatorioService;
import br.com.tracker.dfeconverter.service.tracker.TrackerConvertersProvider;
import br.com.tracker.dfeconverter.service.tracker.TrackerCstCClassProvider;
import br.com.tracker.dfeconverter.util.Util;
import br.com.tracker.dfeconverter.view.components.toast.Notifications;
import br.com.tracker.dfeconverter.view.enums.PainelStatus;
import br.com.tracker.dfeconverter.view.forms.PainelTray;
import br.com.tracker.dfeconverter.view.util.PrefsUtil;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArquivoService {
    private static final Logger log = LoggerFactory.getLogger(ArquivoService.class);
    private static final String EXT_XML = ".xml";
    private static final String SUBPASTA_IGNORADOS = "ignorados";
    private static final String SUBPASTA_ERROS = "erros";
    private static final List<TipoDocumento> ORDEM_PROCESSAMENTO = Arrays.asList(TipoDocumento.NFE, TipoDocumento.CTE, TipoDocumento.NFSE);
    private final TrackerCstCClassProvider trackerCstCClassProvider;
    private final TrackerConvertersProvider convertersProvider;
    private final EventoService eventoService;
    private final NfeService nfeService;
    private final RelatorioService relatorioService;

    @Transactional
    public void verificaPastas(Config config) {
        this.registrarEvento("Iniciando verifica\u00e7\u00e3o de pastas", StatusEvento.LISTANDO_ARQUIVOS, null);
        if (StringUtils.isBlank((CharSequence)config.getPastasMonitorar())) {
            this.registrarEvento("Nenhuma pasta configurada para monitoramento", StatusEvento.IGNORADO, null);
            log.info("Nenhuma pasta configurada para monitoramento.");
            this.finalizarStatusUI();
            return;
        }
        List classesTributarias = this.trackerCstCClassProvider.getClasseTributaria();
        List converters = this.convertersProvider.getConverters(config);
        for (TipoDocumento tipoDocumento : ORDEM_PROCESSAMENTO) {
            this.processarTipoDocumento(tipoDocumento, config, converters, classesTributarias);
        }
        this.finalizarStatusUI();
    }

    private void processarTipoDocumento(TipoDocumento tipoDocumento, Config config, List<DfeConverterNfeDTO> converters, List<ClasseTributariaDTO> classesTributarias) {
        String pastasSincronizacao = this.getPastasSincronizacao(tipoDocumento, config);
        if (StringUtils.isBlank((CharSequence)pastasSincronizacao)) {
            log.debug("Pasta de sincroniza\u00e7\u00e3o n\u00e3o configurada para {}", (Object)tipoDocumento);
            return;
        }
        List arquivos = this.listaArquivosPasta(pastasSincronizacao, tipoDocumento);
        if (arquivos.isEmpty()) {
            if (TipoDocumento.NFE.equals((Object)tipoDocumento)) {
                this.registrarEvento(String.format("Nenhum arquivo %s encontrado", tipoDocumento.getDescricao()), StatusEvento.NENHUM_ARQUIVO_ENCONTRADO, tipoDocumento);
            }
            log.info("Nenhum arquivo {} encontrado.", (Object)tipoDocumento.getDescricao());
            return;
        }
        ProcessamentoDTO processamentoDTO = this.construirProcessamentoDTO(tipoDocumento, config, converters, classesTributarias);
        this.processarArquivos(arquivos, processamentoDTO);
    }

    private ProcessamentoDTO construirProcessamentoDTO(TipoDocumento tipoDocumento, Config config, List<DfeConverterNfeDTO> converters, List<ClasseTributariaDTO> classesTributarias) {
        return ProcessamentoDTO.builder().tipoDocumento(tipoDocumento).pastasSincronizacao(this.getPastasSincronizacao(tipoDocumento, config)).pastaProcessamento(this.getPastaProcessamento(tipoDocumento, config)).pastaConvertido(this.getPastaConvertido(tipoDocumento, config)).converters(converters).classesTributarias(classesTributarias).config(config).build();
    }

    private void processarArquivos(List<Path> arquivos, ProcessamentoDTO processamentoDTO) {
        TipoDocumento tipoDocumento = processamentoDTO.getTipoDocumento();
        this.registrarEvento(String.format("Encontrados %d arquivos %s para processamento", arquivos.size(), tipoDocumento.getDescricao()), StatusEvento.ARQUIVOS_ENCONTRADOS, tipoDocumento);
        int limitarLote = PrefsUtil.getState().getInt(PrefsUtil.TAMANHO_LOTE_ENVIO, 2000);
        List lotes = this.separarEmLotes(arquivos, limitarLote);
        LocalDateTime dataHoraProcessamento = LocalDateTime.now();
        ArrayList relatorioCompleto = new ArrayList();
        int contadorLote = 1;
        for (List lote : lotes) {
            this.atualizarStatusUI(String.format("Processando %s - lote %d/%d com %d arquivos", tipoDocumento.getDescricao(), contadorLote, lotes.size(), lote.size()));
            relatorioCompleto.addAll(this.processarLote(lote, processamentoDTO));
            ++contadorLote;
        }
        String pastaRelatorio = this.getPastaRelatorioParaRelatorio(processamentoDTO);
        for (DfeConverterRelatorioDTO item : relatorioCompleto) {
            this.relatorioService.appendRelatorio(item, pastaRelatorio);
        }
        this.withTray(PainelTray::carregarErroIgnorados);
    }

    private List<DfeConverterRelatorioDTO> processarLote(List<Path> lote, ProcessamentoDTO processamentoDTO) {
        ArrayList<DfeConverterRelatorioDTO> relatorioLote = new ArrayList<DfeConverterRelatorioDTO>();
        for (Path arquivo : lote) {
            try {
                relatorioLote.add(this.processarArquivoUnico(arquivo, processamentoDTO));
            }
            catch (Exception e) {
                DfeConverterRelatorioDTO erro = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).nomeArquivo(arquivo.getFileName().toString()).caminhoOrigem(arquivo.toString()).caminhoDestino("").status(StatusDfeConverterEnum.ERRO).descricaoStatus("Erro inesperado: " + e.getMessage()).tipoDocumento(processamentoDTO.getTipoDocumento()).modulo(ModuloDfeConverterEnum.PASTAS).cnpjEmitente(null).tenant(processamentoDTO.getConfig() != null ? processamentoDTO.getConfig().getTenant() : null).build();
                relatorioLote.add(erro);
                this.handleException(e, processamentoDTO.getTipoDocumento());
            }
        }
        return relatorioLote;
    }

    private DfeConverterRelatorioDTO processarArquivoUnico(Path arquivo, ProcessamentoDTO processamentoDTO) throws IOException {
        String xml = Util.leXml((String)arquivo.toString());
        String cnpjEmitente = this.nfeService.extrairCpfCnpjEmitente(xml);
        List tiposDocumento = TipoDocumentoImportar.findAllFromXml((String)xml);
        Iterator iterator = tiposDocumento.iterator();
        if (iterator.hasNext()) {
            TipoDocumentoImportar tipoDocumentoImportar = (TipoDocumentoImportar)iterator.next();
            switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$TipoDocumentoImportar[tipoDocumentoImportar.ordinal()]) {
                case 1: {
                    return this.processarArquivoNfe(arquivo, xml, processamentoDTO, cnpjEmitente);
                }
            }
            return this.processarArquivoIgnorado(xml, arquivo, processamentoDTO, cnpjEmitente, "Tipo de documento n\u00e3o implementado: " + tipoDocumentoImportar.name());
        }
        return this.processarArquivoIgnorado(xml, arquivo, processamentoDTO, cnpjEmitente, "Tipo de documento n\u00e3o identificado");
    }

    private DfeConverterRelatorioDTO processarArquivoNfe(Path arquivo, String xml, ProcessamentoDTO processamentoDTO, String cnpjEmitente) throws IOException {
        String nomeArquivo = arquivo.getFileName().toString();
        Path pastaProcessamento = Paths.get(processamentoDTO.getPastaProcessamento(), new String[0]);
        Path pastaConvertido = Paths.get(processamentoDTO.getPastaConvertido(), new String[0]);
        Files.createDirectories(pastaProcessamento, new FileAttribute[0]);
        Files.createDirectories(pastaConvertido, new FileAttribute[0]);
        String chave = null;
        try {
            try {
                chave = this.nfeService.extrairChaveNfe(xml);
                if ("CHAVE_NAO_IDENTIFICADA".equals(chave)) {
                    chave = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String xmlConvertido = this.nfeService.processarXml(xml, processamentoDTO, ModuloDfeConverterEnum.PASTAS);
            Path caminhoArquivoConvertido = pastaConvertido.resolve(nomeArquivo);
            Files.write(caminhoArquivoConvertido, xmlConvertido.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.info("Arquivo convertido: {}", (Object)caminhoArquivoConvertido);
            Path caminhoArquivoProcessado = pastaProcessamento.resolve(nomeArquivo);
            if (Files.exists(arquivo, new LinkOption[0])) {
                Files.move(arquivo, caminhoArquivoProcessado, StandardCopyOption.REPLACE_EXISTING);
                log.info("Arquivo movido para processados: {}", (Object)caminhoArquivoProcessado);
            }
            return DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).nomeArquivo(nomeArquivo).caminhoOrigem(arquivo.toString()).caminhoDestino(caminhoArquivoProcessado.toString()).status(StatusDfeConverterEnum.SUCESSO).descricaoStatus("Processado com sucesso").tipoDocumento(processamentoDTO.getTipoDocumento()).modulo(ModuloDfeConverterEnum.PASTAS).chave(chave).tenant(processamentoDTO.getConfig() != null ? processamentoDTO.getConfig().getTenant() : null).conteudoArquivo(xmlConvertido).build();
        }
        catch (XmlMalformadoException xme) {
            log.error("XML mal formado no arquivo {}: {}", (Object)nomeArquivo, (Object)xme.getMessage());
            Path pastaErros = pastaConvertido.resolve(SUBPASTA_ERROS);
            Files.createDirectories(pastaErros, new FileAttribute[0]);
            Path caminhoArquivoErro = pastaErros.resolve(nomeArquivo);
            if (Files.exists(arquivo, new LinkOption[0])) {
                Files.move(arquivo, caminhoArquivoErro, StandardCopyOption.REPLACE_EXISTING);
                log.info("Arquivo movido para erros: {}", (Object)caminhoArquivoErro);
            }
            String mensagemUsuario = "XML mal formado: " + xme.getMessage();
            String detalheTecnico = xme.getDetalheTecnico() != null ? "\n\nDetalhes t\u00e9cnicos:\n" + xme.getDetalheTecnico() : "";
            return DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).nomeArquivo(nomeArquivo).caminhoOrigem(arquivo.toString()).caminhoDestino(caminhoArquivoErro.toString()).status(StatusDfeConverterEnum.ERRO).descricaoStatus(mensagemUsuario).erroInternoStackTrace(detalheTecnico).tipoDocumento(processamentoDTO.getTipoDocumento()).modulo(ModuloDfeConverterEnum.PASTAS).chave(xme.getChaveNfe()).tenant(processamentoDTO.getConfig() != null ? processamentoDTO.getConfig().getTenant() : null).conteudoArquivo(xml).build();
        }
        catch (IgnorarReformaTributariaException ire) {
            log.info("Arquivo {} cont\u00e9m tags da reforma tribut\u00e1ria e ser\u00e1 ignorado conforme config. Arquivo movido para ignorados.", (Object)nomeArquivo);
            Path pastaIgnorados = pastaConvertido.resolve(SUBPASTA_IGNORADOS);
            Files.createDirectories(pastaIgnorados, new FileAttribute[0]);
            Path destinoIgnorado = pastaIgnorados.resolve(nomeArquivo);
            if (Files.exists(arquivo, new LinkOption[0])) {
                Files.move(arquivo, destinoIgnorado, StandardCopyOption.REPLACE_EXISTING);
                log.info("Arquivo movido para ignorados: {}", (Object)destinoIgnorado);
            }
            this.registrarEvento(String.format("Arquivo %s ignorado (cont\u00e9m tags reforma tribut\u00e1ria)", nomeArquivo), StatusEvento.IGNORADO, processamentoDTO.getTipoDocumento());
            return DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).nomeArquivo(nomeArquivo).caminhoOrigem(arquivo.toString()).caminhoDestino(destinoIgnorado.toString()).status(StatusDfeConverterEnum.IGNORADO_CONTEM_TAGS_RT).descricaoStatus("NF-e j\u00e1 cont\u00e9m campos da reforma tribut\u00e1ria").tipoDocumento(processamentoDTO.getTipoDocumento()).modulo(ModuloDfeConverterEnum.PASTAS).tenant(processamentoDTO.getConfig() != null ? processamentoDTO.getConfig().getTenant() : null).chave(chave).conteudoArquivo(xml).build();
        }
        catch (ConverterNotFoundException cnfEx) {
            String chaveCnfEx;
            Path pastaErros = pastaConvertido.resolve(SUBPASTA_ERROS);
            Files.createDirectories(pastaErros, new FileAttribute[0]);
            Path caminhoArquivoErro = pastaErros.resolve(nomeArquivo);
            if (Files.exists(arquivo, new LinkOption[0])) {
                Files.move(arquivo, caminhoArquivoErro, StandardCopyOption.REPLACE_EXISTING);
                log.info("Arquivo movido para erros: {}", (Object)caminhoArquivoErro);
            }
            if ((chaveCnfEx = cnfEx.getChaveNfe()) == null) {
                try {
                    chaveCnfEx = chave != null ? chave : this.nfeService.extrairChaveNfe(xml);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).nomeArquivo(nomeArquivo).caminhoOrigem(arquivo.toString()).caminhoDestino(caminhoArquivoErro.toString()).status(StatusDfeConverterEnum.ERRO).descricaoStatus(cnfEx.getMessage()).erroInternoStackTrace(this.getStackTraceString((Exception)((Object)cnfEx))).tipoDocumento(processamentoDTO.getTipoDocumento()).modulo(ModuloDfeConverterEnum.PASTAS).tenant(processamentoDTO.getConfig() != null ? processamentoDTO.getConfig().getTenant() : null).chave(chaveCnfEx).conteudoArquivo(xml).build();
        }
        catch (Exception ex) {
            log.error("Erro ao processar NFe: {}", (Object)ex.getMessage(), (Object)ex);
            this.registrarEvento(ex.getMessage(), StatusEvento.ERRO, TipoDocumento.NFE);
            Path pastaErros = pastaConvertido.resolve(SUBPASTA_ERROS);
            Files.createDirectories(pastaErros, new FileAttribute[0]);
            Path caminhoArquivoErro = pastaErros.resolve(nomeArquivo);
            if (Files.exists(arquivo, new LinkOption[0])) {
                Files.move(arquivo, caminhoArquivoErro, StandardCopyOption.REPLACE_EXISTING);
                log.info("Arquivo movido para erros: {}", (Object)caminhoArquivoErro);
            }
            return DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).nomeArquivo(nomeArquivo).caminhoOrigem(arquivo.toString()).caminhoDestino(caminhoArquivoErro.toString()).status(StatusDfeConverterEnum.ERRO).descricaoStatus(ex.getMessage()).erroInternoStackTrace(this.getStackTraceString(ex)).tipoDocumento(processamentoDTO.getTipoDocumento()).modulo(ModuloDfeConverterEnum.PASTAS).chave(chave).tenant(processamentoDTO.getConfig() != null ? processamentoDTO.getConfig().getTenant() : null).conteudoArquivo(xml).build();
        }
    }

    private DfeConverterRelatorioDTO processarArquivoIgnorado(String xml, Path arquivo, ProcessamentoDTO processamentoDTO, String cnpjEmitente, String motivo) throws IOException {
        String nomeArquivo = arquivo.getFileName().toString();
        Path pastaIgnorados = Paths.get(processamentoDTO.getPastaProcessamento(), SUBPASTA_IGNORADOS);
        Files.createDirectories(pastaIgnorados, new FileAttribute[0]);
        Path destinoIgnorado = pastaIgnorados.resolve(nomeArquivo);
        if (Files.exists(arquivo, new LinkOption[0])) {
            Files.move(arquivo, destinoIgnorado, StandardCopyOption.REPLACE_EXISTING);
            log.info("Arquivo movido para ignorados: {}", (Object)destinoIgnorado);
        }
        this.registrarEvento(String.format("Arquivo %s ignorado: %s", nomeArquivo, motivo), StatusEvento.IGNORADO, processamentoDTO.getTipoDocumento());
        return DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).nomeArquivo(nomeArquivo).caminhoOrigem(arquivo.toString()).caminhoDestino(destinoIgnorado.toString()).status(StatusDfeConverterEnum.IGNORADO).descricaoStatus(motivo).tipoDocumento(processamentoDTO.getTipoDocumento()).modulo(ModuloDfeConverterEnum.PASTAS).tenant(processamentoDTO.getConfig() != null ? processamentoDTO.getConfig().getTenant() : null).conteudoArquivo(xml).build();
    }

    private String getPastasSincronizacao(TipoDocumento tipoDocumento, Config config) {
        switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$TipoDocumento[tipoDocumento.ordinal()]) {
            case 1: {
                return config.getNfePastasSincronizacao();
            }
            case 2: {
                return config.getCtePastasSincronizacao();
            }
            case 3: {
                return config.getNfsePastasSincronizacao();
            }
        }
        throw new IllegalArgumentException("Tipo de documento desconhecido: " + tipoDocumento);
    }

    private String getPastaProcessamento(TipoDocumento tipoDocumento, Config config) {
        switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$TipoDocumento[tipoDocumento.ordinal()]) {
            case 1: {
                return config.getNfePastaProcessamento();
            }
            case 2: {
                return config.getCtePastaProcessamento();
            }
            case 3: {
                return config.getNfsePastaProcessamento();
            }
        }
        throw new IllegalArgumentException("Tipo de documento desconhecido: " + tipoDocumento);
    }

    private String getPastaConvertido(TipoDocumento tipoDocumento, Config config) {
        switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$TipoDocumento[tipoDocumento.ordinal()]) {
            case 1: {
                return config.getNfePastaConvertido();
            }
            case 2: {
                return config.getCtePastaConvertido();
            }
            case 3: {
                return config.getNfsePastaConvertido();
            }
        }
        throw new IllegalArgumentException("Tipo de documento desconhecido: " + tipoDocumento);
    }

    List<List<Path>> separarEmLotes(List<Path> arquivos, int tamanhoLote) {
        ArrayList<List<Path>> lotes = new ArrayList<List<Path>>();
        for (int i = 0; i < arquivos.size(); i += tamanhoLote) {
            lotes.add(arquivos.subList(i, Math.min(i + tamanhoLote, arquivos.size())));
        }
        return lotes;
    }

    private void handleException(Exception ex, TipoDocumento tipoDocumento) {
        String errorMessage = ex instanceof BadRequestException ? String.format("Erro ao fazer processamento de arquivos: Requisi\u00e7\u00e3o inv\u00e1lida. %s", ex.getMessage()) : (ex instanceof UnauthorizedException ? String.format("Erro ao fazer processamento de arquivos: N\u00e3o autorizado. %s", ex.getMessage()) : (ex instanceof NotFoundException ? String.format("Erro ao fazer processamento de arquivos: Arquivo n\u00e3o encontrado. %s", ex.getMessage()) : (ex instanceof InternalServerErrorException ? String.format("Erro ao fazer processamento do arquivo: Erro interno do servidor. %s", ex.getMessage()) : String.format("Erro ao fazer processamento do arquivo: %s", ex.getMessage()))));
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                Notifications.getInstance().show(Notifications.Type.ERROR, "Problemas ao processar arquivos!");
                Toolkit.getDefaultToolkit().beep();
            }
            catch (HeadlessException he) {
                log.debug("Headless ao tentar UI de erro: {}", (Object)he.getMessage());
            }
            catch (Exception uiEx) {
                log.debug("Falha ao exibir notifica\u00e7\u00e3o: {}", (Object)uiEx.getMessage());
            }
        }
        log.error(errorMessage, (Throwable)ex);
        this.registrarEvento(errorMessage, StatusEvento.ERRO, tipoDocumento);
    }

    private List<Path> listaArquivosPasta(String pastas, TipoDocumento tipoDocumento) {
        ArrayList<Path> arquivos = new ArrayList<Path>();
        if (StringUtils.isBlank((CharSequence)pastas)) {
            log.warn("Nenhuma pasta informada para {}", (Object)tipoDocumento);
            return arquivos;
        }
        for (String pasta : pastas.split(";")) {
            if (StringUtils.isBlank((CharSequence)pasta)) {
                log.warn("Pasta vazia detectada na configura\u00e7\u00e3o de {}", (Object)tipoDocumento);
                continue;
            }
            Path dir = Paths.get(pasta.trim(), new String[0]);
            if (Files.exists(dir, new LinkOption[0])) {
                try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().toLowerCase().endsWith(EXT_XML)).forEach(arquivos::add);
                }
                catch (IOException e) {
                    this.registrarEvento("Erro ao processar a pasta: " + pasta, StatusEvento.ERRO_AO_PROCESSAR_PASTA, tipoDocumento);
                    if (GraphicsEnvironment.isHeadless()) continue;
                    try {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    catch (HeadlessException he) {
                        log.debug("Headless ao tentar beep: {}", (Object)he.getMessage());
                    }
                }
                continue;
            }
            this.registrarEvento("Pasta inv\u00e1lida ou n\u00e3o encontrada: " + pasta, StatusEvento.ERRO_AO_PROCESSAR_PASTA, tipoDocumento);
        }
        return arquivos;
    }

    private void registrarEvento(String descricao, StatusEvento status, TipoDocumento tipo) {
        this.eventoService.save(Evento.builder().descricao(descricao).status(status).dataEvento(LocalDateTime.now()).tipoDocumento(tipo).build());
    }

    private void atualizarStatusUI(String status) {
        this.withTray(tray -> tray.setStatus(status));
    }

    private void finalizarStatusUI() {
        log.info("Finalizado opera\u00e7\u00f5es de processamento de arquivos.");
        if (GraphicsEnvironment.isHeadless()) {
            log.info("Ambiente headless detectado \u2014 pulando atualiza\u00e7\u00e3o de UI (finalizarStatusUI).");
            return;
        }
        this.withTray(tray -> {
            tray.carregarErroIgnorados();
            tray.setStatus("Finalizado opera\u00e7\u00f5es");
            tray.setStatus(PainelStatus.FINALIZADO);
        });
    }

    private String getPastaRelatorioParaRelatorio(ProcessamentoDTO processamentoDTO) {
        if (processamentoDTO == null || processamentoDTO.getConfig() == null) {
            return ".";
        }
        switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$TipoDocumento[processamentoDTO.getTipoDocumento().ordinal()]) {
            case 1: {
                return processamentoDTO.getConfig().getNfePastaRelatorio();
            }
            case 2: {
                return processamentoDTO.getConfig().getCtePastaRelatorio();
            }
            case 3: {
                return processamentoDTO.getConfig().getNfsePastaRelatorio();
            }
        }
        return processamentoDTO.getConfig().getNfePastaRelatorio();
    }

    private String getStackTraceString(Exception ex) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e) {
            return ex.getMessage();
        }
    }

    private void withTray(Consumer<PainelTray> consumer) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        try {
            PainelTray tray = PainelTray.getInstancia();
            if (tray == null) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                consumer.accept(tray);
            } else {
                SwingUtilities.invokeLater(() -> {
                    try {
                        consumer.accept(tray);
                    }
                    catch (Exception e) {
                        log.warn("Erro ao atualizar tray: {}", (Object)e.getMessage(), (Object)e);
                    }
                });
            }
        }
        catch (HeadlessException he) {
            log.debug("HeadlessException ao tentar acessar tray: {}", (Object)he.getMessage());
        }
        catch (Exception e) {
            log.debug("Falha gen\u00e9rica ao acessar tray: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public ArquivoService(TrackerCstCClassProvider trackerCstCClassProvider, TrackerConvertersProvider convertersProvider, EventoService eventoService, NfeService nfeService, RelatorioService relatorioService) {
        this.trackerCstCClassProvider = trackerCstCClassProvider;
        this.convertersProvider = convertersProvider;
        this.eventoService = eventoService;
        this.nfeService = nfeService;
        this.relatorioService = relatorioService;
    }
}

