/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.model.dto.evento.EventoQueryDTO;
import br.com.tracker.dfeconverter.model.entity.Evento;
import br.com.tracker.dfeconverter.model.enums.StatusEvento;
import br.com.tracker.dfeconverter.repository.EventoRepository;
import br.com.tracker.dfeconverter.util.SpecificationUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class EventoService {
    private static final Logger log = LoggerFactory.getLogger(EventoService.class);
    private final EventoRepository repository;

    @Transactional
    public void save(Evento evento) {
        this.repository.save((Object)evento);
    }

    @Transactional
    public void delete(Long id) {
        this.repository.findById((Object)id).ifPresent(arg_0 -> ((EventoRepository)this.repository).delete(arg_0));
    }

    @Transactional
    public void deleteAll() {
        this.repository.deleteAll();
    }

    @Transactional(readOnly=true)
    public List<Evento> findAll(EventoQueryDTO filtro) {
        return this.repository.findAll((Specification & Serializable)(registro, cq, cb) -> {
            ArrayList predicates = new ArrayList();
            SpecificationUtil.filtroLike((String)filtro.getDescricao(), (String)"descricao", (CriteriaBuilder)cb, (From)registro, predicates);
            SpecificationUtil.filtroEquals((Object)filtro.getStatus(), (String)"status", (CriteriaBuilder)cb, (From)registro, predicates);
            SpecificationUtil.filtroIn((List)filtro.getMultiStatus(), (String)"status", (CriteriaBuilder)cb, (From)registro, predicates);
            if (filtro.getDataEventoInicio() != null && filtro.getDataEventoFim() != null) {
                LocalDateTime dataInicial = filtro.getDataEventoInicio().atTime(0, 0, 0);
                LocalDateTime dataFinal = filtro.getDataEventoFim().atTime(23, 59, 59);
                SpecificationUtil.filtroDatas((LocalDateTime)dataInicial, (LocalDateTime)dataFinal, (String)"dataEvento", (CriteriaBuilder)cb, (From)registro, predicates);
            }
            return cb.and(predicates.toArray(new Predicate[0]));
        });
    }

    @Transactional(readOnly=true)
    public Long countByStatusInAndDataEventoBetween(List<StatusEvento> status, LocalDateTime dataInicial, LocalDateTime dataFinal) {
        return this.repository.countByStatusInAndDataEventoBetween(status, dataInicial, dataFinal);
    }

    public EventoService(EventoRepository repository) {
        this.repository = repository;
    }
}

