/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TCIBS;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TIBSCBSMonoTot;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TIpi;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TRed;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TTribNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TTribRegular;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import br.com.tracker.dfeconverter.exception.ConverterNotFoundException;
import br.com.tracker.dfeconverter.exception.ConverterValidacaoException;
import br.com.tracker.dfeconverter.exception.IgnorarReformaTributariaException;
import br.com.tracker.dfeconverter.exception.XmlMalformadoException;
import br.com.tracker.dfeconverter.model.dto.ProcessamentoDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.ClasseTributariaDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterNfeDTO;
import br.com.tracker.dfeconverter.model.enums.ModuloDfeConverterEnum;
import br.com.tracker.dfeconverter.service.ValidacaoTributacaoHelper;
import br.com.tracker.dfeconverter.util.Util;
import br.com.tracker.dfeconverter.util.XmlImpostoUtil;
import br.com.tracker.dfeconverter.util.XmlValidator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NfeService {
    private static final Logger log = LoggerFactory.getLogger(NfeService.class);
    private static final String TOTAL_BC_IBS_CBS = "TOTAL_BC_IBS_CBS";
    private static final String TOTAL_IBS_UF = "TOTAL_IBS_UF";
    private static final String TOTAL_IBS_MUN = "TOTAL_IBS_MUN";
    private static final String TOTAL_CBS = "TOTAL_CBS";
    private static final Pattern PATTERN_IBSCBS = Pattern.compile("(?is)<(?:\\w+:)?IBSCBS\\b");
    private static final Pattern PATTERN_IBSCBSTOT = Pattern.compile("(?is)<(?:\\w+:)?IBSCBSTot\\b");

    public String extrairCpfCnpjEmitente(String xmlNormal) {
        try {
            String xmlApenasNfe = Util.getExtrairTagContent((String)xmlNormal, (String)"NFe");
            TNFe nfeRt = (TNFe)XmlNfeUtil.xmlToObject((String)xmlApenasNfe, TNFe.class);
            return nfeRt.getInfNFe().getEmit().getCNPJ() != null ? nfeRt.getInfNFe().getEmit().getCNPJ() : nfeRt.getInfNFe().getEmit().getCPF();
        }
        catch (Exception ex) {
            log.error("Erro ao extrair CNPJ/CPF do emitente da NFe", (Throwable)ex);
            return "00000000000000";
        }
    }

    public String extrairChaveNfe(String xmlNormal) {
        try {
            String xmlApenasNfe = Util.getExtrairTagContent((String)xmlNormal, (String)"NFe");
            TNFe nfeRt = (TNFe)XmlNfeUtil.xmlToObject((String)xmlApenasNfe, TNFe.class);
            return nfeRt.getInfNFe().getId().substring(3);
        }
        catch (Exception ex) {
            log.error("Erro ao extrair chave da NFe", (Throwable)ex);
            return "CHAVE_NAO_IDENTIFICADA";
        }
    }

    public String processarXml(String xmlNormal, ProcessamentoDTO processamentoDTO, ModuloDfeConverterEnum modulo) throws NfeException, JAXBException, ConverterNotFoundException, ConverterValidacaoException, IgnorarReformaTributariaException, XmlMalformadoException {
        TNFe nfeRt;
        String xmlApenasNfe = Util.getExtrairTagContent((String)xmlNormal, (String)"NFe");
        if (xmlApenasNfe == null || xmlApenasNfe.trim().isEmpty()) {
            throw new XmlMalformadoException("XML n\u00e3o cont\u00e9m a tag <NFe> ou est\u00e1 vazio");
        }
        HashMap<String, BigDecimal> mapTotais = new HashMap<String, BigDecimal>();
        mapTotais.put("TOTAL_BC_IBS_CBS", BigDecimal.ZERO);
        mapTotais.put("TOTAL_IBS_UF", BigDecimal.ZERO);
        mapTotais.put("TOTAL_IBS_MUN", BigDecimal.ZERO);
        mapTotais.put("TOTAL_CBS", BigDecimal.ZERO);
        try {
            nfeRt = (TNFe)XmlNfeUtil.xmlToObject((String)xmlApenasNfe, TNFe.class);
        }
        catch (Exception e) {
            String mensagemAmigavel = XmlValidator.traduzirErroSax((String)e.getMessage());
            log.error("Erro ao converter XML para objeto NFe: {}", (Object)mensagemAmigavel, (Object)e);
            throw new XmlMalformadoException("Erro ao processar estrutura da NFe: " + mensagemAmigavel, null, e.getMessage());
        }
        if (nfeRt.getInfNFe() == null) {
            throw new XmlMalformadoException("XML da NFe n\u00e3o cont\u00e9m a tag <infNFe>");
        }
        if (nfeRt.getInfNFe().getEmit() == null) {
            throw new XmlMalformadoException("XML da NFe n\u00e3o cont\u00e9m informa\u00e7\u00f5es do emitente");
        }
        String cpfCnpjEmitente = nfeRt.getInfNFe().getEmit().getCNPJ() != null ? nfeRt.getInfNFe().getEmit().getCNPJ() : nfeRt.getInfNFe().getEmit().getCPF();
        String chNFe = nfeRt.getInfNFe().getId().substring(3);
        log.info("Processando NFe - Chave: {}, Emitente: {}", (Object)chNFe, (Object)cpfCnpjEmitente);
        boolean ignorarSeExistir = false;
        if (processamentoDTO != null && processamentoDTO.getConfig() != null) {
            ignorarSeExistir = processamentoDTO.getConfig().isIgnorarTagsReformaTributaria();
        }
        if (ignorarSeExistir) {
            if (PATTERN_IBSCBS.matcher(xmlApenasNfe).find() || PATTERN_IBSCBSTOT.matcher(xmlApenasNfe).find()) {
                log.info("XML j\u00e1 cont\u00e9m tags da reforma tribut\u00e1ria (detected by regex) e config indica ignorar.  ChNFe={}", (Object)chNFe);
                throw new IgnorarReformaTributariaException("NF-e j\u00e1 cont\u00e9m campos da reforma tribut\u00e1ria");
            }
            if (NfeService.hasAnyIBSCBSTagInNFe((TNFe)nfeRt) || NfeService.hasIBSCBSTot((TNFe)nfeRt)) {
                log.info("XML (JAXB) j\u00e1 cont\u00e9m tags da reforma tribut\u00e1ria e config indica ignorar. ChNFe={}", (Object)chNFe);
                throw new IgnorarReformaTributariaException("NF-e j\u00e1 cont\u00e9m campos da reforma tribut\u00e1ria");
            }
        } else if (NfeService.hasAnyIBSCBSTagInNFe((TNFe)nfeRt) || NfeService.hasIBSCBSTot((TNFe)nfeRt)) {
            log.info("XML cont\u00e9m tags IBSCBS existentes - removendo para substitui\u00e7\u00e3o (ignorarSeExistir=false). ChNFe={}", (Object)chNFe);
            NfeService.removerTagsIBSCBSExistentes((TNFe)nfeRt);
            NfeService.removerIBSCBSTotExistente((TNFe)nfeRt);
        }
        List converters = processamentoDTO.getConverters().stream().filter(c -> c.getCnpjEmitente().equals(cpfCnpjEmitente)).collect(Collectors.toList());
        String docTipo = "NFE";
        LocalDate dataNota = Util.converteStringToLocalDate((String)nfeRt.getInfNFe().getIde().getDhEmi());
        for (TNFe.InfNFe.Det det : nfeRt.getInfNFe().getDet()) {
            DfeConverterNfeDTO converter = this.getConverterByDet(det, converters, cpfCnpjEmitente, chNFe);
            ClasseTributariaDTO classeTributaria = NfeService.getClassificacaoTributaria((ProcessamentoDTO)processamentoDTO, (DfeConverterNfeDTO)converter, (LocalDate)dataNota, (String)"NFE");
            BigDecimal baseCalculo = this.calcularBaseCalculoIBSCBS(det);
            TTribNFe ibsCbs = NfeService.montaImpostosIBSCBS((DfeConverterNfeDTO)converter, (BigDecimal)baseCalculo, mapTotais, (ClasseTributariaDTO)classeTributaria, (String)chNFe);
            JAXBElement ibsCbsElement = new JAXBElement(new QName("IBSCBS"), TTribNFe.class, (Object)ibsCbs);
            det.getImposto().getContent().add(ibsCbsElement);
        }
        nfeRt.getInfNFe().getTotal().setIBSCBSTot(NfeService.preencheTotaisIbsCsb(mapTotais));
        if (processamentoDTO.getConfig().isNfeCriarTagVNFTot()) {
            BigDecimal vNfTot = new BigDecimal(nfeRt.getInfNFe().getTotal().getICMSTot().getVNF()).add((BigDecimal)mapTotais.get("TOTAL_IBS_UF")).add((BigDecimal)mapTotais.get("TOTAL_IBS_MUN")).add((BigDecimal)mapTotais.get("TOTAL_CBS"));
            nfeRt.getInfNFe().getTotal().setVNFTot(Util.getValor2Casas((BigDecimal)vNfTot));
        }
        String xmlFinalRt = XmlNfeUtil.objectToXml((Object)nfeRt);
        xmlFinalRt = xmlFinalRt.replaceFirst("<\\?\\s*xml[^>]*\\?>\\s*", "");
        if (processamentoDTO.getConfig().isPadraoSaidaTr() && ModuloDfeConverterEnum.PASTAS.equals((Object)modulo)) {
            return "<?xml version=\"1.0\"?>\n<root>\n" + xmlFinalRt + "\n</root>";
        }
        return xmlNormal.replace(xmlApenasNfe, xmlFinalRt);
    }

    static ClasseTributariaDTO getClassificacaoTributaria(ProcessamentoDTO processamentoDTO, DfeConverterNfeDTO converter, LocalDate dataNota, String docTipo) {
        ClasseTributariaDTO classeTributaria = processamentoDTO.getClassesTributarias().stream().filter(c -> c.getCodigoCst().equals(converter.getCstIbsCbs()) && c.getCodigoClassTrib() != null && c.getCodigoClassTrib().equals(converter.getCclassTrib())).findFirst().orElse(null);
        if (classeTributaria == null) {
            throw new ConverterValidacaoException("Classe Tribut\u00e1ria n\u00e3o encontrada na tabela da Sefaz para CCLASS_TRIB=" + converter.getCclassTrib());
        }
        String erroValidacao = ValidacaoTributacaoHelper.validarCstECClass((LocalDate)dataNota, (ClasseTributariaDTO)classeTributaria, (String)docTipo);
        if (erroValidacao != null) {
            throw new ConverterValidacaoException(erroValidacao);
        }
        return classeTributaria;
    }

    private BigDecimal calcularBaseCalculoIBSCBS(TNFe.InfNFe.Det det) {
        BigDecimal vProd = Util.getBigDecimalOrZero((String)det.getProd().getVProd());
        BigDecimal vFrete = Util.getBigDecimalOrZero((String)det.getProd().getVFrete());
        BigDecimal vSeg = Util.getBigDecimalOrZero((String)det.getProd().getVSeg());
        BigDecimal vOutro = Util.getBigDecimalOrZero((String)det.getProd().getVOutro());
        BigDecimal vDesc = Util.getBigDecimalOrZero((String)det.getProd().getVDesc());
        List impostos = det.getImposto().getContent();
        BigDecimal vPIS = XmlImpostoUtil.getVPIS((List)impostos);
        BigDecimal vCOFINS = XmlImpostoUtil.getVCOFINS((List)impostos);
        BigDecimal vICMS = XmlImpostoUtil.getVICMS((List)impostos);
        BigDecimal vICMSUFDest = XmlImpostoUtil.getVICMSUFDest((List)impostos);
        BigDecimal vFCP = XmlImpostoUtil.getVFCP((List)impostos);
        BigDecimal vFCPUFDest = XmlImpostoUtil.getVFCPUFDest((List)impostos);
        BigDecimal vICMSMono = XmlImpostoUtil.getVICMSMono((List)impostos);
        BigDecimal vISSQN = XmlImpostoUtil.getVISSQN((List)impostos);
        BigDecimal baseCalculo = vProd.add(vFrete).add(vSeg).add(vOutro).subtract(vDesc).subtract(vPIS).subtract(vCOFINS).subtract(vICMS).subtract(vICMSUFDest).subtract(vFCP).subtract(vFCPUFDest).subtract(vICMSMono).subtract(vISSQN);
        return baseCalculo.max(BigDecimal.ZERO);
    }

    private DfeConverterNfeDTO getConverterByDet(TNFe.InfNFe.Det det, List<DfeConverterNfeDTO> converters, String cpfCnpjEmitente, String chaveNfe) throws ConverterNotFoundException {
        String cfop = det.getProd().getCFOP();
        String ncm = det.getProd().getNCM();
        String cstIcms = null;
        String cstIpi = null;
        String cstPis = null;
        String cstCofins = null;
        if (det.getImposto() != null && det.getImposto().getContent() != null) {
            for (JAXBElement e : det.getImposto().getContent()) {
                if (e.getValue() instanceof TIpi) {
                    TIpi ipi = (TIpi)e.getValue();
                    if (ipi.getIPITrib() != null && ipi.getIPITrib().getCST() != null) {
                        cstIpi = ipi.getIPITrib().getCST();
                        continue;
                    }
                    if (ipi.getIPINT() == null || ipi.getIPINT().getCST() == null) continue;
                    cstIpi = ipi.getIPINT().getCST();
                    continue;
                }
                if (e.getValue() instanceof TNFe.InfNFe.Det.Imposto.ICMS) {
                    TNFe.InfNFe.Det.Imposto.ICMS icms = (TNFe.InfNFe.Det.Imposto.ICMS)e.getValue();
                    if (icms.getICMSSN101() != null && icms.getICMSSN101().getCSOSN() != null) {
                        cstIcms = icms.getICMSSN101().getCSOSN();
                        continue;
                    }
                    if (icms.getICMSSN102() != null && icms.getICMSSN102().getCSOSN() != null) {
                        cstIcms = icms.getICMSSN102().getCSOSN();
                        continue;
                    }
                    if (icms.getICMSSN201() != null && icms.getICMSSN201().getCSOSN() != null) {
                        cstIcms = icms.getICMSSN201().getCSOSN();
                        continue;
                    }
                    if (icms.getICMSSN202() != null && icms.getICMSSN202().getCSOSN() != null) {
                        cstIcms = icms.getICMSSN202().getCSOSN();
                        continue;
                    }
                    if (icms.getICMSSN500() != null && icms.getICMSSN500().getCSOSN() != null) {
                        cstIcms = icms.getICMSSN500().getCSOSN();
                        continue;
                    }
                    if (icms.getICMSSN900() != null && icms.getICMSSN900().getCSOSN() != null) {
                        cstIcms = icms.getICMSSN900().getCSOSN();
                        continue;
                    }
                    if (icms.getICMS00() != null && icms.getICMS00().getCST() != null) {
                        cstIcms = icms.getICMS00().getCST();
                        continue;
                    }
                    if (icms.getICMS10() != null && icms.getICMS10().getCST() != null) {
                        cstIcms = icms.getICMS10().getCST();
                        continue;
                    }
                    if (icms.getICMS20() != null && icms.getICMS20().getCST() != null) {
                        cstIcms = icms.getICMS20().getCST();
                        continue;
                    }
                    if (icms.getICMS30() != null && icms.getICMS30().getCST() != null) {
                        cstIcms = icms.getICMS30().getCST();
                        continue;
                    }
                    if (icms.getICMS40() != null && icms.getICMS40().getCST() != null) {
                        cstIcms = icms.getICMS40().getCST();
                        continue;
                    }
                    if (icms.getICMS51() != null && icms.getICMS51().getCST() != null) {
                        cstIcms = icms.getICMS51().getCST();
                        continue;
                    }
                    if (icms.getICMS60() != null && icms.getICMS60().getCST() != null) {
                        cstIcms = icms.getICMS60().getCST();
                        continue;
                    }
                    if (icms.getICMS70() != null && icms.getICMS70().getCST() != null) {
                        cstIcms = icms.getICMS70().getCST();
                        continue;
                    }
                    if (icms.getICMS90() == null || icms.getICMS90().getCST() == null) continue;
                    cstIcms = icms.getICMS90().getCST();
                    continue;
                }
                if (e.getValue() instanceof TNFe.InfNFe.Det.Imposto.PIS) {
                    TNFe.InfNFe.Det.Imposto.PIS pis = (TNFe.InfNFe.Det.Imposto.PIS)e.getValue();
                    if (pis.getPISAliq() != null && pis.getPISAliq().getCST() != null) {
                        cstPis = pis.getPISAliq().getCST();
                        continue;
                    }
                    if (pis.getPISQtde() != null && pis.getPISQtde().getCST() != null) {
                        cstPis = pis.getPISQtde().getCST();
                        continue;
                    }
                    if (pis.getPISNT() != null && pis.getPISNT().getCST() != null) {
                        cstPis = pis.getPISNT().getCST();
                        continue;
                    }
                    if (pis.getPISOutr() == null || pis.getPISOutr().getCST() == null) continue;
                    cstPis = pis.getPISOutr().getCST();
                    continue;
                }
                if (!(e.getValue() instanceof TNFe.InfNFe.Det.Imposto.COFINS)) continue;
                TNFe.InfNFe.Det.Imposto.COFINS cof = (TNFe.InfNFe.Det.Imposto.COFINS)e.getValue();
                if (cof.getCOFINSAliq() != null && cof.getCOFINSAliq().getCST() != null) {
                    cstCofins = cof.getCOFINSAliq().getCST();
                    continue;
                }
                if (cof.getCOFINSQtde() != null && cof.getCOFINSQtde().getCST() != null) {
                    cstCofins = cof.getCOFINSQtde().getCST();
                    continue;
                }
                if (cof.getCOFINSNT() != null && cof.getCOFINSNT().getCST() != null) {
                    cstCofins = cof.getCOFINSNT().getCST();
                    continue;
                }
                if (cof.getCOFINSOutr() == null || cof.getCOFINSOutr().getCST() == null) continue;
                cstCofins = cof.getCOFINSOutr().getCST();
            }
        }
        String fCstIcms = cstIcms;
        String fCstIpi = cstIpi;
        String fCstPis = cstPis;
        String fCstCofins = cstCofins;
        log.debug("Valores extra\u00eddos - CFOP: {}, CST_ICMS: {}, CST_IPI: {}, CST_PIS: {}, CST_COFINS: {}, NCM: {}", new Object[]{cfop, fCstIcms, fCstIpi, fCstPis, fCstCofins, ncm});
        return converters.stream().filter(c -> cfop.endsWith(c.getCfop()) && Util.equalsCode((String)fCstIcms, (String)c.getCstIcms()) && Util.equalsCode((String)fCstIpi, (String)c.getCstIpi()) && Util.equalsCode((String)fCstPis, (String)c.getCstPis()) && Util.equalsCode((String)fCstCofins, (String)c.getCstCofins()) && Util.equalsCode((String)ncm, (String)c.getNcm())).findFirst().orElseThrow(() -> new ConverterNotFoundException(String.format("Converter n\u00e3o encontrado para CNPJ_EMITENTE=%s, CFOP=%s%s%s%s%s%s", cpfCnpjEmitente, cfop, ", CST_ICMS/CSOSN=" + fCstIcms, ", CST_IPI=" + fCstIpi, ", CST_PIS=" + fCstPis, ", CST_COFINS=" + fCstCofins, ", NCM=" + ncm), chaveNfe, cpfCnpjEmitente));
    }

    static TIBSCBSMonoTot preencheTotaisIbsCsb(Map<String, BigDecimal> mapTotais) {
        TIBSCBSMonoTot totalIbsCbs = new TIBSCBSMonoTot();
        totalIbsCbs.setVBCIBSCBS(Util.getValor2Casas((BigDecimal)mapTotais.get("TOTAL_BC_IBS_CBS")));
        TIBSCBSMonoTot.GIBS gIbs = new TIBSCBSMonoTot.GIBS();
        TIBSCBSMonoTot.GIBS.GIBSUF gIbsUF = new TIBSCBSMonoTot.GIBS.GIBSUF();
        gIbsUF.setVDif("0.00");
        gIbsUF.setVDevTrib("0.00");
        gIbsUF.setVIBSUF(Util.getValor2Casas((BigDecimal)mapTotais.get("TOTAL_IBS_UF")));
        gIbs.setGIBSUF(gIbsUF);
        TIBSCBSMonoTot.GIBS.GIBSMun gIbsMun = new TIBSCBSMonoTot.GIBS.GIBSMun();
        gIbsMun.setVDif("0.00");
        gIbsMun.setVDevTrib("0.00");
        gIbsMun.setVIBSMun(Util.getValor2Casas((BigDecimal)mapTotais.get("TOTAL_IBS_MUN")));
        gIbs.setGIBSMun(gIbsMun);
        gIbs.setVIBS(Util.getValor2Casas((BigDecimal)mapTotais.get("TOTAL_IBS_UF").add(mapTotais.get("TOTAL_IBS_MUN"))));
        gIbs.setVCredPres("0.00");
        gIbs.setVCredPresCondSus("0.00");
        totalIbsCbs.setGIBS(gIbs);
        TIBSCBSMonoTot.GCBS gCbs = new TIBSCBSMonoTot.GCBS();
        gCbs.setVDif("0.00");
        gCbs.setVDevTrib("0.00");
        gCbs.setVCBS(Util.getValor2Casas((BigDecimal)mapTotais.get("TOTAL_CBS")));
        gCbs.setVCredPres("0.00");
        gCbs.setVCredPresCondSus("0.00");
        totalIbsCbs.setGCBS(gCbs);
        return totalIbsCbs;
    }

    static TTribNFe montaImpostosIBSCBS(DfeConverterNfeDTO converter, BigDecimal baseCalculo, Map<String, BigDecimal> mapTotais, ClasseTributariaDTO classeTributaria, String chaveNfe) throws ConverterValidacaoException {
        String cstIbsCbs = converter.getCstIbsCbs();
        String cClassTrib = converter.getCclassTrib();
        boolean somenteCstClass = false;
        if (classeTributaria != null) {
            somenteCstClass = !classeTributaria.isIndIBSCBS() && !classeTributaria.isIndIBSCBSMono() && !classeTributaria.isIndRedutorBC() && !classeTributaria.isIndDif() && !classeTributaria.isIndTransfCred();
        }
        TTribNFe ibsCbs = new TTribNFe();
        ibsCbs.setCST(cstIbsCbs);
        ibsCbs.setCClassTrib(cClassTrib);
        if (!somenteCstClass && classeTributaria != null && classeTributaria.isIndIBSCBS()) {
            TCIBS gIBSCBS = new TCIBS();
            gIBSCBS.setVBC(Util.getValor2Casas((BigDecimal)baseCalculo));
            boolean isTribRegular = classeTributaria.isIndTribRegular();
            TCIBS.GIBSUF gIBSUF = NfeService.criarGIBSUF((DfeConverterNfeDTO)converter, (ClasseTributariaDTO)classeTributaria, (BigDecimal)baseCalculo, (boolean)classeTributaria.isIndRedAliq(), (boolean)isTribRegular);
            gIBSCBS.setGIBSUF(gIBSUF);
            TCIBS.GIBSMun gIBSMun = NfeService.criarGIBSMun((DfeConverterNfeDTO)converter, (ClasseTributariaDTO)classeTributaria, (BigDecimal)baseCalculo, (boolean)classeTributaria.isIndRedAliq(), (boolean)isTribRegular);
            gIBSCBS.setGIBSMun(gIBSMun);
            gIBSCBS.setVIBS(Util.getValor2Casas((BigDecimal)new BigDecimal(gIBSUF.getVIBSUF()).add(new BigDecimal(gIBSMun.getVIBSMun()))));
            TCIBS.GCBS gCBS = NfeService.criarGCBS((DfeConverterNfeDTO)converter, (ClasseTributariaDTO)classeTributaria, (BigDecimal)baseCalculo, (boolean)classeTributaria.isIndRedAliq(), (boolean)isTribRegular);
            gIBSCBS.setGCBS(gCBS);
            if (isTribRegular) {
                TTribRegular gTribRegular = NfeService.criarGTribRegular((DfeConverterNfeDTO)converter, (BigDecimal)baseCalculo, (String)chaveNfe);
                gIBSCBS.setGTribRegular(gTribRegular);
            }
            mapTotais.merge("TOTAL_BC_IBS_CBS", baseCalculo, BigDecimal::add);
            mapTotais.merge("TOTAL_IBS_UF", new BigDecimal(gIBSUF.getVIBSUF()), BigDecimal::add);
            mapTotais.merge("TOTAL_IBS_MUN", new BigDecimal(gIBSMun.getVIBSMun()), BigDecimal::add);
            mapTotais.merge("TOTAL_CBS", new BigDecimal(gCBS.getVCBS()), BigDecimal::add);
            ibsCbs.setGIBSCBS(gIBSCBS);
        }
        return ibsCbs;
    }

    static TCIBS.GIBSUF criarGIBSUF(DfeConverterNfeDTO converter, ClasseTributariaDTO classeTributaria, BigDecimal baseCalculo, boolean exigeRedutor, boolean isTribRegular) {
        TCIBS.GIBSUF gIBSUF = new TCIBS.GIBSUF();
        BigDecimal aliq = isTribRegular ? BigDecimal.ZERO : Util.getOrZero((BigDecimal)converter.getAliqIbsUf());
        gIBSUF.setPIBSUF(Util.getValor4Casas((BigDecimal)aliq));
        BigDecimal percentRed = Util.getOrZero((BigDecimal)(classeTributaria != null ? classeTributaria.getPercentualReducaoIBS() : null));
        BigDecimal aliqEfet = aliq;
        if (exigeRedutor) {
            TRed gRed = NfeService.criarRedutor((BigDecimal)percentRed, (BigDecimal)aliq);
            gIBSUF.setGRed(gRed);
            aliqEfet = new BigDecimal(gRed.getPAliqEfet());
        }
        BigDecimal valor = baseCalculo.multiply(aliqEfet.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP));
        gIBSUF.setVIBSUF(Util.getValor2Casas((BigDecimal)valor));
        return gIBSUF;
    }

    static TCIBS.GIBSMun criarGIBSMun(DfeConverterNfeDTO converter, ClasseTributariaDTO classeTributaria, BigDecimal baseCalculo, boolean exigeRedutor, boolean isTribRegular) {
        TCIBS.GIBSMun gIBSMun = new TCIBS.GIBSMun();
        BigDecimal aliq = isTribRegular ? BigDecimal.ZERO : Util.getOrZero((BigDecimal)converter.getAliqIbsMun());
        gIBSMun.setPIBSMun(Util.getValor4Casas((BigDecimal)aliq));
        BigDecimal percentRed = Util.getOrZero((BigDecimal)(classeTributaria != null ? classeTributaria.getPercentualReducaoIBS() : null));
        BigDecimal aliqEfet = aliq;
        if (exigeRedutor) {
            TRed gRed = NfeService.criarRedutor((BigDecimal)percentRed, (BigDecimal)aliq);
            gIBSMun.setGRed(gRed);
            aliqEfet = new BigDecimal(gRed.getPAliqEfet());
        }
        BigDecimal valor = baseCalculo.multiply(aliqEfet.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP));
        gIBSMun.setVIBSMun(Util.getValor2Casas((BigDecimal)valor));
        return gIBSMun;
    }

    static TCIBS.GCBS criarGCBS(DfeConverterNfeDTO converter, ClasseTributariaDTO classeTributaria, BigDecimal baseCalculo, boolean exigeRedutor, boolean isTribRegular) {
        TCIBS.GCBS gCBS = new TCIBS.GCBS();
        BigDecimal aliq = isTribRegular ? BigDecimal.ZERO : Util.getOrZero((BigDecimal)converter.getAliqCbs());
        gCBS.setPCBS(Util.getValor4Casas((BigDecimal)aliq));
        BigDecimal percentRed = Util.getOrZero((BigDecimal)(classeTributaria != null ? classeTributaria.getPercentualReducaoCBS() : null));
        BigDecimal aliqEfet = aliq;
        if (exigeRedutor) {
            TRed gRed = NfeService.criarRedutor((BigDecimal)percentRed, (BigDecimal)aliq);
            gCBS.setGRed(gRed);
            aliqEfet = new BigDecimal(gRed.getPAliqEfet());
        }
        BigDecimal valor = baseCalculo.multiply(aliqEfet.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP));
        gCBS.setVCBS(Util.getValor2Casas((BigDecimal)valor));
        return gCBS;
    }

    static TTribRegular criarGTribRegular(DfeConverterNfeDTO converter, BigDecimal baseCalculo, String chaveNfe) throws ConverterValidacaoException {
        if (converter.getCclassTribRegular() == null || converter.getCclassTribRegular().trim().isEmpty()) {
            String mensagemErro = String.format("Tributa\u00e7\u00e3o Regular obrigat\u00f3ria mas n\u00e3o informado. Chave %s, Class. Trib. %s", chaveNfe, converter.getCclassTrib());
            log.error(mensagemErro);
            throw new ConverterValidacaoException(mensagemErro);
        }
        TTribRegular gTribRegular = new TTribRegular();
        gTribRegular.setCSTReg(converter.getCstIbsCbsRegular());
        gTribRegular.setCClassTribReg(converter.getCclassTribRegular());
        BigDecimal pAliqEfetRegIBSUF = Util.getOrZero((BigDecimal)converter.getAliqIbsUf());
        gTribRegular.setPAliqEfetRegIBSUF(Util.getValor4Casas((BigDecimal)pAliqEfetRegIBSUF));
        BigDecimal vTribRegIBSUF = baseCalculo.multiply(pAliqEfetRegIBSUF.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP));
        gTribRegular.setVTribRegIBSUF(Util.getValor2Casas((BigDecimal)vTribRegIBSUF));
        BigDecimal pAliqEfetRegIBSMun = Util.getOrZero((BigDecimal)converter.getAliqIbsMun());
        gTribRegular.setPAliqEfetRegIBSMun(Util.getValor4Casas((BigDecimal)pAliqEfetRegIBSMun));
        BigDecimal vTribRegIBSMun = baseCalculo.multiply(pAliqEfetRegIBSMun.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP));
        gTribRegular.setVTribRegIBSMun(Util.getValor2Casas((BigDecimal)vTribRegIBSMun));
        BigDecimal pAliqEfetRegCBS = Util.getOrZero((BigDecimal)converter.getAliqCbs());
        gTribRegular.setPAliqEfetRegCBS(Util.getValor4Casas((BigDecimal)pAliqEfetRegCBS));
        BigDecimal vTribRegCBS = baseCalculo.multiply(pAliqEfetRegCBS.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP));
        gTribRegular.setVTribRegCBS(Util.getValor2Casas((BigDecimal)vTribRegCBS));
        return gTribRegular;
    }

    private static TRed criarRedutor(BigDecimal percentualReducao, BigDecimal aliqOriginal) {
        TRed gRed = new TRed();
        gRed.setPRedAliq(Util.getValor4Casas((BigDecimal)percentualReducao));
        BigDecimal aliqEfet = aliqOriginal.multiply(BigDecimal.ONE.subtract(percentualReducao.divide(BigDecimal.valueOf(100L), 5, RoundingMode.HALF_UP)));
        gRed.setPAliqEfet(Util.getValor4Casas((BigDecimal)aliqEfet));
        return gRed;
    }

    private static boolean hasAnyIBSCBSTagInNFe(TNFe nfeRt) {
        if (nfeRt == null || nfeRt.getInfNFe() == null) {
            return false;
        }
        List dets = nfeRt.getInfNFe().getDet();
        if (dets == null || dets.isEmpty()) {
            return false;
        }
        for (TNFe.InfNFe.Det det : dets) {
            if (det == null || det.getImposto() == null || !NfeService.hasIBSCBSTag((TNFe.InfNFe.Det.Imposto)det.getImposto())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasIBSCBSTag(TNFe.InfNFe.Det.Imposto imposto) {
        if (imposto == null || imposto.getContent() == null) {
            return false;
        }
        for (JAXBElement elem : imposto.getContent()) {
            if (elem == null) continue;
            QName name = elem.getName();
            if (name != null && "IBSCBS".equalsIgnoreCase(name.getLocalPart())) {
                return true;
            }
            Object val = elem.getValue();
            if (!(val instanceof TTribNFe)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasIBSCBSTot(TNFe nfeRt) {
        if (nfeRt == null || nfeRt.getInfNFe() == null || nfeRt.getInfNFe().getTotal() == null) {
            return false;
        }
        return nfeRt.getInfNFe().getTotal().getIBSCBSTot() != null;
    }

    private static void removerTagsIBSCBSExistentes(TNFe nfeRt) {
        if (nfeRt == null || nfeRt.getInfNFe() == null) {
            return;
        }
        List dets = nfeRt.getInfNFe().getDet();
        if (dets == null || dets.isEmpty()) {
            return;
        }
        int totalRemovidos = 0;
        for (TNFe.InfNFe.Det det : dets) {
            List content;
            boolean removeu;
            if (det == null || det.getImposto() == null || det.getImposto().getContent() == null || !(removeu = (content = det.getImposto().getContent()).removeIf(elem -> {
                if (elem == null) {
                    return false;
                }
                QName name = elem.getName();
                if (name != null && "IBSCBS".equalsIgnoreCase(name.getLocalPart())) {
                    return true;
                }
                Object val = elem.getValue();
                return val instanceof TTribNFe;
            }))) continue;
            ++totalRemovidos;
        }
        if (totalRemovidos > 0) {
            log.info("Removidas {} tags IBSCBS existentes dos itens da NFe", (Object)totalRemovidos);
        }
    }

    private static void removerIBSCBSTotExistente(TNFe nfeRt) {
        if (nfeRt == null || nfeRt.getInfNFe() == null || nfeRt.getInfNFe().getTotal() == null) {
            return;
        }
        TNFe.InfNFe.Total total = nfeRt.getInfNFe().getTotal();
        if (total.getIBSCBSTot() != null) {
            total.setIBSCBSTot(null);
            log.info("Removido bloco IBSCBSTot existente do total da NFe");
        }
    }
}

