/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.exception.ConverterNotFoundException;
import br.com.tracker.dfeconverter.exception.IgnorarReformaTributariaException;
import br.com.tracker.dfeconverter.exception.ProxyProcessamentoException;
import br.com.tracker.dfeconverter.model.dto.ProcessamentoDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterNfeDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterRelatorioDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.model.enums.EstrategiaErroProxy;
import br.com.tracker.dfeconverter.model.enums.ModuloDfeConverterEnum;
import br.com.tracker.dfeconverter.model.enums.StatusDfeConverterEnum;
import br.com.tracker.dfeconverter.model.enums.TipoDocumento;
import br.com.tracker.dfeconverter.service.ConfigPort;
import br.com.tracker.dfeconverter.service.NfeService;
import br.com.tracker.dfeconverter.service.ProxyNfeService;
import br.com.tracker.dfeconverter.service.ProxyRelatorioService;
import br.com.tracker.dfeconverter.service.tracker.TrackerConvertersProvider;
import br.com.tracker.dfeconverter.service.tracker.TrackerCstCClassProvider;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProxyNfeService {
    private static final Logger log = LoggerFactory.getLogger(ProxyNfeService.class);
    private final NfeService nfeService;
    private final ObjectMapper objectMapper;
    private final TrackerConvertersProvider convertersProvider;
    private final TrackerCstCClassProvider trackerCstCClassProvider;
    private final ConfigPort configService;
    private final ProxyRelatorioService proxyRelatorioService;

    public String extrairCnpjEmitenteDoJson(String jsonBody, List<String> jsonPathSegments) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(jsonBody);
            JsonNode node = this.getNodeByPath(rootNode, jsonPathSegments);
            if (node == null || node.isMissingNode()) {
                log.warn("Campo {} nao encontrado no JSON", (Object)String.join((CharSequence)".", jsonPathSegments));
                return "00000000000000";
            }
            String xml = node.asText();
            return this.nfeService.extrairCpfCnpjEmitente(xml);
        }
        catch (Exception e) {
            log.error("Erro ao extrair CNPJ do emitente do JSON", (Throwable)e);
            return "00000000000000";
        }
    }

    public String processarJsonComConverter(String jsonBody, String cnpjEmitente, List<String> jsonPathSegments, String rotaInterceptada, String rotaRedirecionada) {
        long inicioProcessamento = System.currentTimeMillis();
        Config config = this.configService.buscar();
        String chaveNfe = null;
        String xmlOriginal = null;
        try {
            boolean replaced;
            String xmlProcessado;
            List convertersDisponiveis;
            JsonNode rootNode = this.objectMapper.readTree(jsonBody);
            if (!(rootNode instanceof ObjectNode)) {
                String erro = "JSON recebido nao e um objeto valido para modificacao";
                this.tratarErro(erro, null, cnpjEmitente, config, inicioProcessamento, rotaInterceptada, rotaRedirecionada, null, null);
                return jsonBody;
            }
            ObjectNode objectNode = (ObjectNode)rootNode;
            JsonNode xmlNode = this.getNodeByPath((JsonNode)objectNode, jsonPathSegments);
            if (xmlNode == null || xmlNode.isMissingNode()) {
                String erro = "Campo " + String.join((CharSequence)".", jsonPathSegments) + " nao encontrado no JSON";
                log.info(erro + ". Ignorando processamento.");
                return jsonBody;
            }
            if (xmlNode.isNull() || xmlNode.isTextual() && xmlNode.asText().trim().isEmpty()) {
                log.info("Campo {} encontrado mas esta nulo ou vazio.  Ignorando processamento.", (Object)String.join((CharSequence)".", jsonPathSegments));
                return jsonBody;
            }
            xmlOriginal = xmlNode.asText();
            log.debug("XML original extraido do JSON para CNPJ: {}", (Object)cnpjEmitente);
            try {
                if (xmlOriginal != null && !xmlOriginal.trim().isEmpty() && "CHAVE_NAO_IDENTIFICADA".equals(chaveNfe = this.nfeService.extrairChaveNfe(xmlOriginal))) {
                    chaveNfe = null;
                }
            }
            catch (Exception e) {
                log.debug("Nao foi possivel extrair chave da NFe a partir do XML original", (Throwable)e);
                chaveNfe = null;
            }
            if (config.isProxySalvarArquivoOriginal()) {
                this.salvarArquivoOriginal(xmlOriginal, cnpjEmitente, chaveNfe, config);
            }
            if ((convertersDisponiveis = this.buscarConvertersParaCnpj(cnpjEmitente)).isEmpty()) {
                String erro = "Nenhum converter encontrado para CNPJ: " + cnpjEmitente;
                this.tratarErro(erro, null, cnpjEmitente, config, inicioProcessamento, rotaInterceptada, rotaRedirecionada, chaveNfe, xmlOriginal);
                return jsonBody;
            }
            try {
                xmlProcessado = this.processarXmlSimplificado(xmlOriginal, convertersDisponiveis);
            }
            catch (IgnorarReformaTributariaException ire) {
                log.info("NFe contem tags da reforma tributaria e esta configurada para ignorar.  Chave:  {}.  Registrando e mantendo envio original.", (Object)chaveNfe);
                this.registrarIgnoradoReformaTributaria(cnpjEmitente, config, inicioProcessamento, rotaInterceptada, rotaRedirecionada, chaveNfe, xmlOriginal);
                return jsonBody;
            }
            catch (ConverterNotFoundException cnfEx) {
                String chaveDoErro = cnfEx.getChaveNfe() != null ? cnfEx.getChaveNfe() : chaveNfe;
                this.tratarErro(cnfEx.getMessage(), (Exception)((Object)cnfEx), cnpjEmitente, config, inicioProcessamento, rotaInterceptada, rotaRedirecionada, chaveDoErro, xmlOriginal);
                return jsonBody;
            }
            String motivoErroApi = this.extrairMotivoErroApi(xmlProcessado);
            if (motivoErroApi != null) {
                this.tratarErro(motivoErroApi, null, cnpjEmitente, config, inicioProcessamento, rotaInterceptada, rotaRedirecionada, chaveNfe, xmlOriginal);
                return jsonBody;
            }
            if (config.isProxySalvarArquivoConvertido()) {
                this.salvarArquivoConvertido(xmlProcessado, cnpjEmitente, chaveNfe, config);
            }
            if (!(replaced = this.putTextAtPath(objectNode, jsonPathSegments, xmlProcessado))) {
                log.error("Nao foi possivel substituir o campo {} no JSON", (Object)String.join((CharSequence)".", jsonPathSegments));
                this.tratarErro("Falha ao substituir campo no JSON", null, cnpjEmitente, config, inicioProcessamento, rotaInterceptada, rotaRedirecionada, chaveNfe, xmlOriginal);
                return jsonBody;
            }
            objectNode.put("processadoPeloConverter", true);
            objectNode.put("timestampProcessamento", System.currentTimeMillis());
            objectNode.put("cnpjProcessado", cnpjEmitente);
            objectNode.put("quantidadeConverters", convertersDisponiveis.size());
            String jsonProcessado = this.objectMapper.writeValueAsString((Object)objectNode);
            this.registrarSucesso(cnpjEmitente, config, inicioProcessamento, rotaInterceptada, rotaRedirecionada, xmlProcessado, chaveNfe);
            log.info("JSON processado com sucesso para CNPJ: {} com {} converters", (Object)cnpjEmitente, (Object)convertersDisponiveis.size());
            return jsonProcessado;
        }
        catch (Exception e) {
            log.error("Erro ao processar JSON com converter para CNPJ:  {}", (Object)cnpjEmitente, (Object)e);
            String mensagem = e.getMessage();
            if (mensagem != null && mensagem.startsWith("Erro no processamento: ")) {
                mensagem = mensagem.substring("Erro no processamento: ".length()).trim();
            }
            this.tratarErro(mensagem != null ? mensagem : "Erro no processamento", e, cnpjEmitente, config, inicioProcessamento, null, null, null, xmlOriginal);
            return jsonBody;
        }
    }

    private String extrairMotivoErroApi(String respostaApi) {
        try {
            String motivo;
            JsonNode result;
            JsonNode root = this.objectMapper.readTree(respostaApi);
            JsonNode resultArray = root.path("result");
            if (resultArray.isArray() && !resultArray.isEmpty() && (result = resultArray.get(0)).has("tipoMensagemRetorno") && result.get("tipoMensagemRetorno").asInt() == 1 && (motivo = result.path("xDescricao").asText()) != null && !motivo.isEmpty()) {
                return motivo;
            }
        }
        catch (Exception e) {
            log.debug("Nao foi possivel extrair motivo de erro da resposta da API", (Throwable)e);
        }
        return null;
    }

    private void tratarErro(String mensagemErro, Exception exception, String cnpjEmitente, Config config, long inicioProcessamento, String rotaInterceptada, String rotaRedirecionada, String chave, String conteudoArquivo) {
        this.tratarErro(mensagemErro, exception, cnpjEmitente, config, inicioProcessamento, true, rotaInterceptada, rotaRedirecionada, chave, conteudoArquivo);
    }

    private void tratarErro(String mensagemErro, Exception exception, String cnpjEmitente, Config config, long inicioProcessamento, boolean registrarRelatorio, String rotaInterceptada, String rotaRedirecionada, String chave, String conteudoArquivo) {
        String causaResumo;
        EstrategiaErroProxy estrategia = Optional.ofNullable(config.getProxyEstrategiaErro()).orElse(EstrategiaErroProxy.IGNORAR);
        String contexto = String.format("cnpj=%s, chave=%s", cnpjEmitente, chave);
        String string = causaResumo = exception != null ? exception.getClass().getSimpleName() + ": " + exception.getMessage() : "nenhuma";
        if (registrarRelatorio) {
            this.registrarErro(mensagemErro, cnpjEmitente, config, inicioProcessamento, exception, rotaInterceptada, rotaRedirecionada, chave, conteudoArquivo);
        }
        log.error("Erro no proxy | {} | motivo='{}' | causa='{}'", new Object[]{contexto, mensagemErro, causaResumo});
        boolean suprimirStackTrace = config.isProxySuprimirStackTraceAoRetornarErro();
        switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$EstrategiaErroProxy[estrategia.ordinal()]) {
            case 1: {
                throw new ProxyProcessamentoException(mensagemErro, (Throwable)exception, true, !suprimirStackTrace, cnpjEmitente, null, null, null);
            }
            case 2: {
                this.salvarArquivoErroComDetalhes(cnpjEmitente, mensagemErro, exception, config, suprimirStackTrace, chave);
                log.info("Erro salvo em pasta de erros, seguindo com arquivo original para CNPJ: {}", (Object)cnpjEmitente);
                break;
            }
            default: {
                log.info("Erro ignorado, seguindo com arquivo original para CNPJ: {}", (Object)cnpjEmitente);
            }
        }
    }

    private void salvarArquivoErroComDetalhes(String cnpjEmitente, String mensagemErro, Exception exception, Config config, boolean suprimirStackTrace, String chave) {
        try {
            Path pastaErros = Paths.get(config.getNfePastaConvertido(), "erros", "proxy");
            Files.createDirectories(pastaErros, new FileAttribute[0]);
            String nomeArquivo = this.construirNomeArquivo("erro", cnpjEmitente, chave);
            Path arquivoErro = pastaErros.resolve(nomeArquivo);
            StringBuilder sb = new StringBuilder();
            sb.append("ERRO PROCESSAMENTO PROXY\n");
            sb.append("CNPJ: ").append(cnpjEmitente).append("\n");
            sb.append("Chave: ").append(chave != null ? chave : "null").append("\n");
            sb.append("Timestamp: ").append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).append("\n");
            sb.append("Erro: ").append(mensagemErro).append("\n");
            if (exception != null && !suprimirStackTrace) {
                sb.append("\n--- STACKTRACE ---\n");
                sb.append(ExceptionUtils.getStackTrace((Throwable)exception));
            } else if (exception != null) {
                sb.append("\nCausa resumida: ").append(exception.getClass().getSimpleName()).append(": ").append(exception.getMessage()).append("\n");
            }
            Files.write(arquivoErro, sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.info("Arquivo de erro salvo:  {}", (Object)arquivoErro);
        }
        catch (IOException e) {
            log.error("Erro ao salvar arquivo de erro para CNPJ:  {}", (Object)cnpjEmitente, (Object)e);
        }
    }

    private void salvarArquivoOriginal(String xmlOriginal, String cnpjEmitente, String chave, Config config) {
        try {
            Path pastaBackup = Paths.get(config.getNfePastaProcessamento(), "backup", "proxy");
            Files.createDirectories(pastaBackup, new FileAttribute[0]);
            String nomeArquivo = this.construirNomeArquivo("original", cnpjEmitente, chave);
            Path arquivoBackup = pastaBackup.resolve(nomeArquivo);
            Files.write(arquivoBackup, xmlOriginal.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.debug("Arquivo original salvo:  {}", (Object)arquivoBackup);
        }
        catch (IOException e) {
            log.error("Erro ao salvar arquivo original para CNPJ: {}", (Object)cnpjEmitente, (Object)e);
        }
    }

    private void salvarArquivoConvertido(String xmlConvertido, String cnpjEmitente, String chave, Config config) {
        try {
            Path pastaSaida = Paths.get(config.getNfePastaConvertido(), "proxy");
            Files.createDirectories(pastaSaida, new FileAttribute[0]);
            String nomeArquivo = this.construirNomeArquivo("convertido", cnpjEmitente, chave);
            Path arquivoSaida = pastaSaida.resolve(nomeArquivo);
            Files.write(arquivoSaida, xmlConvertido.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.debug("Arquivo convertido salvo: {}", (Object)arquivoSaida);
        }
        catch (IOException e) {
            log.error("Erro ao salvar arquivo convertido para CNPJ: {}", (Object)cnpjEmitente, (Object)e);
        }
    }

    private String construirNomeArquivo(String tipo, String cnpjEmitente, String chave) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
        String chaveLimpa = chave != null ? chave.replaceAll("[^a-zA-Z0-9.-]", "_") : "sem_chave";
        return String.format("proxy-%s-%s-%s-%s.xml", tipo, timestamp, cnpjEmitente, chaveLimpa);
    }

    private void registrarSucesso(String cnpjEmitente, Config config, long inicioProcessamento, String rotaInterceptada, String rotaRedirecionada, String xmlProcessado, String chavePreferida) {
        long tempoProcessamento = System.currentTimeMillis() - inicioProcessamento;
        String chave = chavePreferida;
        try {
            if (chave == null && xmlProcessado != null && "CHAVE_NAO_IDENTIFICADA".equals(chave = this.nfeService.extrairChaveNfe(xmlProcessado))) {
                chave = null;
            }
        }
        catch (Exception ex) {
            log.debug("Nao foi possivel extrair chave no registrarSucesso", (Throwable)ex);
            chave = chave == null ? null : chave;
        }
        DfeConverterRelatorioDTO relatorio = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).tipoDocumento(TipoDocumento.NFE).status(StatusDfeConverterEnum.SUCESSO).descricaoStatus("Processado com sucesso").erroInternoStackTrace(null).modulo(ModuloDfeConverterEnum.PROXY).tenant(config != null ? config.getTenant() : null).nomeArquivo(null).caminhoOrigem(null).caminhoDestino(null).chave(chave).rotaInterceptada(rotaInterceptada).rotaRedirecionada(rotaRedirecionada).conteudoArquivo(xmlProcessado).build();
        this.proxyRelatorioService.gerarRelatorioProxyIncremental(relatorio, config.getNfePastaRelatorio());
    }

    private void registrarErro(String mensagemErro, String cnpjEmitente, Config config, long inicioProcessamento, Exception ex, String rotaInterceptada, String rotaRedirecionada, String chave, String conteudoArquivo) {
        String prefix2;
        String prefix1;
        String descricao;
        long tempoProcessamento = System.currentTimeMillis() - inicioProcessamento;
        String stack = null;
        if (ex != null) {
            try {
                stack = ExceptionUtils.getStackTrace((Throwable)ex);
            }
            catch (Exception e) {
                log.debug("Nao foi possivel obter stacktrace da exception original", (Throwable)e);
            }
        }
        if ((descricao = mensagemErro != null ? mensagemErro : "").startsWith(prefix1 = "Erro no processamento: ")) {
            descricao = descricao.substring(prefix1.length()).trim();
        }
        if (descricao.startsWith(prefix2 = "Erro no processamento do XML:")) {
            descricao = descricao.substring(prefix2.length()).trim();
        }
        if (descricao.isEmpty()) {
            descricao = mensagemErro;
        }
        DfeConverterRelatorioDTO relatorio = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).tipoDocumento(TipoDocumento.NFE).status(StatusDfeConverterEnum.ERRO).descricaoStatus(descricao).erroInternoStackTrace(stack).modulo(ModuloDfeConverterEnum.PROXY).tenant(config != null ? config.getTenant() : null).nomeArquivo(null).caminhoOrigem(null).caminhoDestino(null).chave(chave).rotaInterceptada(rotaInterceptada).rotaRedirecionada(rotaRedirecionada).conteudoArquivo(conteudoArquivo).build();
        this.proxyRelatorioService.gerarRelatorioProxyIncremental(relatorio, config.getNfePastaRelatorio());
    }

    private void registrarIgnoradoReformaTributaria(String cnpjEmitente, Config config, long inicioProcessamento, String rotaInterceptada, String rotaRedirecionada, String chave, String conteudoArquivo) {
        DfeConverterRelatorioDTO relatorio = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpjEmitente).tipoDocumento(TipoDocumento.NFE).status(StatusDfeConverterEnum.IGNORADO_CONTEM_TAGS_RT).descricaoStatus("NF-e ja contem campos da reforma tributaria").erroInternoStackTrace(null).modulo(ModuloDfeConverterEnum.PROXY).tenant(config != null ? config.getTenant() : null).nomeArquivo(null).caminhoOrigem(null).caminhoDestino(null).chave(chave).rotaInterceptada(rotaInterceptada).rotaRedirecionada(rotaRedirecionada).conteudoArquivo(conteudoArquivo).build();
        this.proxyRelatorioService.gerarRelatorioProxyIncremental(relatorio, config.getNfePastaRelatorio());
    }

    private String processarXmlSimplificado(String xmlOriginal, List<DfeConverterNfeDTO> converters) throws IgnorarReformaTributariaException, ConverterNotFoundException {
        try {
            List classesTributarias = this.trackerCstCClassProvider.getClasseTributaria();
            ProcessamentoDTO processamentoDTO = new ProcessamentoDTO();
            processamentoDTO.setConverters(converters);
            processamentoDTO.setClassesTributarias(classesTributarias);
            Config config = this.configService.buscar();
            processamentoDTO.setConfig(config);
            return this.nfeService.processarXml(xmlOriginal, processamentoDTO, ModuloDfeConverterEnum.PROXY);
        }
        catch (ConverterNotFoundException | IgnorarReformaTributariaException ire) {
            throw ire;
        }
        catch (Exception e) {
            log.error("Erro ao processar XML simplificado", (Throwable)e);
            String motivo = "Erro no processamento do XML";
            Config config = this.configService.buscar();
            boolean suprimirStackTrace = config != null && config.isProxySuprimirStackTraceAoRetornarErro();
            throw new ProxyProcessamentoException(motivo + ": " + e.getMessage(), (Throwable)e, true, !suprimirStackTrace, null, null, null, "ERR_PROCESSAMENTO_XML");
        }
    }

    private List<DfeConverterNfeDTO> buscarConvertersParaCnpj(String cnpj) {
        try {
            Config config = this.configService.buscar();
            List todosConverters = this.convertersProvider.getConverters(config);
            List<DfeConverterNfeDTO> convertersParaCnpj = todosConverters.stream().filter(converter -> cnpj.equals(converter.getCnpjEmitente())).collect(Collectors.toList());
            log.debug("Encontrados {} converters para CNPJ:  {}", (Object)convertersParaCnpj.size(), (Object)cnpj);
            return convertersParaCnpj;
        }
        catch (Exception e) {
            log.error("Erro ao buscar converters para CNPJ:  {}", (Object)cnpj, (Object)e);
            return Collections.emptyList();
        }
    }

    private JsonNode getNodeByPath(JsonNode root, List<String> pathSegments) {
        JsonNode current = root;
        for (String seg : pathSegments) {
            if (current == null) {
                return null;
            }
            current = current.path(seg);
        }
        return current;
    }

    private boolean putTextAtPath(ObjectNode root, List<String> pathSegments, String textValue) {
        if (pathSegments == null || pathSegments.isEmpty()) {
            return false;
        }
        ObjectNode parent = root;
        for (int i = 0; i < pathSegments.size() - 1; ++i) {
            String seg = pathSegments.get(i);
            JsonNode next = parent.get(seg);
            if (next == null || next.isMissingNode() || !next.isObject()) {
                return false;
            }
            parent = (ObjectNode)next;
        }
        String last = pathSegments.get(pathSegments.size() - 1);
        parent.put(last, textValue);
        return true;
    }

    public ProxyNfeService(NfeService nfeService, ObjectMapper objectMapper, TrackerConvertersProvider convertersProvider, TrackerCstCClassProvider trackerCstCClassProvider, ConfigPort configService, ProxyRelatorioService proxyRelatorioService) {
        this.nfeService = nfeService;
        this.objectMapper = objectMapper;
        this.convertersProvider = convertersProvider;
        this.trackerCstCClassProvider = trackerCstCClassProvider;
        this.configService = configService;
        this.proxyRelatorioService = proxyRelatorioService;
    }
}

