/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service.tracker;

import br.com.tracker.dfeconverter.model.dto.tracker.ClasseTributariaDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterNfeDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterRelatorioDTO;
import br.com.tracker.dfeconverter.service.tracker.TrackerFeignClient;
import br.com.tracker.dfeconverter.util.PropUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TrackerService {
    private static final Logger log = LoggerFactory.getLogger(TrackerService.class);
    @Value(value="${app.version}")
    private String versao;
    private final TrackerFeignClient client;

    public List<DfeConverterNfeDTO> converters(String tenant) {
        return this.client.converters(tenant);
    }

    public LocalDateTime ultimaAtualizacao(String tenant) {
        log.info("Consultando \u00faltima atualiza\u00e7\u00e3o para o tenant: {}", (Object)tenant);
        return this.client.ultimaAtualizacao(tenant);
    }

    public List<ClasseTributariaDTO> classeTributaria() {
        return this.client.findAllClasseTrib();
    }

    public LocalDate ultimaAtualizacao() {
        return this.client.ultimaAtualizacao();
    }

    public void saveRelatorio(DfeConverterRelatorioDTO dfeConverterRelatorioDTO) {
        dfeConverterRelatorioDTO.setVersao(this.versao);
        int port = PropUtil.getInt((String)"sync.port", (int)9393);
        dfeConverterRelatorioDTO.setPorta(Integer.valueOf(port));
        this.client.saveRelatorio(dfeConverterRelatorioDTO);
    }

    public TrackerService(TrackerFeignClient client) {
        this.client = client;
    }
}

