/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.ui;

import br.com.tracker.dfeconverter.ui.SyncUiNotifier;
import br.com.tracker.dfeconverter.view.components.toast.Notifications;
import br.com.tracker.dfeconverter.view.enums.PainelStatus;
import br.com.tracker.dfeconverter.view.forms.Eventos;
import br.com.tracker.dfeconverter.view.forms.PainelTray;
import java.awt.Toolkit;
import javax.swing.SwingUtilities;

public class SwingSyncUiNotifier
implements SyncUiNotifier {
    public void info(String msg) {
        Notifications.getInstance().show(Notifications.Type.INFO, msg);
    }

    public void error(String msg) {
        Notifications.getInstance().show(Notifications.Type.ERROR, msg);
    }

    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void setStatusCarregando() {
        SwingUtilities.invokeLater(() -> PainelTray.getInstancia().setStatus(PainelStatus.CARREGANDO));
    }

    public void setStatusFinalizado() {
        SwingUtilities.invokeLater(() -> {
            PainelTray.getInstancia().setStatus("Finalizado opera\u00e7\u00f5es");
            PainelTray.getInstancia().setStatus(PainelStatus.FINALIZADO);
        });
    }

    public void setStatusMensagem(String msg) {
        SwingUtilities.invokeLater(() -> PainelTray.getInstancia().setStatus(msg));
    }

    public void setProximaSincronizacao(String hhmm) {
        SwingUtilities.invokeLater(() -> PainelTray.getInstancia().setProximaSincronizacao(hhmm));
    }

    public void refreshEventosIfVisible() {
        SwingUtilities.invokeLater(() -> {
            if (Eventos.getInstance().isVisible()) {
                Eventos.getInstance().listarEventos();
            }
            PainelTray.getInstancia().carregarErroIgnorados();
        });
    }

    public boolean isGui() {
        return true;
    }
}

