/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PropUtil {
    private static final Logger log = LoggerFactory.getLogger(PropUtil.class);
    public static final String SYNC_PORT = "sync.port";
    public static final String SYNC_INTERVALO_MINUTOS = "sync.intervaloMinutos";
    public static final String SYNC_TAMANHO_LOTE_ENVIO = "sync.tamanhoLoteEnvio";
    public static final String SYNC_TENANT = "sync.tenant";
    public static final String SYNC_PADRAO_SAIDA_TR = "sync.padraoSaidaTr";
    public static final String SYNC_PROXY_CONFIG = "sync.proxyConfig";
    public static final String SYNC_PROXY_BASE_URL = "sync.proxyBaseUrl";
    public static final String SYNC_PROXY_ESTRATEGIA_ERRO = "sync.proxyEstrategiaErro";
    public static final String SYNC_IGNORAR_TAGS_REFORMA_TRIBUTARIA = "sync.ignorarTagsReformaTributaria";
    public static final String NFE_CRIAR_TAG_VNF_TOT = "nfe.criarTagVNFTot";
    public static final String SYNC_PROXY_SALVAR_ARQUIVO_CONVERTIDO = "sync.proxySalvarArquivoConvertido";
    public static final String SYNC_PROXY_SALVAR_ARQUIVO_ORIGINAL = "sync.proxySalvarArquivoOriginal";
    public static final String NFE_PASTAS_SINCRONIZACAO = "nfe.pastas.sincronizacao";
    public static final String NFE_PASTA_PROCESSAMENTO = "nfe.pasta.processamento";
    public static final String NFE_PASTA_CONVERTIDO = "nfe.pasta.convertido";
    public static final String NFE_PASTA_RELATORIO = "nfe.pasta.relatorio";
    public static final String CTE_PASTAS_SINCRONIZACAO = "cte.pastas.sincronizacao";
    public static final String CTE_PASTA_PROCESSAMENTO = "cte.pasta.processamento";
    public static final String CTE_PASTA_CONVERTIDO = "cte.pasta.convertido";
    public static final String CTE_PASTA_RELATORIO = "cte.pasta.relatorio";
    public static final String NFSE_PASTAS_SINCRONIZACAO = "nfse.pastas.sincronizacao";
    public static final String NFSE_PASTA_PROCESSAMENTO = "nfse.pasta.processamento";
    public static final String NFSE_PASTA_CONVERTIDO = "nfse.pasta.convertido";
    public static final String NFSE_PASTA_RELATORIO = "nfse.pasta.relatorio";
    public static final String INTERNET_PROXY_ENABLED = "internet.proxy.enabled";
    public static final String INTERNET_PROXY_HOST = "internet.proxy.host";
    public static final String INTERNET_PROXY_PORT = "internet.proxy.port";
    public static final String INTERNET_PROXY_USERNAME = "internet.proxy.username";
    public static final String INTERNET_PROXY_PASSWORD = "internet.proxy.password";
    private static Path propsPath;
    private static final Properties props;
    private static final ReentrantReadWriteLock lock;
    private static volatile boolean initialized;
    private static boolean autoSave;

    private PropUtil() {
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        try {
            propsPath = Paths.get("config.properties", new String[0]).toAbsolutePath().normalize();
            Path dir = propsPath.getParent();
            if (dir != null) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (Files.exists(propsPath, new LinkOption[0])) {
                PropUtil.loadFromDisk();
                boolean modified = PropUtil.ensureAllDefaultProperties();
                if (modified) {
                    PropUtil.saveWithComments();
                }
            } else {
                props.clear();
                PropUtil.fillDefaultProperties();
                PropUtil.saveWithComments();
            }
            initialized = true;
        }
        catch (IOException e) {
            log.error("Falha ao iniciar propriedades em {}: {}", new Object[]{propsPath, e.getMessage(), e});
        }
    }

    private static Map<String, String> getDefaultValues() {
        LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
        defaults.put("sync.port", "9393");
        defaults.put("sync.intervaloMinutos", "15");
        defaults.put("sync.tamanhoLoteEnvio", "2000");
        defaults.put("sync.tenant", "teste");
        defaults.put("sync.padraoSaidaTr", "true");
        defaults.put("sync.ignorarTagsReformaTributaria", "true");
        defaults.put("sync.proxySalvarArquivoOriginal", "true");
        defaults.put("sync.proxySalvarArquivoConvertido", "true");
        defaults.put("sync.proxyConfig", "POST|/api/nfe|txt_conteudo.xml");
        defaults.put("sync.proxyBaseUrl", "https://ws.h.dfe.mastersaf.com.br");
        defaults.put("sync.proxyEstrategiaErro", "IGNORAR");
        defaults.put("internet.proxy.enabled", "false");
        defaults.put("internet.proxy.host", "proxy.example.com");
        defaults.put("internet.proxy.port", "81");
        defaults.put("internet.proxy.username", "");
        defaults.put("internet.proxy.password", "");
        defaults.put("nfe.pastas.sincronizacao", "/dados/xmls;/var/integracao/pastaB");
        defaults.put("nfe.pasta.convertido", "/dados/saida");
        defaults.put("nfe.pasta.processamento", "/dados/processado");
        defaults.put("nfe.pasta.relatorio", "/dados/relatorio");
        defaults.put("nfe.criarTagVNFTot", "true");
        defaults.put("cte.pastas.sincronizacao", "/dados/xmls;/var/integracao/pastaB");
        defaults.put("cte.pasta.convertido", "/dados/saida");
        defaults.put("cte.pasta.processamento", "/dados/processado");
        defaults.put("cte.pasta.relatorio", "/dados/relatorio");
        defaults.put("nfse.pastas.sincronizacao", "/dados/xmls;/var/integracao/pastaB");
        defaults.put("nfse.pasta.convertido", "/dados/saida");
        defaults.put("nfse.pasta.processamento", "/dados/processado");
        defaults.put("nfse.pasta.relatorio", "/dados/relatorio");
        return defaults;
    }

    private static void fillDefaultProperties() {
        Map defaults = PropUtil.getDefaultValues();
        for (Map.Entry entry : defaults.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static boolean ensureAllDefaultProperties() {
        Map defaults = PropUtil.getDefaultValues();
        boolean modified = false;
        for (Map.Entry entry : defaults.entrySet()) {
            if (props.containsKey(entry.getKey())) continue;
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
            modified = true;
            log.info("Propriedade {} adicionada com valor padr\u00e3o: {}", entry.getKey(), entry.getValue());
        }
        return modified;
    }

    private static void saveWithComments() throws IOException {
        Path tmp = Paths.get(propsPath.toString() + ".tmp", new String[0]);
        Path parent = tmp.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(tmp, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE), StandardCharsets.UTF_8));){
            w.write("# Configuracao de inicializacao\n");
            PropUtil.writeEntry((Writer)w, (String)"sync.port", (String)props.getProperty("sync.port", "9393"));
            w.write("\n# Intervalo da sincronizacao (min)\n");
            PropUtil.writeEntry((Writer)w, (String)"sync.intervaloMinutos", (String)props.getProperty("sync.intervaloMinutos", "15"));
            PropUtil.writeEntry((Writer)w, (String)"sync.tamanhoLoteEnvio", (String)props.getProperty("sync.tamanhoLoteEnvio", "2000"));
            PropUtil.writeEntry((Writer)w, (String)"sync.tenant", (String)props.getProperty("sync.tenant", "teste"));
            w.write("\n# Aceita os valores 'true', '1' ou 'sim' para ativar saida padrao, caso contrario e considerado como 'desativado'\n");
            PropUtil.writeEntry((Writer)w, (String)"sync.padraoSaidaTr", (String)props.getProperty("sync.padraoSaidaTr", "true"));
            PropUtil.writeEntry((Writer)w, (String)"sync.ignorarTagsReformaTributaria", (String)props.getProperty("sync.ignorarTagsReformaTributaria", "true"));
            PropUtil.writeEntry((Writer)w, (String)"sync.proxySalvarArquivoOriginal", (String)props.getProperty("sync.proxySalvarArquivoOriginal", "true"));
            PropUtil.writeEntry((Writer)w, (String)"sync.proxySalvarArquivoConvertido", (String)props.getProperty("sync.proxySalvarArquivoConvertido", "true"));
            w.write("\n# Exemplo de configuracao para envio via POST para API REST pode ser adicionados mais separando por ponto e virgula ';'\n");
            w.write("# METODO|ROTA|CAMINHO_JSON_XML_NFE\n");
            PropUtil.writeEntry((Writer)w, (String)"sync.proxyConfig", (String)props.getProperty("sync.proxyConfig", "POST|/api/nfe|txt_conteudo.xml"));
            PropUtil.writeEntry((Writer)w, (String)"sync.proxyBaseUrl", (String)props.getProperty("sync.proxyBaseUrl", "https://ws.h.dfe.mastersaf.com.br"));
            w.write("# Enum com opcoes:\n");
            w.write("# - IGNORAR: Ignorar e seguir com arquivo original\n");
            w.write("# - RETORNAR_ERRO: Retornar erro via API\n");
            w.write("# - SALVAR_ERRO_E_SEGUIR: Salvar em pasta de erros e seguir com arquivo original\n");
            PropUtil.writeEntry((Writer)w, (String)"sync.proxyEstrategiaErro", (String)props.getProperty("sync.proxyEstrategiaErro", "IGNORAR"));
            w.write("\n# Configuracao de proxy de internet\n");
            PropUtil.writeEntry((Writer)w, (String)"internet.proxy.enabled", (String)props.getProperty("internet.proxy.enabled", "false"));
            PropUtil.writeEntry((Writer)w, (String)"internet.proxy.host", (String)props.getProperty("internet.proxy.host", "proxy.example.com"));
            PropUtil.writeEntry((Writer)w, (String)"internet.proxy.port", (String)props.getProperty("internet.proxy.port", "81"));
            String proxyUsername = props.getProperty("internet.proxy.username", "");
            String proxyPassword = props.getProperty("internet.proxy.password", "");
            if (proxyUsername.isEmpty()) {
                w.write("# internet.proxy.username=user\n");
            } else {
                PropUtil.writeEntry((Writer)w, (String)"internet.proxy.username", (String)proxyUsername);
            }
            if (proxyPassword.isEmpty()) {
                w.write("# internet.proxy.password=secret\n");
            } else {
                PropUtil.writeEntry((Writer)w, (String)"internet.proxy.password", (String)proxyPassword);
            }
            w.write("\n# Pastas (separe por ;)\n");
            PropUtil.writeEntry((Writer)w, (String)"nfe.pastas.sincronizacao", (String)props.getProperty("nfe.pastas.sincronizacao", "/dados/xmls;/var/integracao/pastaB"));
            PropUtil.writeEntry((Writer)w, (String)"nfe.pasta.convertido", (String)props.getProperty("nfe.pasta.convertido", "/dados/saida"));
            PropUtil.writeEntry((Writer)w, (String)"nfe.pasta.processamento", (String)props.getProperty("nfe.pasta.processamento", "/dados/processado"));
            PropUtil.writeEntry((Writer)w, (String)"nfe.pasta.relatorio", (String)props.getProperty("nfe.pasta.relatorio", "/dados/relatorio"));
            w.write("# Aceita os valores 'true', '1' ou 'sim' para ativar saida padrao, caso contrario e considerado como 'desativado'\n");
            PropUtil.writeEntry((Writer)w, (String)"nfe.criarTagVNFTot", (String)props.getProperty("nfe.criarTagVNFTot", "true"));
            w.write("\n");
            PropUtil.writeEntry((Writer)w, (String)"cte.pastas.sincronizacao", (String)props.getProperty("cte.pastas.sincronizacao", "/dados/xmls;/var/integracao/pastaB"));
            PropUtil.writeEntry((Writer)w, (String)"cte.pasta.convertido", (String)props.getProperty("cte.pasta.convertido", "/dados/saida"));
            PropUtil.writeEntry((Writer)w, (String)"cte.pasta.processamento", (String)props.getProperty("cte.pasta.processamento", "/dados/processado"));
            PropUtil.writeEntry((Writer)w, (String)"cte.pasta.relatorio", (String)props.getProperty("cte.pasta.relatorio", "/dados/relatorio"));
            w.write("\n");
            PropUtil.writeEntry((Writer)w, (String)"nfse.pastas.sincronizacao", (String)props.getProperty("nfse.pastas.sincronizacao", "/dados/xmls;/var/integracao/pastaB"));
            PropUtil.writeEntry((Writer)w, (String)"nfse.pasta.convertido", (String)props.getProperty("nfse.pasta.convertido", "/dados/saida"));
            PropUtil.writeEntry((Writer)w, (String)"nfse.pasta.processamento", (String)props.getProperty("nfse.pasta.processamento", "/dados/processado"));
            PropUtil.writeEntry((Writer)w, (String)"nfse.pasta.relatorio", (String)props.getProperty("nfse.pasta.relatorio", "/dados/relatorio"));
        }
        Files.move(tmp, propsPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
    }

    private static void ensureInit() {
        if (!initialized) {
            PropUtil.init();
        }
    }

    public static void load() throws IOException {
        if (propsPath == null) {
            PropUtil.ensureInit();
            if (initialized) {
                return;
            }
        }
        PropUtil.loadFromDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromDisk() throws IOException {
        lock.writeLock().lock();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(propsPath, new OpenOption[0]));){
            props.clear();
            props.load(in);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void save() throws IOException {
        PropUtil.ensureInit();
        lock.writeLock().lock();
        try {
            ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
            Path tmp = Paths.get(propsPath.toString() + ".tmp", new String[0]);
            PropUtil.writePropertiesTo((Path)tmp, keys, null);
            Files.move(tmp, propsPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOrdered(List<String> priorityOrder) throws IOException {
        PropUtil.ensureInit();
        lock.writeLock().lock();
        try {
            ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
            Comparator cmp = (a, b) -> {
                int ci;
                int ia = PropUtil.indexOf((List)priorityOrder, (String)a);
                int ib = PropUtil.indexOf((List)priorityOrder, (String)b);
                if (ia >= 0 || ib >= 0) {
                    if (ia < 0) {
                        return 1;
                    }
                    if (ib < 0) {
                        return -1;
                    }
                    if (ia != ib) {
                        return Integer.compare(ia, ib);
                    }
                }
                return (ci = a.compareToIgnoreCase((String)b)) != 0 ? ci : a.compareTo((String)b);
            };
            keys.sort(cmp);
            Path tmp = Paths.get(propsPath.toString() + ".tmp", new String[0]);
            PropUtil.writePropertiesTo((Path)tmp, keys, priorityOrder);
            Files.move(tmp, propsPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static void writePropertiesTo(Path tmp, List<String> keys, List<String> priorityOrder) throws IOException {
        Path parent = tmp.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(tmp, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE), StandardCharsets.UTF_8));){
            LinkedHashSet prioritySet = new LinkedHashSet(priorityOrder == null ? Collections.emptyList() : priorityOrder);
            boolean wrotePriority = false;
            for (String k : keys) {
                if (!prioritySet.contains(k)) continue;
                PropUtil.writeEntry((Writer)w, (String)k, (String)props.getProperty(k));
                wrotePriority = true;
            }
            if (wrotePriority) {
                for (String k : keys) {
                    if (prioritySet.contains(k)) continue;
                    w.write("\n");
                    break;
                }
            }
            for (String k : keys) {
                if (prioritySet.contains(k)) continue;
                PropUtil.writeEntry((Writer)w, (String)k, (String)props.getProperty(k));
            }
        }
    }

    private static int indexOf(List<String> list, String key) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!Objects.equals(list.get(i), key)) continue;
            return i;
        }
        return -1;
    }

    private static void writeEntry(Writer w, String key, String value) throws IOException {
        PropUtil.writeEscaped((Writer)w, (String)key, (boolean)true);
        w.write("=");
        PropUtil.writeEscaped((Writer)w, (String)value, (boolean)false);
        w.write("\n");
    }

    private static void writeEscaped(Writer w, String s, boolean escapeLeadingSpace) throws IOException {
        if (s == null) {
            s = "";
        }
        int len = s.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 && escapeLeadingSpace) {
                        w.write("\\ ");
                        continue block9;
                    }
                    w.write(32);
                    continue block9;
                }
                case '\\': {
                    w.write("\\\\");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        w.write("\\u");
                        w.write(PropUtil.toHex((int)(c >> 12 & 0xF)));
                        w.write(PropUtil.toHex((int)(c >> 8 & 0xF)));
                        w.write(PropUtil.toHex((int)(c >> 4 & 0xF)));
                        w.write(PropUtil.toHex((int)(c & 0xF)));
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
    }

    private static char toHex(int nibble) {
        return "0123456789ABCDEF".charAt(nibble & 0xF);
    }

    public static String get(String key, String def) {
        PropUtil.ensureInit();
        lock.readLock().lock();
        try {
            String string = props.getProperty(key, def);
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void set(String key, String value) {
        PropUtil.ensureInit();
        lock.writeLock().lock();
        try {
            props.setProperty(key, value);
            if (autoSave) {
                try {
                    PropUtil.saveOrdered((List)PropUtil.defaultPriority());
                }
                catch (IOException e) {
                    log.error("Erro ao salvar propriedades em {}: {}", new Object[]{propsPath, e.getMessage(), e});
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static boolean getBool(String key, boolean def) {
        String v = PropUtil.get((String)key, (String)Boolean.toString(def));
        return "true".equalsIgnoreCase(v) || "1".equals(v) || "yes".equalsIgnoreCase(v) || "sim".equalsIgnoreCase(v);
    }

    public static void setBool(String key, boolean value) {
        PropUtil.set((String)key, (String)Boolean.toString(value));
    }

    public static int getInt(String key, int def) {
        try {
            return Integer.parseInt(PropUtil.get((String)key, (String)Integer.toString(def)).trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static void setInt(String key, int value) {
        PropUtil.set((String)key, (String)Integer.toString(value));
    }

    public static void setAutoSave(boolean auto) {
        autoSave = auto;
    }

    public static void logAllProperties() {
        PropUtil.logAllProperties((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logAllProperties(boolean maskSensitive) {
        PropUtil.ensureInit();
        lock.readLock().lock();
        try {
            ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
            keys.sort(String.CASE_INSENSITIVE_ORDER);
            String pathInfo = propsPath != null ? propsPath.toString() : "N/A";
            StringBuilder sb = new StringBuilder();
            sb.append("Propriedades carregadas (").append(keys.size()).append(" entries) em ").append(pathInfo);
            for (String k : keys) {
                String v = props.getProperty(k);
                String out = maskSensitive ? PropUtil.maskIfSensitive((String)k, (String)v) : (v == null ? "" : v);
                sb.append("\n").append(k).append("=").append(out);
            }
            sb.append("\n");
            log.info(sb.toString());
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private static String maskIfSensitive(String key, String value) {
        boolean sensitive;
        if (value == null) {
            return "";
        }
        if (key == null) {
            return value;
        }
        String lk = key.toLowerCase(Locale.ROOT);
        boolean bl = sensitive = lk.contains("pass") || lk.contains("senha") || lk.contains("secret") || lk.contains("token") || lk.contains("key") || lk.contains("chave");
        if (!sensitive) {
            return value;
        }
        int len = value.length();
        if (len <= 4) {
            return "****";
        }
        int keep = 2;
        String start = value.substring(0, Math.min(keep, len));
        String end = value.substring(Math.max(len - keep, keep));
        return start + "****" + end;
    }

    private static List<String> defaultPriority() {
        return Arrays.asList("sync.port", "sync.intervaloMinutos", "sync.tamanhoLoteEnvio", "sync.tenant", "sync.padraoSaidaTr", "sync.ignorarTagsReformaTributaria", "sync.proxySalvarArquivoOriginal", "sync.proxySalvarArquivoConvertido", "sync.proxyConfig", "sync.proxyBaseUrl", "sync.proxyEstrategiaErro", "internet.proxy.enabled", "internet.proxy.host", "internet.proxy.port", "internet.proxy.username", "internet.proxy.password", "nfe.pastas.sincronizacao", "nfe.pasta.convertido", "nfe.pasta.processamento", "nfe.pasta.relatorio", "nfe.criarTagVNFTot", "cte.pastas.sincronizacao", "cte.pasta.convertido", "cte.pasta.processamento", "cte.pasta.relatorio", "nfse.pastas.sincronizacao", "nfse.pasta.convertido", "nfse.pasta.processamento", "nfse.pasta.relatorio");
    }

    static {
        props = new Properties();
        lock = new ReentrantReadWriteLock();
        initialized = false;
        autoSave = true;
    }
}

