/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;

public class SpecificationUtil {
    private SpecificationUtil() {
    }

    public static boolean possuiValor(Object ... valores) {
        return Arrays.stream(valores).anyMatch(Objects::nonNull);
    }

    public static void filtroDatas(LocalDate dataInicio, LocalDate dataFim, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (dataInicio != null) {
            if (dataFim != null) {
                predicates.add(cb.between((Expression)from.get(propriedade), (Comparable)dataInicio, (Comparable)dataFim));
            } else {
                predicates.add(cb.greaterThanOrEqualTo((Expression)from.get(propriedade), (Comparable)dataInicio));
            }
        } else if (dataFim != null) {
            predicates.add(cb.lessThanOrEqualTo((Expression)from.get(propriedade), (Comparable)dataFim));
        }
    }

    public static void filtroDatas(LocalDateTime dataInicio, LocalDateTime dataFim, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (dataInicio != null) {
            if (dataFim != null) {
                predicates.add(cb.between((Expression)from.get(propriedade), (Comparable)dataInicio, (Comparable)dataFim));
            } else {
                predicates.add(cb.greaterThanOrEqualTo((Expression)from.get(propriedade), (Comparable)dataInicio));
            }
        } else if (dataFim != null) {
            predicates.add(cb.lessThanOrEqualTo((Expression)from.get(propriedade), (Comparable)dataFim));
        }
    }

    public static void filtroEquals(Object filtro, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (filtro != null) {
            predicates.add(cb.equal((Expression)from.get(propriedade), filtro));
        }
    }

    public static void filtroIn(List<?> filtro, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (filtro != null && !filtro.isEmpty()) {
            predicates.add((Predicate)cb.in((Expression)from.get(propriedade)).value(filtro));
        }
    }

    public static void filtroLike(String filtro, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (StringUtils.isNotBlank((CharSequence)filtro)) {
            predicates.add(cb.like(cb.lower((Expression)from.get(propriedade)), "%" + filtro.toLowerCase() + "%"));
        }
    }

    public static void filtroIsNotNull(Boolean filtro, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (filtro != null) {
            if (filtro.booleanValue()) {
                predicates.add(cb.isNotNull((Expression)from.get(propriedade)));
            } else {
                predicates.add(cb.isNull((Expression)from.get(propriedade)));
            }
        }
    }

    public static void filtroRange(BigDecimal filtroIni, BigDecimal filtroFim, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (filtroIni != null) {
            predicates.add(cb.greaterThanOrEqualTo(from.get(propriedade).as(BigDecimal.class), (Comparable)filtroIni));
        }
        if (filtroFim != null) {
            predicates.add(cb.lessThanOrEqualTo(from.get(propriedade).as(BigDecimal.class), (Comparable)filtroFim));
        }
    }

    public static void filtroRange(Integer filtroIni, Integer filtroFim, String propriedade, CriteriaBuilder cb, From<?, ?> from, List<Predicate> predicates) {
        if (filtroIni != null) {
            predicates.add(cb.greaterThanOrEqualTo(from.get(propriedade).as(Integer.class), (Comparable)filtroIni));
        }
        if (filtroFim != null) {
            predicates.add(cb.lessThanOrEqualTo(from.get(propriedade).as(Integer.class), (Comparable)filtroFim));
        }
    }
}

