/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.util;

import br.com.tracker.dfeconverter.exception.MainException;
import br.com.tracker.dfeconverter.exception.NegocioException;
import br.com.tracker.dfeconverter.util.ObjetoUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static LocalDate converteStringToLocalDate(String s) {
        if (s == null) {
            return LocalDate.now();
        }
        if (s.contains(" ")) {
            s = s.substring(0, s.indexOf(" "));
        }
        List<String> formatos = Arrays.asList("dd/MM/yyyy", "dd-MM-yyyy", "dd.MM.yyyy", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ssXXX");
        LocalDate data = null;
        for (String formato : formatos) {
            try {
                data = LocalDate.parse(s, DateTimeFormatter.ofPattern(formato));
                break;
            }
            catch (Exception e) {
                log.debug("Erro ao tentar converter a data: " + s + " para o formato: " + formato);
            }
        }
        if (data == null) {
            log.info("Data inv\u00e1lida ou nula: " + s + ". Usando data atual.");
            return LocalDate.now();
        }
        return data;
    }

    public static BigDecimal getOrZero(BigDecimal v) {
        return v == null ? BigDecimal.ZERO : v;
    }

    public static String getExtrairTagContent(String xml, String tagName) {
        String regex = "(<" + tagName + "[^>]*>.*?</" + tagName + ">)";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(xml);
        if (matcher.find()) {
            return matcher.group(1);
        }
        String msg = String.format("Erro ao pegar Tag: %s.<br/><br/>XML: %s.<br/>", tagName, xml);
        throw new MainException(msg);
    }

    public static String leXml(String arquivo) throws IOException {
        ObjetoUtil.verifica((Object)arquivo).orElseThrow(() -> new IllegalArgumentException("Arquivo xml n\u00e3o pode ser nulo/vazio."));
        if (!Files.exists(Paths.get(arquivo, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException("Arquivo " + arquivo + " n\u00e3o encontrado.");
        }
        List<String> list = Files.readAllLines(Paths.get(arquivo, new String[0]));
        StringJoiner joiner = new StringJoiner("\n");
        list.forEach(joiner::add);
        return joiner.toString();
    }

    public static String getValor2Casas(BigDecimal valor) {
        return valor.setScale(2, RoundingMode.HALF_UP).toString();
    }

    public static String getValor4Casas(BigDecimal valor) {
        if (valor == null) {
            return "0.0000";
        }
        return valor.setScale(4, RoundingMode.HALF_UP).toString();
    }

    public static boolean hasText(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static boolean equalsCode(String xmlString, String converterString) {
        if (converterString == null || converterString.trim().isEmpty()) {
            return true;
        }
        if ("@".equalsIgnoreCase(converterString)) {
            return true;
        }
        if (xmlString == null || xmlString.trim().isEmpty()) {
            return false;
        }
        String na = xmlString.trim();
        String nb = converterString.trim();
        return na.equals(nb);
    }

    public static BigDecimal getBigDecimalOrZero(String value) {
        try {
            return value != null ? new BigDecimal(value) : BigDecimal.ZERO;
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static String getConteudoTag(String xml, String tag) throws NegocioException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
            doc.getDocumentElement().normalize();
            NodeList noLista = doc.getElementsByTagName(tag);
            Node no = noLista.item(0);
            return no.getTextContent();
        }
        catch (IOException | NullPointerException | ParserConfigurationException | SAXException e) {
            throw new NegocioException("Erro ao pegar Tag: " + tag + ". XML: " + xml + ". Erro: " + e.getMessage(), (Throwable)e);
        }
    }

    private Util() {
    }
}

