/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.util;

import br.com.tracker.dfeconverter.util.XmlValidator;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlValidator {
    private static final Logger log = LoggerFactory.getLogger(XmlValidator.class);
    private static final Pattern ENCODING_PROBLEM_PATTERN = Pattern.compile("\ufffd\ufffd");

    public static ValidationResult validate(String xml) {
        Document doc;
        String erroBasico;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList warnings = new ArrayList();
        if (xml == null || xml.trim().isEmpty()) {
            errors.add("XML vazio ou nulo");
            return new ValidationResult(false, errors, warnings);
        }
        if (ENCODING_PROBLEM_PATTERN.matcher(xml = XmlValidator.removerBOM((String)xml)).find()) {
            errors.add("Problemas de encoding detectados (caracteres \ufffd\ufffd).  Verifique charset UTF-8.");
        }
        if ((erroBasico = XmlValidator.validarEstruturaBasica((String)xml)) != null) {
            errors.add(erroBasico);
            return new ValidationResult(false, errors, warnings);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler((ErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
            doc = builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (SAXParseException e) {
            errors.add(XmlValidator.formatarErroSax((SAXParseException)e));
            return new ValidationResult(false, errors, warnings);
        }
        catch (Exception e) {
            errors.add("Erro ao validar XML: " + XmlValidator.obterMensagemAmigavel((Exception)e));
            return new ValidationResult(false, errors, warnings);
        }
        XmlValidator.checkDuplicateTags((Document)doc, errors, warnings);
        boolean isValid = errors.isEmpty();
        return new ValidationResult(isValid, errors, warnings);
    }

    public static ValidationResult validarXmlBemFormado(String xml) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList warnings = new ArrayList();
        if (xml == null || xml.trim().isEmpty()) {
            errors.add("XML vazio ou nulo");
            return new ValidationResult(false, errors, warnings);
        }
        String xmlOriginal = xml = XmlValidator.removerBOM((String)xml);
        String erroBasico = XmlValidator.validarEstruturaBasica((String)xml);
        if (erroBasico != null) {
            errors.add(erroBasico);
            XmlValidator.adicionarXmlAoFinal(errors, (String)xmlOriginal);
            return new ValidationResult(false, errors, warnings);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler((ErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
            builder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            if (!errors.isEmpty()) {
                XmlValidator.adicionarXmlAoFinal(errors, (String)xmlOriginal);
                return new ValidationResult(false, errors, warnings);
            }
            if (!warnings.isEmpty()) {
                log.debug("Avisos na valida\u00e7\u00e3o do XML: {}", (Object)String.join((CharSequence)"; ", warnings));
            }
            return new ValidationResult(true, errors, warnings);
        }
        catch (SAXParseException e) {
            errors.add(XmlValidator.formatarErroSax((SAXParseException)e));
            XmlValidator.adicionarXmlAoFinal(errors, (String)xmlOriginal);
            return new ValidationResult(false, errors, warnings);
        }
        catch (Exception e) {
            errors.add("Erro ao validar XML: " + XmlValidator.obterMensagemAmigavel((Exception)e));
            XmlValidator.adicionarXmlAoFinal(errors, (String)xmlOriginal);
            return new ValidationResult(false, errors, warnings);
        }
    }

    private static void adicionarXmlAoFinal(List<String> errors, String xml) {
        errors.add("XML que causou o problema: " + xml);
    }

    private static String validarEstruturaBasica(String xml) {
        int fechaTag;
        if (!(xml = xml.trim()).startsWith("<")) {
            return "XML inv\u00e1lido: n\u00e3o come\u00e7a com uma tag v\u00e1lida";
        }
        int abreTag = XmlValidator.contarOcorrencias((String)xml, (String)"<");
        if (abreTag != (fechaTag = XmlValidator.contarOcorrencias((String)xml, (String)">"))) {
            return String.format("XML inv\u00e1lido: tags desbalanceadas (encontradas %d aberturas '<' e %d fechamentos '>')", abreTag, fechaTag);
        }
        if (xml.contains("\u0000")) {
            return "XML cont\u00e9m caracteres nulos inv\u00e1lidos";
        }
        if (!xml.contains("</")) {
            return "XML inv\u00e1lido: nenhuma tag de fechamento encontrada";
        }
        return null;
    }

    private static void checkDuplicateTags(Document doc, List<String> errors, List<String> warnings) {
        try {
            String[] tagsToCheck;
            for (String tagName : tagsToCheck = new String[]{"IBSCBS", "ICMS", "IPI", "PIS", "COFINS"}) {
                NodeList nodes = doc.getElementsByTagName(tagName);
                if (nodes.getLength() <= 1) continue;
                HashMap<String, Integer> parentCounts = new HashMap<String, Integer>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element el = (Element)nodes.item(i);
                    String parentName = el.getParentNode().getNodeName();
                    parentCounts.put(parentName, parentCounts.getOrDefault(parentName, 0) + 1);
                }
                for (Map.Entry entry : parentCounts.entrySet()) {
                    if ((Integer)entry.getValue() <= 1) continue;
                    errors.add(String.format("Tag <%s> duplicada dentro de <%s> (%d ocorr\u00eancias).  Estrutura inv\u00e1lida.", tagName, entry.getKey(), entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            warnings.add("Erro ao verificar tags duplicadas: " + e.getMessage());
        }
    }

    private static String formatarErroSax(SAXParseException e) {
        StringBuilder msg = new StringBuilder();
        msg.append("Erro na estrutura do XML");
        if (e.getLineNumber() > 0) {
            msg.append(" (linha ").append(e.getLineNumber());
            if (e.getColumnNumber() > 0) {
                msg.append(", coluna ").append(e.getColumnNumber());
            }
            msg.append(")");
        }
        msg.append(": ");
        String mensagemOriginal = e.getMessage();
        String mensagemAmigavel = XmlValidator.traduzirErroSax((String)mensagemOriginal);
        msg.append(mensagemAmigavel);
        return msg.toString();
    }

    public static String traduzirErroSax(String mensagemOriginal) {
        if (mensagemOriginal == null) {
            return "Erro desconhecido";
        }
        String lower = mensagemOriginal.toLowerCase();
        if (lower.contains("content of elements must consist of well-formed")) {
            return "Conte\u00fado do XML cont\u00e9m caracteres ou formata\u00e7\u00e3o inv\u00e1lidos.  Verifique se n\u00e3o h\u00e1 caracteres especiais mal codificados ou tags mal formadas.";
        }
        if (lower.contains("unexpected end of file") || lower.contains("premature end of file")) {
            return "XML est\u00e1 incompleto ou foi cortado prematuramente";
        }
        if (lower.contains("element type") && lower.contains("must be followed by")) {
            return "Tag XML mal formada.  Verifique se todas as tags est\u00e3o fechadas corretamente";
        }
        if (lower.contains("attribute") && lower.contains("was already specified")) {
            return "Atributo duplicado encontrado em uma tag";
        }
        if (lower.contains("entity") && lower.contains("not found")) {
            return "Entidade XML n\u00e3o reconhecida ou n\u00e3o declarada";
        }
        if (lower.contains("encoding")) {
            return "Problema com a codifica\u00e7\u00e3o de caracteres do XML.  Certifique-se de usar UTF-8";
        }
        if (lower.contains("whitespace") && lower.contains("required")) {
            return "Falta espa\u00e7o obrigat\u00f3rio entre elementos do XML";
        }
        if (lower.contains("mismatched tag")) {
            return "Tags de abertura e fechamento n\u00e3o correspondem";
        }
        return mensagemOriginal;
    }

    private static String obterMensagemAmigavel(Exception e) {
        String msg = e.getMessage();
        if (msg == null || msg.trim().isEmpty()) {
            return "Formato do arquivo inv\u00e1lido";
        }
        if (msg.length() > 200) {
            msg = msg.substring(0, 200) + "...";
        }
        return msg;
    }

    private static String removerBOM(String xml) {
        if (xml == null || xml.isEmpty()) {
            return xml;
        }
        try {
            String hex;
            byte[] bytes = xml.getBytes(StandardCharsets.ISO_8859_1);
            if (bytes.length >= 3 && "efbbbf".equalsIgnoreCase(hex = String.format("%02x%02x%02x", bytes[0] & 0xFF, bytes[1] & 0xFF, bytes[2] & 0xFF))) {
                byte[] semBom = new byte[bytes.length - 3];
                System.arraycopy(bytes, 3, semBom, 0, semBom.length);
                return new String(semBom, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            log.debug("Erro ao remover BOM via bytes, tentando m\u00e9todo alternativo", (Throwable)e);
        }
        if (xml.length() > 0 && xml.charAt(0) == '\ufeff') {
            return xml.substring(1);
        }
        return xml;
    }

    private static int contarOcorrencias(String texto, String busca) {
        int count = 0;
        int index = 0;
        while ((index = texto.indexOf(busca, index)) != -1) {
            ++count;
            index += busca.length();
        }
        return count;
    }

    static /* synthetic */ String access$000(SAXParseException x0) {
        return XmlValidator.formatarErroSax((SAXParseException)x0);
    }
}

