/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.button;

import br.com.tracker.dfeconverter.view.util.FontUtil;
import br.com.tracker.dfeconverter.view.util.TrackerUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JButton;

public class Button
extends JButton {
    private String svgIconPath;
    private String svgIconScale = "md";

    public Button() {
        this(null);
    }

    public Button(String text) {
        super(text);
        super.setCursor(new Cursor(12));
        super.setPreferredSize(new Dimension(135, 35));
        super.setMinimumSize(new Dimension(130, 35));
        super.setMaximumSize(new Dimension(135, 35));
        super.setFont(FontUtil.getFontButton());
        this.setarIcone();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setarIcone();
    }

    public void setSvgIconScale(String svgIconScale) {
        this.svgIconScale = svgIconScale;
        this.setarIcone();
    }

    public String getSvgIconScale() {
        return this.svgIconScale;
    }

    public void setSvgIconPath(String svgIconPath) {
        this.svgIconPath = svgIconPath;
        this.setarIcone();
    }

    private void setarIcone() {
        if (this.svgIconPath != null && !this.svgIconPath.isEmpty()) {
            float scale;
            Color color = this.getForeground();
            if (this.svgIconScale != null && !this.svgIconScale.isEmpty()) {
                switch (this.svgIconScale.toLowerCase()) {
                    case "lg": {
                        scale = 1.5f;
                        break;
                    }
                    case "md": {
                        scale = 1.0f;
                        break;
                    }
                    case "sm": {
                        scale = 0.85f;
                        break;
                    }
                    case "xs": {
                        scale = 0.7f;
                        break;
                    }
                    default: {
                        scale = 1.0f;
                        break;
                    }
                }
            } else {
                scale = 1.0f;
            }
            Icon icon = TrackerUtil.createIcon((String)this.svgIconPath, (Color)color, (float)scale);
            this.setIcon(icon);
        }
    }

    public String getSvgIconPath() {
        return this.svgIconPath;
    }
}

