/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.date;

import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelection;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.PanelDate;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.SingleDate;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ButtonDate
extends JButton {
    private final DateSelection dateSelection;
    private final SingleDate date;
    private boolean press;
    private boolean hover;
    private int rowIndex;

    public ButtonDate(DateSelection dateSelection, SingleDate date, boolean enable, int rowIndex) {
        this.dateSelection = dateSelection;
        this.date = date;
        this.rowIndex = rowIndex;
        this.setText(date.getDay() + "");
        this.init(enable);
    }

    private void init(boolean enable) {
        this.setContentAreaFilled(false);
        this.addActionListener(e -> {
            this.dateSelection.selectDate(this.date);
            this.hover = false;
            PanelDate panelDate = (PanelDate)this.getParent();
            panelDate.checkSelection();
            this.getParent().repaint();
        });
        this.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        if (enable) {
            this.putClientProperty((Object)"FlatLaf.style", (Object)"margin:7,7,7,7;focusWidth:2;selectedForeground:contrast($Component.accentColor,$Button.background,#fff)");
        } else {
            this.putClientProperty((Object)"FlatLaf.style", (Object)"margin:7,7,7,7;focusWidth:2;selectedForeground:contrast($Component.accentColor,$Button.background,#fff);foreground:$Button.disabledText");
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        FlatUIUtils.setRenderingHints((Graphics)g2);
        double width = this.getWidth();
        double height = this.getHeight();
        double size = Math.min(width, height) - (double)UIScale.scale((int)7);
        double x = (width - size) / 2.0;
        double y = (height - size) / 2.0;
        g2.setColor(this.getColor());
        g2.fill(new Ellipse2D.Double(x, y, size, size));
        if (this.dateSelection.dateSelectionMode == DatePicker.DateSelectionMode.BETWEEN_DATE_SELECTED && this.dateSelection.getDate() != null) {
            g2.setColor(this.getBetweenDateColor());
            if (this.date.between(this.dateSelection.getDate(), this.getToDate())) {
                if (this.rowIndex == 0) {
                    g2.fill(this.getShape(x, y, width, size, true, true));
                } else if (this.rowIndex == 6) {
                    g2.fill(this.getShape(x, y, width, size, false, true));
                } else {
                    g2.fill(new Rectangle2D.Double(0.0, y, width, size));
                }
            }
            if (!this.dateSelection.getDate().same(this.getToDate())) {
                boolean right = this.dateSelection.getDate().before(this.getToDate());
                if (this.date.same(this.dateSelection.getDate()) && (right && this.rowIndex != 6 || !right && this.rowIndex != 0)) {
                    g2.fill(this.getShape(x, y, width, size, right, false));
                }
                if (this.date.same(this.getToDate()) && (right && this.rowIndex != 0 || !right && this.rowIndex != 6)) {
                    g2.fill(this.getShape(x, y, width, size, !right, !this.hover && this.dateSelection.getToDate() == null));
                }
            }
        }
        if (this.date.same(new SingleDate())) {
            boolean isSelected = this.isDateSelected();
            double space = Math.min(width, height) - (double)UIScale.scale((int)(isSelected ? 2 : 7));
            double xx = (width - space) / 2.0;
            double yy = (height - space) / 2.0;
            Area area = new Area(new Ellipse2D.Double(xx, yy, space, space));
            if (isSelected) {
                float s = UIScale.scale((int)1);
                area.subtract(new Area(new Ellipse2D.Double(x + (double)s, y + (double)s, size - (double)(s * 2.0f), size - (double)(s * 2.0f))));
            } else {
                float s = UIScale.scale((int)2);
                area.subtract(new Area(new Ellipse2D.Double(x + (double)s, y + (double)s, size - (double)(s * 2.0f), size - (double)(s * 2.0f))));
            }
            g2.setColor(isSelected ? this.getBorderColor(UIManager.getColor("Component.accentColor")) : UIManager.getColor("Component.accentColor"));
            g2.fill(area);
        }
        g2.dispose();
        super.paintComponent(g);
    }

    private Shape getShape(double x, double y, double width, double size, boolean right, boolean add) {
        Area area;
        if (right) {
            area = new Area(new Rectangle2D.Double(width / 2.0, y, width / 2.0, size));
            area.subtract(new Area(new Ellipse2D.Double(x, y, size, size)));
        } else {
            area = new Area(new Rectangle2D.Double(0.0, y, width / 2.0, size));
        }
        if (add) {
            area.add(new Area(new Ellipse2D.Double(x, y, size, size)));
        } else {
            area.subtract(new Area(new Ellipse2D.Double(x, y, size, size)));
        }
        return area;
    }

    private SingleDate getToDate() {
        return this.dateSelection.getToDate() != null ? this.dateSelection.getToDate() : this.dateSelection.getHoverDate();
    }

    protected Color getColor() {
        Color color = FlatUIUtils.getParentBackground((JComponent)this);
        if (this.isDateSelected()) {
            color = UIManager.getColor("Component.accentColor");
        }
        if (this.press) {
            return FlatLaf.isLafDark() ? ColorFunctions.lighten((Color)color, (float)0.1f) : ColorFunctions.darken((Color)color, (float)0.1f);
        }
        if (this.hover) {
            return FlatLaf.isLafDark() ? ColorFunctions.lighten((Color)color, (float)0.03f) : ColorFunctions.darken((Color)color, (float)0.03f);
        }
        return color;
    }

    protected Color getBorderColor(Color color) {
        return ColorFunctions.mix((Color)color, (Color)this.getParent().getBackground(), (float)0.45f);
    }

    protected boolean isDateSelected() {
        if (this.dateSelection.dateSelectionMode == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
            return this.date.same(this.dateSelection.getDate());
        }
        return this.date.same(this.dateSelection.getDate()) || this.date.same(this.dateSelection.getToDate());
    }

    protected Color getBetweenDateColor() {
        Color color = FlatUIUtils.getParentBackground((JComponent)this);
        if (this.dateSelection.getToDate() != null) {
            return ColorFunctions.mix((Color)color, (Color)UIManager.getColor("Component.accentColor"), (float)0.9f);
        }
        return FlatLaf.isLafDark() ? ColorFunctions.lighten((Color)color, (float)0.03f) : ColorFunctions.darken((Color)color, (float)0.03f);
    }

    protected SingleDate getDate() {
        return this.date;
    }

    static /* synthetic */ boolean access$002(ButtonDate x0, boolean x1) {
        x0.press = x1;
        return x0.press;
    }

    static /* synthetic */ boolean access$102(ButtonDate x0, boolean x1) {
        x0.hover = x1;
        return x0.hover;
    }

    static /* synthetic */ DateSelection access$200(ButtonDate x0) {
        return x0.dateSelection;
    }

    static /* synthetic */ SingleDate access$300(ButtonDate x0) {
        return x0.date;
    }
}

