/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.date;

import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateEvent;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelection;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelectionAble;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelectionListener;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.Header;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.PanelDate;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.PanelDateOption;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.PanelMonth;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.PanelYear;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.SingleDate;
import br.com.tracker.dfeconverter.view.components.datetime.component.slider.PanelSlider;
import br.com.tracker.dfeconverter.view.components.datetime.component.slider.SimpleTransition;
import br.com.tracker.dfeconverter.view.components.datetime.util.InputUtils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Component;
import java.awt.LayoutManager;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class DatePicker
extends JPanel {
    private final DateTimeFormatter format = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private final DateTimeFormatter formatEUA = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final List<DateSelectionListener> events = new ArrayList();
    private DateSelectionListener dateSelectionListener;
    private final DateSelection dateSelection = new DateSelection(this);
    private PanelMonth.EventMonthChanged eventMonthChanged;
    private PanelYear.EventYearChanged eventYearChanged;
    private PanelDateOption panelDateOption;
    private InputUtils.ValueCallback valueCallback;
    private JFormattedTextField editor;
    private JPopupMenu popupMenu;
    private String separator = " at\u00e9 ";
    private boolean usePanelOption;
    private boolean closeAfterSelected;
    private int month = 10;
    private int year = 2023;
    private int panelSelect = 0;
    private Header header;
    private PanelSlider panelSlider;

    public DatePicker() {
        this.init();
    }

    private void init() {
        this.putClientProperty((Object)"FlatLaf.style", (Object)"[light]background:darken($Panel.background,2%);[dark]background:lighten($Panel.background,2%);");
        this.setLayout((LayoutManager)new MigLayout("wrap,insets 10,fill", "[fill]"));
        this.panelSlider = new PanelSlider();
        this.header = new Header(this.getEventHeader());
        this.eventMonthChanged = this.createEventMonthChanged();
        this.eventYearChanged = this.createEventYearChanged();
        this.add((Component)this.header);
        this.add((Component)this.panelSlider, (Object)"width 260,height 250");
        this.initDate();
    }

    private Header.EventHeaderChanged getEventHeader() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private PanelMonth.EventMonthChanged createEventMonthChanged() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private PanelYear.EventYearChanged createEventYearChanged() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setToBack() {
        if (this.panelSelect == 0) {
            if (this.month == 0) {
                this.month = 11;
                --this.year;
            } else {
                --this.month;
            }
            this.header.setDate(this.month, this.year);
            this.panelSlider.addSlide((Component)this.createPanelDate(this.month, this.year), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.BACK));
        } else if (this.panelSelect == 1) {
            --this.year;
            this.header.setDate(this.month, this.year);
            this.panelSlider.addSlide((Component)this.createPanelMonth(this.month, this.year), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.BACK));
        } else {
            PanelYear panelYear = (PanelYear)this.panelSlider.getComponent(1);
            this.panelSlider.addSlide((Component)this.createPanelYear(panelYear.getYear() - 28), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.BACK));
        }
    }

    public void setToForward() {
        if (this.panelSelect == 0) {
            if (this.month == 11) {
                this.month = 0;
                ++this.year;
            } else {
                ++this.month;
            }
            this.header.setDate(this.month, this.year);
            this.panelSlider.addSlide((Component)this.createPanelDate(this.month, this.year), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.FORWARD));
        } else if (this.panelSelect == 1) {
            ++this.year;
            this.header.setDate(this.month, this.year);
            this.panelSlider.addSlide((Component)this.createPanelMonth(this.month, this.year), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.FORWARD));
        } else {
            PanelYear panelYear = (PanelYear)this.panelSlider.getComponent(1);
            this.panelSlider.addSlide((Component)this.createPanelYear(panelYear.getYear() + 28), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.FORWARD));
        }
    }

    public void selectMonth() {
        if (this.panelSelect != 1) {
            this.panelSlider.addSlide((Component)this.createPanelMonth(this.month, this.year), SimpleTransition.get((SimpleTransition.SliderType)(this.panelSelect == 0 ? SimpleTransition.SliderType.TOP_DOWN : SimpleTransition.SliderType.DOWN_TOP)));
            this.panelSelect = 1;
        } else {
            this.panelSlider.addSlide((Component)this.createPanelDate(this.month, this.year), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.DOWN_TOP));
            this.panelSelect = 0;
        }
    }

    public void selectYear() {
        if (this.panelSelect != 2) {
            this.panelSlider.addSlide((Component)this.createPanelYear(this.year), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.TOP_DOWN));
            this.panelSelect = 2;
        } else {
            this.panelSlider.addSlide((Component)this.createPanelDate(this.month, this.year), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.DOWN_TOP));
            this.panelSelect = 0;
        }
    }

    private PanelDate createPanelDate(int month, int year) {
        return new PanelDate(this.dateSelection, month, year);
    }

    private PanelMonth createPanelMonth(int month, int year) {
        return new PanelMonth(this.eventMonthChanged, this.dateSelection, month, year);
    }

    private PanelYear createPanelYear(int year) {
        return new PanelYear(this.eventYearChanged, this.dateSelection, year);
    }

    protected void runEventDateChanged() {
        SwingUtilities.invokeLater(() -> {
            for (DateSelectionListener event : this.events) {
                event.dateSelected(new DateEvent((Object)this));
            }
            if (this.panelDateOption != null) {
                this.panelDateOption.setSelectedCustom();
            }
        });
    }

    public DateSelectionMode getDateSelectionMode() {
        return this.dateSelection.dateSelectionMode;
    }

    public void setDateSelectionMode(DateSelectionMode dateSelectionMode) {
        if (this.dateSelection.dateSelectionMode != dateSelectionMode) {
            this.dateSelection.dateSelectionMode = dateSelectionMode;
            if (this.editor != null) {
                InputUtils.useDateInput((JFormattedTextField)this.editor, (this.dateSelection.dateSelectionMode == DateSelectionMode.BETWEEN_DATE_SELECTED ? 1 : 0) != 0, (String)this.separator, (InputUtils.ValueCallback)this.getValueCallback());
                this.clearSelectedDate();
            }
            this.repaint();
        }
    }

    private void initDate() {
        LocalDate date = LocalDate.now();
        int month = date.getMonthValue() - 1;
        int year = date.getYear();
        this.month = month;
        this.year = year;
        this.header.setDate(month, year);
        this.panelSlider.addSlide((Component)this.createPanelDate(month, year), null);
    }

    public void now() {
        LocalDate date = LocalDate.now();
        if (this.dateSelection.dateSelectionMode == DateSelectionMode.BETWEEN_DATE_SELECTED) {
            this.setSelectedDateRange(date, date);
        } else {
            this.setSelectedDate(date);
        }
    }

    public void toCurrentMonth() {
        LocalDate dataAtual = LocalDate.now();
        this.setSelectedDateRange(dataAtual.withDayOfMonth(1), dataAtual);
    }

    public void setSelectedDate(LocalDate date) {
        this.dateSelection.setDate(new SingleDate(date));
        if (this.dateSelection.dateSelectionMode == DateSelectionMode.BETWEEN_DATE_SELECTED) {
            this.dateSelection.setToDate(new SingleDate(date));
        }
        this.panelSlider.revalidate();
        this.panelSlider.repaint();
        this.slideTo(date);
    }

    public void setSelectedDateRange(LocalDate from, LocalDate to) {
        if (this.dateSelection.dateSelectionMode == DateSelectionMode.SINGLE_DATE_SELECTED) {
            throw new IllegalArgumentException("Single date mode can't accept the range date");
        }
        this.dateSelection.setSelectDate(new SingleDate(from), new SingleDate(to));
        this.panelSlider.revalidate();
        this.panelSlider.repaint();
        this.slideTo(from);
    }

    public void setEditor(JFormattedTextField editor) {
        if (this.editor != null) {
            this.uninstallEditor(this.editor);
        }
        if (editor != null) {
            this.installEditor(editor);
        }
        this.editor = editor;
    }

    public DateSelectionAble getDateSelectionAble() {
        return this.dateSelection.getDateSelectionAble();
    }

    public void setDateSelectionAble(DateSelectionAble dateSelectionAble) {
        this.dateSelection.setDateSelectionAble(dateSelectionAble);
        Component com = this.panelSlider.getSlideComponent();
        if (com instanceof PanelDate) {
            ((PanelDate)com).load();
        }
    }

    public void showPopup() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.putClientProperty("FlatLaf.style", "borderInsets:1,1,1,1");
            this.popupMenu.add((Component)this);
        }
        SwingUtilities.updateComponentTreeUI(this.popupMenu);
        this.popupMenu.show(this.editor, 0, this.editor.getHeight());
    }

    public void closePopup() {
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
            this.revalidate();
            this.repaint();
        }
    }

    public void setSeparator(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("separator can't be null");
        }
        if (!this.separator.equals(separator)) {
            this.separator = separator;
            if (this.editor != null) {
                InputUtils.useDateInput((JFormattedTextField)this.editor, (this.dateSelection.dateSelectionMode == DateSelectionMode.BETWEEN_DATE_SELECTED ? 1 : 0) != 0, (String)separator, (InputUtils.ValueCallback)this.getValueCallback());
                this.runEventDateChanged();
            }
        }
    }

    public boolean isUsePanelOption() {
        return this.usePanelOption;
    }

    public void setUsePanelOption(boolean usePanelOption) {
        if (this.usePanelOption != usePanelOption) {
            this.usePanelOption = usePanelOption;
            if (usePanelOption) {
                if (this.panelDateOption == null) {
                    this.panelDateOption = new PanelDateOption(this);
                }
                this.add((Component)this.panelDateOption, (Object)"dock east,gap 0 10 10 10");
                this.repaint();
                this.revalidate();
            } else if (this.panelDateOption != null) {
                this.remove((Component)this.panelDateOption);
                this.panelDateOption = null;
                this.repaint();
                this.revalidate();
            }
        }
    }

    public boolean isCloseAfterSelected() {
        return this.closeAfterSelected;
    }

    public void setCloseAfterSelected(boolean closeAfterSelected) {
        this.closeAfterSelected = closeAfterSelected;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void clearSelectedDate() {
        this.dateSelection.setSelectDate(null, null);
        this.updateSelected();
        this.panelSlider.repaint();
    }

    public boolean isDateSelected() {
        if (this.dateSelection.dateSelectionMode == DateSelectionMode.SINGLE_DATE_SELECTED) {
            return this.dateSelection.getDate() != null;
        }
        return this.dateSelection.getDate() != null && this.dateSelection.getToDate() != null;
    }

    public LocalDate getSelectedDate() {
        SingleDate date = this.dateSelection.getDate();
        if (date != null) {
            return date.toLocalDate();
        }
        return null;
    }

    public LocalDate getSelectedDateStart() {
        SingleDate from = this.dateSelection.getDate();
        if (from != null) {
            return from.toLocalDate();
        }
        return null;
    }

    public String getSelectedDateStartAsStringOrEmpty() {
        return this.getSelectedDateStartAsStringOrEmpty("yyyy-MM-dd");
    }

    public String getSelectedDateStartAsStringOrEmpty(String format) {
        SingleDate from = this.dateSelection.getDate();
        if (from != null) {
            return DateTimeFormatter.ofPattern(format).format(from.toLocalDate());
        }
        return "";
    }

    public LocalDate getSelectedDateFinal() {
        SingleDate to = this.dateSelection.getToDate();
        if (to != null) {
            return to.toLocalDate();
        }
        return null;
    }

    public String getSelectedDateFinalAsStringOrEmpty() {
        return this.getSelectedDateFinalAsStringOrEmpty("yyyy-MM-dd");
    }

    public String getSelectedDateFinalAsStringOrEmpty(String format) {
        SingleDate to = this.dateSelection.getToDate();
        if (to != null) {
            return DateTimeFormatter.ofPattern(format).format(to.toLocalDate());
        }
        return "";
    }

    public LocalDate[] getSelectedDateRange() {
        SingleDate from = this.dateSelection.getDate();
        if (from != null) {
            LocalDate[] dates = new LocalDate[2];
            dates[0] = from.toLocalDate();
            SingleDate to = this.dateSelection.getToDate();
            if (to != null) {
                dates[1] = to.toLocalDate();
                return dates;
            }
        }
        return null;
    }

    public String[] getSelectedDateRangeAsString() {
        SingleDate from = this.dateSelection.getDate();
        if (from != null) {
            String[] dates = new String[2];
            dates[0] = this.formatEUA.format(from.toLocalDate());
            SingleDate to = this.dateSelection.getToDate();
            if (to != null) {
                dates[1] = this.formatEUA.format(to.toLocalDate());
                return dates;
            }
        }
        return null;
    }

    public String getSelectedDateAsString() {
        if (this.isDateSelected()) {
            if (this.dateSelection.dateSelectionMode == DateSelectionMode.SINGLE_DATE_SELECTED) {
                return this.format.format(this.getSelectedDate());
            }
            LocalDate[] dates = this.getSelectedDateRange();
            return this.format.format(dates[0]) + this.separator + this.format.format(dates[1]);
        }
        return null;
    }

    public void slideTo(LocalDate date) {
        int m = date.getMonthValue() - 1;
        int y = date.getYear();
        if (this.year != y || this.month != m) {
            if (this.year < y || this.year <= y && this.month < m) {
                this.panelSlider.addSlide((Component)this.createPanelDate(m, y), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.FORWARD));
            } else {
                this.panelSlider.addSlide((Component)this.createPanelDate(m, y), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.BACK));
            }
            this.month = m;
            this.year = y;
            this.panelSelect = 0;
            this.header.setDate(this.month, this.year);
        } else if (this.panelSelect != 0) {
            this.panelSlider.addSlide((Component)this.createPanelDate(m, y), SimpleTransition.get((SimpleTransition.SliderType)SimpleTransition.SliderType.DOWN_TOP));
            this.panelSelect = 0;
        }
        this.updateSelected();
    }

    public void addDateSelectionListener(DateSelectionListener event) {
        this.events.add(event);
    }

    public void removeDateSelectionListener(DateSelectionListener event) {
        if (this.events != null) {
            this.events.remove(event);
        }
    }

    public void removeAllDateSelectionListener() {
        if (this.events != null) {
            this.events.clear();
        }
    }

    private void updateSelected() {
        Component com = this.panelSlider.getSlideComponent();
        if (com instanceof PanelDate) {
            ((PanelDate)com).checkSelection();
        } else if (com instanceof PanelMonth) {
            ((PanelMonth)com).checkSelection();
        } else if (com instanceof PanelYear) {
            ((PanelYear)com).checkSelection();
        }
    }

    private void installEditor(JFormattedTextField editor) {
        JToolBar toolBar = new JToolBar();
        JButton button = new JButton((Icon)new FlatSVGIcon("datetime/icon/calendar.svg", 0.8f));
        toolBar.add(button);
        button.addActionListener(e -> this.showPopup());
        editor.putClientProperty("JTextField.trailingComponent", toolBar);
        this.addDateSelectionListener(this.getDateSelectionListener());
        InputUtils.useDateInput((JFormattedTextField)editor, (this.dateSelection.dateSelectionMode == DateSelectionMode.BETWEEN_DATE_SELECTED ? 1 : 0) != 0, (String)this.separator, (InputUtils.ValueCallback)this.getValueCallback());
    }

    private void uninstallEditor(JFormattedTextField editor) {
        if (editor != null) {
            editor.setFormatterFactory(null);
            editor.putClientProperty("JTextField.trailingComponent", null);
            if (this.dateSelectionListener != null) {
                this.removeDateSelectionListener(this.dateSelectionListener);
            }
        }
    }

    private InputUtils.ValueCallback getValueCallback() {
        if (this.valueCallback == null) {
            this.valueCallback = value -> {
                if (value == null && this.isDateSelected()) {
                    this.clearSelectedDate();
                } else if (value != null && !value.equals(this.getSelectedDateAsString())) {
                    if (this.dateSelection.dateSelectionMode == DateSelectionMode.SINGLE_DATE_SELECTED) {
                        LocalDate date = InputUtils.stringToDate((DateTimeFormatter)this.format, (String)value.toString());
                        if (date != null) {
                            this.setSelectedDate(date);
                        }
                    } else {
                        LocalDate[] dates = InputUtils.stringToDate((DateTimeFormatter)this.format, (String)this.separator, (String)value.toString());
                        if (dates != null) {
                            this.setSelectedDateRange(dates[0], dates[1]);
                        }
                    }
                }
            };
        }
        return this.valueCallback;
    }

    private DateSelectionListener getDateSelectionListener() {
        if (this.dateSelectionListener == null) {
            this.dateSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.dateSelectionListener;
    }

    static /* synthetic */ int access$002(DatePicker x0, int x1) {
        x0.month = x1;
        return x0.month;
    }

    static /* synthetic */ int access$100(DatePicker x0) {
        return x0.year;
    }

    static /* synthetic */ Header access$200(DatePicker x0) {
        return x0.header;
    }

    static /* synthetic */ PanelDate access$300(DatePicker x0, int x1, int x2) {
        return x0.createPanelDate(x1, x2);
    }

    static /* synthetic */ PanelSlider access$400(DatePicker x0) {
        return x0.panelSlider;
    }

    static /* synthetic */ int access$502(DatePicker x0, int x1) {
        x0.panelSelect = x1;
        return x0.panelSelect;
    }

    static /* synthetic */ int access$102(DatePicker x0, int x1) {
        x0.year = x1;
        return x0.year;
    }

    static /* synthetic */ int access$000(DatePicker x0) {
        return x0.month;
    }

    static /* synthetic */ PanelMonth access$600(DatePicker x0, int x1, int x2) {
        return x0.createPanelMonth(x1, x2);
    }

    static /* synthetic */ DateSelection access$700(DatePicker x0) {
        return x0.dateSelection;
    }

    static /* synthetic */ DateTimeFormatter access$800(DatePicker x0) {
        return x0.format;
    }

    static /* synthetic */ String access$900(DatePicker x0) {
        return x0.separator;
    }

    static /* synthetic */ JFormattedTextField access$1000(DatePicker x0) {
        return x0.editor;
    }
}

