/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.date;

import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelectionAble;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.SingleDate;

public class DateSelection {
    protected DatePicker.DateSelectionMode dateSelectionMode = DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED;
    private DateSelectionAble dateSelectionAble;
    private SingleDate date;
    private SingleDate toDate;
    private SingleDate hoverDate;
    protected final DatePicker datePicker;

    protected DateSelection(DatePicker datePicker) {
        this.datePicker = datePicker;
    }

    public SingleDate getDate() {
        return this.date;
    }

    public void setDate(SingleDate date) {
        if (!this.checkSelection(date)) {
            return;
        }
        this.date = date;
        this.datePicker.runEventDateChanged();
    }

    public SingleDate getToDate() {
        return this.toDate;
    }

    public void setToDate(SingleDate toDate) {
        if (!this.checkSelection(toDate)) {
            return;
        }
        this.toDate = toDate;
    }

    public SingleDate getHoverDate() {
        return this.hoverDate;
    }

    public void setHoverDate(SingleDate hoverDate) {
        this.hoverDate = hoverDate;
    }

    protected void setSelectDate(SingleDate from, SingleDate to) {
        if (!this.checkSelection(from) || !this.checkSelection(to)) {
            return;
        }
        this.date = from;
        this.toDate = to;
        this.datePicker.runEventDateChanged();
    }

    protected void selectDate(SingleDate date) {
        if (!this.checkSelection(date)) {
            return;
        }
        if (this.dateSelectionMode == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
            this.setDate(date);
            if (this.datePicker.isCloseAfterSelected()) {
                this.datePicker.closePopup();
            }
        } else if (this.getDate() == null || this.getToDate() != null) {
            this.date = date;
            this.hoverDate = date;
            if (this.getToDate() != null) {
                this.toDate = null;
            }
        } else {
            this.toDate = date;
            this.invertIfNecessaryToDate(date);
            this.datePicker.runEventDateChanged();
            if (this.datePicker.isCloseAfterSelected()) {
                this.datePicker.closePopup();
            }
        }
    }

    private void invertIfNecessaryToDate(SingleDate date) {
        if (this.date.toLocalDate().isAfter(date.toLocalDate())) {
            this.toDate = this.date;
            this.date = date;
        }
    }

    public void setDateSelectionAble(DateSelectionAble dateSelectionAble) {
        this.dateSelectionAble = dateSelectionAble;
    }

    public DateSelectionAble getDateSelectionAble() {
        return this.dateSelectionAble;
    }

    private boolean checkSelection(SingleDate date) {
        if (this.dateSelectionAble != null) {
            return date == null || this.dateSelectionAble.isDateSelectedAble(date.toLocalDate());
        }
        return true;
    }
}

