/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.date;

import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import java.awt.Component;
import java.awt.LayoutManager;
import java.time.LocalDate;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;

public class PanelDateOption
extends JPanel {
    private final DatePicker datePicker;
    private boolean disableChange;
    private ButtonGroup buttonGroup;

    public PanelDateOption(DatePicker datePicker) {
        this.datePicker = datePicker;
        this.init();
    }

    private void init() {
        this.putClientProperty((Object)"FlatLaf.style", (Object)"background:null");
        this.setLayout((LayoutManager)new MigLayout("wrap,insets 5,fillx", "[fill]", "[][][][][][][]push[]"));
        this.add((Component)new JSeparator(1), (Object)"dock west");
        this.buttonGroup = new ButtonGroup();
        this.add((Component)this.createButton("Hoje", 0));
        this.add((Component)this.createButton("Ontem", -1));
        this.add((Component)this.createButton("Ultimos 7 dias", -7));
        this.add((Component)this.createButton("Ultimos 30 dias", -30));
        this.add((Component)this.createButton("Este M\u00eas", 1, true));
        this.add((Component)this.createButton("M\u00eas Anterior", 2, true));
        this.add((Component)this.createButton("Este Ano", 3, true));
        this.add((Component)this.createButton("Ano Anterior", 4, true));
        this.add((Component)this.createButton("Sele\u00e7\u00e3o Livre", -1, true));
    }

    private JToggleButton createButton(String name, int date) {
        return this.createButton(name, date, false);
    }

    private JToggleButton createButton(String name, int date, boolean useType) {
        JToggleButton button = new JToggleButton(name);
        button.setHorizontalAlignment(10);
        if (useType) {
            button.addActionListener(e -> {
                this.disableChange = true;
                if (date == -1) {
                    this.datePicker.clearSelectedDate();
                } else if (date == 1) {
                    Calendar calendar = Calendar.getInstance();
                    this.setSelectedDate(calendar);
                } else if (date == 2) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(2, -1);
                    this.setSelectedDate(calendar);
                } else if (date == 3) {
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    if (this.datePicker.getDateSelectionMode() == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
                        this.datePicker.setSelectedDate(LocalDate.of(year, 1, 1));
                    } else {
                        this.datePicker.setSelectedDateRange(LocalDate.of(year, 1, 1), LocalDate.of(year, 12, 31));
                    }
                } else if (date == 4) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(1, -1);
                    int year = calendar.get(1);
                    if (this.datePicker.getDateSelectionMode() == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
                        this.datePicker.setSelectedDate(LocalDate.of(year, 1, 1));
                    } else {
                        this.datePicker.setSelectedDateRange(LocalDate.of(year, 1, 1), LocalDate.of(year, 12, 31));
                    }
                }
            });
        } else {
            button.addActionListener(e -> {
                this.disableChange = true;
                if (date == 0 || date == -1 || this.datePicker.getDateSelectionMode() == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
                    this.datePicker.setSelectedDate(this.calculateDate(date));
                } else {
                    this.datePicker.setSelectedDateRange(this.calculateDate(date), LocalDate.now());
                }
            });
        }
        button.putClientProperty("FlatLaf.style", "arc:10;borderWidth:0;focusWidth:0;innerFocusWidth:0;margin:4,10,4,10;background:null");
        this.buttonGroup.add(button);
        return button;
    }

    private void setSelectedDate(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int fromDay = 1;
        int toDay = calendar.getActualMaximum(5);
        if (this.datePicker.getDateSelectionMode() == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
            this.datePicker.setSelectedDate(LocalDate.of(year, month, fromDay));
        } else {
            this.datePicker.setSelectedDateRange(LocalDate.of(year, month, fromDay), LocalDate.of(year, month, toDay));
        }
    }

    private LocalDate calculateDate(int date) {
        if (date == 0) {
            return LocalDate.now();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return LocalDate.of(year, month, day);
    }

    public void setSelectedCustom() {
        if (!this.disableChange) {
            JToggleButton button = (JToggleButton)this.getComponent(this.getComponentCount() - 1);
            button.setSelected(true);
        }
        this.disableChange = false;
    }
}

