/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.date;

import br.com.tracker.dfeconverter.view.components.datetime.component.date.ButtonMonthYear;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DatePicker;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.DateSelection;
import br.com.tracker.dfeconverter.view.components.datetime.component.date.PanelMonth;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DateFormatSymbols;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PanelMonth
extends JPanel {
    private final EventMonthChanged monthChanged;
    private final DateSelection dateSelection;
    private final int month;
    private final int year;

    public PanelMonth(EventMonthChanged monthChanged, DateSelection dateSelection, int month, int year) {
        this.monthChanged = monthChanged;
        this.dateSelection = dateSelection;
        this.month = month;
        this.year = year;
        this.init();
    }

    private void init() {
        this.putClientProperty((Object)"FlatLaf.style", (Object)"background:null");
        this.setLayout((LayoutManager)new MigLayout("wrap 3,insets 3,fillx,gap 3,al center center", "fill,sg main", "fill"));
        int count = 12;
        for (int i = 0; i < count; ++i) {
            int month = i;
            ButtonMonthYear button = new ButtonMonthYear(this.dateSelection, i, false);
            button.setText(DateFormatSymbols.getInstance().getMonths()[i]);
            if (this.checkSelected(month + 1)) {
                button.setSelected(true);
            }
            button.addActionListener(e -> this.monthChanged.monthSelected(month));
            this.add((Component)button);
        }
    }

    protected boolean checkSelected(int month) {
        if (this.dateSelection.dateSelectionMode == DatePicker.DateSelectionMode.SINGLE_DATE_SELECTED) {
            return this.dateSelection.getDate() != null && this.year == this.dateSelection.getDate().getYear() && month == this.dateSelection.getDate().getMonth();
        }
        return this.dateSelection.getDate() != null && this.year == this.dateSelection.getDate().getYear() && month == this.dateSelection.getDate().getMonth() || this.dateSelection.getToDate() != null && this.year == this.dateSelection.getToDate().getYear() && month == this.dateSelection.getToDate().getMonth();
    }

    protected void checkSelection() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component com = this.getComponent(i);
            if (!(com instanceof ButtonMonthYear)) continue;
            ButtonMonthYear button = (ButtonMonthYear)com;
            button.setSelected(this.checkSelected(button.getValue() + 1));
        }
    }
}

