/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.slider;

import br.com.tracker.dfeconverter.view.components.datetime.component.slider.PanelSlider;
import br.com.tracker.dfeconverter.view.components.datetime.component.slider.SliderTransition;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.VolatileImage;
import javax.swing.JLayeredPane;

public class PanelSlider
extends JLayeredPane {
    private PanelSnapshot panelSnapshot;
    private Component slideComponent;

    public Component getSlideComponent() {
        return this.slideComponent;
    }

    public PanelSlider() {
        this.init();
    }

    private void init() {
        this.panelSnapshot = new PanelSnapshot(this);
        this.setLayout((LayoutManager)new CardLayout());
        this.setLayer((Component)this.panelSnapshot, JLayeredPane.DRAG_LAYER.intValue());
        this.add((Component)this.panelSnapshot);
        this.panelSnapshot.setVisible(false);
    }

    public void addSlide(Component component, SliderTransition transition) {
        this.slideComponent = component;
        if (this.getComponentCount() == 1) {
            this.add(component);
            this.repaint();
            this.revalidate();
            component.setVisible(true);
        } else {
            Component oldComponent = this.getComponent(1);
            this.add(component);
            if (transition != null) {
                this.doLayout();
                component.doLayout();
                Image oldImage = this.createImage(oldComponent);
                Image newImage = this.createImage(component);
                this.remove(oldComponent);
                this.panelSnapshot.animate(component, transition, oldImage, newImage);
            } else {
                this.remove(oldComponent);
                this.revalidate();
                this.repaint();
            }
        }
    }

    private Image createImage(Component component) {
        VolatileImage snapshot = component.createVolatileImage(this.getWidth(), this.getHeight());
        if (snapshot != null) {
            component.paint(snapshot.getGraphics());
        }
        return snapshot;
    }
}

