/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.datetime.component.time;

import br.com.tracker.dfeconverter.view.components.datetime.component.time.AnimationChange;
import br.com.tracker.dfeconverter.view.components.datetime.component.time.PanelClock;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.ColorFunctions;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class PanelClock
extends JPanel {
    private final EventClockChanged clockChanged;
    private boolean use24hour;
    private boolean hourSelectionView = true;
    private int hour = -1;
    private int minute = -1;
    private AnimationChange animationChange;
    private final int margin12h = 20;
    private final int margin24h = 50;

    public void setHourAndFix(int hour) {
        if (!this.use24hour) {
            if (hour == 0) {
                hour = 12;
            } else if (hour > 12) {
                hour -= 12;
            }
        } else if (hour == 24) {
            hour = 0;
        }
        this.setHour(hour);
    }

    public void setHour(int hour) {
        if (this.hour != hour) {
            this.hour = hour;
            if (this.hourSelectionView) {
                this.animationChange.set(this.getAngleOf(hour, true), (float)this.getTargetMargin());
            }
            this.clockChanged.hourChanged(hour);
            this.repaint();
        }
    }

    public void setMinute(int minute) {
        if (this.minute != minute) {
            this.minute = minute;
            if (!this.hourSelectionView) {
                if (this.hour == -1) {
                    this.setHour(12);
                }
                this.animationChange.set(this.getAngleOf(minute, false), (float)this.getTargetMargin());
            }
            this.clockChanged.minuteChanged(minute);
            this.repaint();
        }
    }

    public void setHourSelectionView(boolean hourSelectionView) {
        if (this.hourSelectionView != hourSelectionView) {
            this.hourSelectionView = hourSelectionView;
            this.repaint();
            this.runAnimation();
        }
    }

    public void setUse24hour(boolean use24hour, boolean isAm) {
        if (this.use24hour != use24hour) {
            this.use24hour = use24hour;
            this.repaint();
            if (this.hourSelectionView && this.hour != -1 || !this.hourSelectionView && this.minute != -1) {
                if (use24hour) {
                    if (!isAm) {
                        if (this.hour < 12) {
                            this.setHourAndFix(this.hour + 12);
                        }
                    } else if (this.hour == 12) {
                        this.setHourAndFix(0);
                    }
                } else {
                    this.clockChanged.amPmChanged(this.hour < 12);
                    if (this.hour == 0) {
                        this.setHour(12);
                    } else if (this.hour > 12) {
                        this.setHour(this.hour - 12);
                    }
                }
            }
        }
    }

    public boolean isUse24hour() {
        return this.use24hour;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public PanelClock(EventClockChanged clockChanged) {
        this.clockChanged = clockChanged;
        this.init();
    }

    private void init() {
        this.animationChange = new AnimationChange((Component)this);
        this.putClientProperty((Object)"FlatLaf.style", (Object)"border:5,15,5,15;background:null;foreground:contrast($Component.accentColor,$Panel.background,#fff)");
        1 mouseAdapter = new /* Unavailable Anonymous Inner Class!! */;
        this.addMouseListener((MouseListener)mouseAdapter);
        this.addMouseMotionListener((MouseMotionListener)mouseAdapter);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        FlatUIUtils.setRenderingHints((Graphics)g2);
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        int size = Math.min(width, height);
        g2.translate(insets.left, insets.top);
        int x = (width - size) / 2;
        int y = (height - size) / 2;
        g2.setColor(this.getClockBackground());
        g2.fill(new Ellipse2D.Double(x, y, size, size));
        this.paintSelection(g2, x, y, size);
        this.paintClockNumber(g2, x, y, size);
        g2.dispose();
    }

    protected void paintSelection(Graphics2D g2, int x, int y, int size) {
        AffineTransform tran = g2.getTransform();
        size /= 2;
        float margin = UIScale.scale((float)this.animationChange.getMargin());
        float centerSize = UIScale.scale((float)8.0f);
        float lineSize = UIScale.scale((int)3);
        float selectSize = UIScale.scale((float)25.0f);
        float unselectSize = UIScale.scale((int)4);
        float lineHeight = (float)size - margin;
        Area area = new Area(new Ellipse2D.Float((float)(x + size) - centerSize / 2.0f, (float)(y + size) - centerSize / 2.0f, centerSize, centerSize));
        if (this.hourSelectionView && this.hour != -1 || !this.hourSelectionView && this.minute != -1) {
            area.add(new Area(new RoundRectangle2D.Float((float)(x + size) - lineSize / 2.0f, (float)y + margin, lineSize, lineHeight, lineSize, lineSize)));
            area.add(new Area(new Ellipse2D.Float((float)(x + size) - selectSize / 2.0f, (float)y + margin - selectSize / 2.0f, selectSize, selectSize)));
            if (!this.hourSelectionView && !this.animationChange.isRunning() && this.minute % 5 != 0) {
                area.subtract(new Area(new Ellipse2D.Float((float)(x + size) - unselectSize / 2.0f, (float)y + margin - unselectSize / 2.0f, unselectSize, unselectSize)));
            }
        }
        g2.setColor(this.getSelectedColor());
        float angle = this.animationChange.getAngle();
        g2.rotate(Math.toRadians(angle), x + size, y + size);
        g2.fill(area);
        g2.setTransform(tran);
    }

    protected void paintClockNumber(Graphics2D g2, int x, int y, int size) {
        this.paintClockNumber(g2, x, y, size, 20, 0, this.hourSelectionView ? 1 : 5);
        if (this.hourSelectionView && this.use24hour) {
            this.paintClockNumber(g2, x, y, size, 50, 12, 1);
        }
    }

    protected void paintClockNumber(Graphics2D g2, int x, int y, int size, int margin, int start, int add) {
        int mg = UIScale.scale((int)margin);
        float center = (float)size / 2.0f;
        float angle = 30.0f;
        for (int i = 1; i <= 12; ++i) {
            float ag = angle * (float)i - 90.0f;
            int num = this.fixHour(start + i * add, this.hourSelectionView);
            float nx = (float)((double)center + Math.cos(Math.toRadians(ag)) * (double)(center - (float)mg));
            float ny = (float)((double)center + Math.sin(Math.toRadians(ag)) * (double)(center - (float)mg));
            this.paintNumber(g2, (float)x + nx, (float)y + ny, this.fixNumberAndToString(num), this.isSelected(num));
        }
    }

    protected void paintNumber(Graphics2D g2, float x, float y, String num, boolean isSelected) {
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D rec = fm.getStringBounds(num, g2);
        x = (float)((double)x - rec.getWidth() / 2.0);
        y = (float)((double)y - rec.getHeight() / 2.0);
        if (isSelected) {
            g2.setColor(this.getSelectedForeground());
        } else {
            g2.setColor(UIManager.getColor("Panel.foreground"));
        }
        g2.drawString(num, x, y + (float)fm.getAscent());
    }

    protected Color getClockBackground() {
        if (FlatLaf.isLafDark()) {
            return ColorFunctions.lighten((Color)this.getBackground(), (float)0.03f);
        }
        return ColorFunctions.darken((Color)this.getBackground(), (float)0.03f);
    }

    protected boolean isSelected(int num) {
        if (this.hourSelectionView) {
            return num == this.hour;
        }
        return num == this.minute;
    }

    protected Color getSelectedColor() {
        return UIManager.getColor("Component.accentColor");
    }

    protected Color getSelectedForeground() {
        return this.getForeground();
    }

    private int getValueOf(float angle, boolean hourView) {
        float ag = angle / 360.0f;
        int value = (int)(ag * (float)(hourView ? 12 : 60));
        if (hourView) {
            return value == 0 ? 12 : value;
        }
        return value == 60 ? 0 : value;
    }

    private int getValueOf(Point point, boolean hourView) {
        float angle = this.getAngleOf(point) + (float)(hourView ? 15 : 3);
        int value = this.getValueOf(angle, hourView);
        if (hourView && this.use24hour && this.is24hourSelect(point)) {
            return this.fixHour(value + 12, true);
        }
        return value;
    }

    private boolean is24hourSelect(Point point) {
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        int size = Math.min(width, height) / 2;
        int distanceTarget = size - UIScale.scale((int)40);
        float centerX = insets.left + size;
        float centerY = insets.top + size;
        double distance = Math.sqrt(Math.pow((float)point.x - centerX, 2.0) + Math.pow((float)point.y - centerY, 2.0));
        return distance < (double)distanceTarget;
    }

    private float getAngleOf(int number, boolean hourView) {
        float ag = 360 / (hourView ? 12 : 60);
        return this.fixAngle(ag * (float)number);
    }

    private float getAngleOf(Point point) {
        float centerX;
        float x;
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        float centerY = insets.top + height / 2;
        float y = (float)point.y - centerY;
        double angle = Math.toDegrees(Math.atan2(y, x = (float)point.x - (centerX = (float)(insets.left + width / 2)))) + 90.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        return (float)angle;
    }

    private float fixAngle(float angle) {
        if (angle > 360.0f) {
            angle -= 360.0f;
        }
        if (angle == 360.0f) {
            return 0.0f;
        }
        return angle;
    }

    private int fixHour(int value, boolean hourView) {
        if (hourView ? this.use24hour && value == 24 : value == 60) {
            return 0;
        }
        return value;
    }

    private String fixNumberAndToString(int num) {
        if (num == 0) {
            return "00";
        }
        return num + "";
    }

    private boolean is24hour() {
        return this.use24hour && (this.hour == 0 || this.hour > 12);
    }

    private int getTargetMargin() {
        return this.is24hour() && this.hourSelectionView ? 50 : 20;
    }

    private void runAnimation() {
        float angleTarget = this.getAngleOf(this.hourSelectionView ? this.hour : this.minute, this.hourSelectionView);
        float marginTarget = this.getTargetMargin();
        this.animationChange.start(angleTarget, marginTarget);
    }

    static /* synthetic */ boolean access$000(PanelClock x0) {
        return x0.hourSelectionView;
    }

    static /* synthetic */ boolean access$002(PanelClock x0, boolean x1) {
        x0.hourSelectionView = x1;
        return x0.hourSelectionView;
    }

    static /* synthetic */ EventClockChanged access$100(PanelClock x0) {
        return x0.clockChanged;
    }

    static /* synthetic */ void access$200(PanelClock x0) {
        x0.runAnimation();
    }

    static /* synthetic */ int access$300(PanelClock x0, Point x1, boolean x2) {
        return x0.getValueOf(x1, x2);
    }
}

