/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.panel;

import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;

public class TPanel
extends JPanel {
    private boolean borderLineShow;
    private boolean borderLineRounded = true;
    private int borderLineArc = 8;
    private Color borderLineColor;
    private int roundTopLeft = 20;
    private int roundTopRight = 20;
    private int roundBottomLeft = 0;
    private int roundBottomRight = 0;

    public int getRoundTopLeft() {
        return this.roundTopLeft;
    }

    public void setRoundTopLeft(int roundTopLeft) {
        this.roundTopLeft = roundTopLeft;
        this.repaint();
    }

    public int getRoundTopRight() {
        return this.roundTopRight;
    }

    public void setRoundTopRight(int roundTopRight) {
        this.roundTopRight = roundTopRight;
        this.repaint();
    }

    public int getRoundBottomLeft() {
        return this.roundBottomLeft;
    }

    public void setRoundBottomLeft(int roundBottomLeft) {
        this.roundBottomLeft = roundBottomLeft;
        this.repaint();
    }

    public int getRoundBottomRight() {
        return this.roundBottomRight;
    }

    public void setRoundBottomRight(int roundBottomRight) {
        this.roundBottomRight = roundBottomRight;
        this.repaint();
    }

    public boolean isBorderLineShow() {
        return this.borderLineShow;
    }

    public void setBorderLineShow(boolean borderLineShow) {
        this.borderLineShow = borderLineShow;
    }

    public Color getBorderLineColor() {
        return this.borderLineColor;
    }

    public void setBorderLineColor(Color borderLineColor) {
        this.borderLineColor = borderLineColor;
    }

    public boolean isBorderLineRounded() {
        return this.borderLineRounded;
    }

    public void setBorderLineRounded(boolean borderLineRounded) {
        this.borderLineRounded = borderLineRounded;
    }

    public int getBorderLineArc() {
        return this.borderLineArc;
    }

    public void setBorderLineArc(int borderLineArc) {
        this.borderLineArc = borderLineArc;
    }

    public TPanel() {
        super.setOpaque(false);
    }

    protected void paintBorder(Graphics grphcs) {
        if (this.borderLineShow) {
            Graphics2D g2 = (Graphics2D)grphcs.create();
            FlatUIUtils.setRenderingHints((Graphics)g2);
            if (this.borderLineColor == null) {
                g2.setColor(FlatUIUtils.getUIColor((String)"Tracker.Panel.borderColor", (Color)Color.GRAY));
            } else {
                g2.setColor(this.borderLineColor);
            }
            int height = this.getHeight();
            int arc = this.borderLineArc;
            if (this.borderLineRounded) {
                arc = height - 3;
            }
            g2.drawRoundRect(0, 0, this.getWidth() - 1, height - 1, arc, arc);
        }
        super.paintBorder(grphcs);
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected void paintComponent(Graphics grphcs) {
        Graphics2D g2 = (Graphics2D)grphcs.create();
        FlatUIUtils.setRenderingHints((Graphics)g2);
        g2.setColor(this.getBackground());
        Area area = new Area(this.createRoundTopLeft());
        if (this.roundTopRight > 0) {
            area.intersect(new Area(this.createRoundTopRight()));
        }
        if (this.roundBottomLeft > 0) {
            area.intersect(new Area(this.createRoundBottomLeft()));
        }
        if (this.roundBottomRight > 0) {
            area.intersect(new Area(this.createRoundBottomRight()));
        }
        g2.fill(area);
        g2.dispose();
        super.paintComponent(grphcs);
    }

    private Shape createRoundTopLeft() {
        int width = this.getWidth();
        int height = this.getHeight();
        int roundX = Math.min(width, this.roundTopLeft);
        int roundY = Math.min(height, this.roundTopLeft);
        Area area = new Area(new RoundRectangle2D.Double(0.0, 0.0, width, height, roundX, roundY));
        area.add(new Area(new Rectangle2D.Double(roundX / 2, 0.0, width - roundX / 2, height)));
        area.add(new Area(new Rectangle2D.Double(0.0, roundY / 2, width, height - roundY / 2)));
        return area;
    }

    private Shape createRoundTopRight() {
        int width = this.getWidth();
        int height = this.getHeight();
        int roundX = Math.min(width, this.roundTopRight);
        int roundY = Math.min(height, this.roundTopRight);
        Area area = new Area(new RoundRectangle2D.Double(0.0, 0.0, width, height, roundX, roundY));
        area.add(new Area(new Rectangle2D.Double(0.0, 0.0, width - roundX / 2, height)));
        area.add(new Area(new Rectangle2D.Double(0.0, roundY / 2, width, height - roundY / 2)));
        return area;
    }

    private Shape createRoundBottomLeft() {
        int width = this.getWidth();
        int height = this.getHeight();
        int roundX = Math.min(width, this.roundBottomLeft);
        int roundY = Math.min(height, this.roundBottomLeft);
        Area area = new Area(new RoundRectangle2D.Double(0.0, 0.0, width, height, roundX, roundY));
        area.add(new Area(new Rectangle2D.Double(roundX / 2, 0.0, width - roundX / 2, height)));
        area.add(new Area(new Rectangle2D.Double(0.0, 0.0, width, height - roundY / 2)));
        return area;
    }

    private Shape createRoundBottomRight() {
        int width = this.getWidth();
        int height = this.getHeight();
        int roundX = Math.min(width, this.roundBottomRight);
        int roundY = Math.min(height, this.roundBottomRight);
        Area area = new Area(new RoundRectangle2D.Double(0.0, 0.0, width, height, roundX, roundY));
        area.add(new Area(new Rectangle2D.Double(0.0, 0.0, width - roundX / 2, height)));
        area.add(new Area(new Rectangle2D.Double(0.0, 0.0, width, height - roundY / 2)));
        return area;
    }
}

