/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.toast.ui;

import br.com.tracker.dfeconverter.view.components.toast.ui.DropShadowBorder;
import br.com.tracker.dfeconverter.view.components.toast.ui.ToastPanelUI;
import br.com.tracker.dfeconverter.view.components.toast.util.UIUtils;
import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Color;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicPanelUI;

public class ToastPanelUI
extends BasicPanelUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    protected JComponent iconComponent;
    protected JComponent component;
    protected JComponent closeButton;
    @FlatStylingSupport.Styleable
    protected int iconTextGap;
    @FlatStylingSupport.Styleable
    protected int closeButtonGap;
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    @FlatStylingSupport.Styleable
    protected int maximumWidth;
    @FlatStylingSupport.Styleable
    protected int arc;
    @FlatStylingSupport.Styleable
    protected int outlineWidth;
    @FlatStylingSupport.Styleable
    protected Color outlineColor;
    @FlatStylingSupport.Styleable
    protected boolean showCloseButton;
    @FlatStylingSupport.Styleable
    protected Color closeIconColor;
    @FlatStylingSupport.Styleable
    protected Insets margin;
    @FlatStylingSupport.Styleable
    protected Icon closeButtonIcon;
    @FlatStylingSupport.Styleable
    protected boolean useEffect;
    @FlatStylingSupport.Styleable
    protected Color effectColor;
    @FlatStylingSupport.Styleable
    protected float effectWidth;
    @FlatStylingSupport.Styleable
    protected float effectOpacity;
    @FlatStylingSupport.Styleable
    protected String effectAlignment;
    private PanelNotificationLayout layout;
    private Map<String, Object> oldStyleValues;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.addPropertyChangeListener((PropertyChangeListener)this);
        this.installIconComponent(c);
        this.installComponent(c);
        this.installCloseButton(c);
        this.installStyle((JPanel)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removePropertyChangeListener((PropertyChangeListener)this);
        this.uninstallIconComponent(c);
        this.uninstallComponent(c);
        this.uninstallCloseButton(c);
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        String prefix = this.getPropertyPrefix();
        this.iconTextGap = FlatUIUtils.getUIInt((String)(prefix + ".iconTextGap"), (int)5);
        this.closeButtonGap = FlatUIUtils.getUIInt((String)(prefix + ".closeButtonGap"), (int)5);
        this.minimumWidth = FlatUIUtils.getUIInt((String)(prefix + ".minimumWidth"), (int)50);
        this.maximumWidth = FlatUIUtils.getUIInt((String)(prefix + ".maximumWidth"), (int)-1);
        this.arc = FlatUIUtils.getUIInt((String)(prefix + ".arc"), (int)20);
        this.outlineWidth = FlatUIUtils.getUIInt((String)(prefix + ".outlineWidth"), (int)0);
        this.outlineColor = FlatUIUtils.getUIColor((String)(prefix + ".outlineColor"), (String)"Component.focusColor");
        this.margin = UIUtils.getInsets((String)(prefix + ".margin"), (Insets)new Insets(8, 8, 8, 8));
        this.showCloseButton = FlatUIUtils.getUIBoolean((String)(prefix + ".showCloseButton"), (boolean)true);
        this.closeIconColor = FlatUIUtils.getUIColor((String)(prefix + ".closeIconColor"), (Color)new Color(150, 150, 150));
        this.closeButtonIcon = UIUtils.getIcon((String)(prefix + ".closeIcon"), (Icon)UIUtils.createIcon((String)"toast/svg/close.svg", (Color)this.closeIconColor, (float)0.75f));
        this.useEffect = FlatUIUtils.getUIBoolean((String)(prefix + ".useEffect"), (boolean)true);
        this.effectColor = FlatUIUtils.getUIColor((String)(prefix + ".effectColor"), (String)"Component.focusColor");
        this.effectWidth = FlatUIUtils.getUIFloat((String)(prefix + ".effectWidth"), (float)0.5f);
        this.effectOpacity = FlatUIUtils.getUIFloat((String)(prefix + ".effectOpacity"), (float)0.2f);
        this.effectAlignment = UIUtils.getString((String)(prefix + ".effectAlignment"), (String)"left");
        p.setBackground(FlatUIUtils.getUIColor((String)(prefix + ".background"), (String)"Panel.background"));
        p.setBorder(this.createDefaultBorder());
        LookAndFeel.installProperty(p, "opaque", false);
    }

    protected void uninstallDefaults(JPanel p) {
        super.uninstallDefaults(p);
        this.oldStyleValues = null;
    }

    protected Border createDefaultBorder() {
        Color color = FlatUIUtils.getUIColor((String)"Toast.shadowColor", (Color)new Color(0, 0, 0));
        Insets insets = UIUtils.getInsets((String)"Toast.shadowInsets", (Insets)new Insets(0, 0, 6, 6));
        float shadowOpacity = FlatUIUtils.getUIFloat((String)"Toast.shadowOpacity", (float)0.1f);
        return new DropShadowBorder(color, insets, shadowOpacity);
    }

    protected String getPropertyPrefix() {
        return "Toast";
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "Toast.icon": {
                JPanel c = (JPanel)e.getSource();
                this.uninstallIconComponent((JComponent)c);
                this.installIconComponent((JComponent)c);
                c.revalidate();
                c.repaint();
                break;
            }
            case "Toast.component": {
                JPanel c = (JPanel)e.getSource();
                this.uninstallComponent((JComponent)c);
                this.installComponent((JComponent)c);
                c.revalidate();
                c.repaint();
                break;
            }
            case "Toast.showCloseButton": {
                JPanel c = (JPanel)e.getSource();
                this.uninstallCloseButton((JComponent)c);
                this.installCloseButton((JComponent)c);
                c.revalidate();
                c.repaint();
                break;
            }
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JPanel c = (JPanel)e.getSource();
                this.installStyle(c);
                c.revalidate();
                c.repaint();
                break;
            }
        }
    }

    private void installIconComponent(JComponent c) {
        this.iconComponent = (JComponent)FlatClientProperties.clientProperty((JComponent)c, (String)"Toast.icon", null, JComponent.class);
        if (this.iconComponent != null) {
            this.installLayout(c);
            c.add(this.iconComponent);
        }
    }

    private void uninstallIconComponent(JComponent c) {
        if (this.iconComponent != null) {
            c.remove(this.iconComponent);
            this.iconComponent = null;
        }
    }

    private void installComponent(JComponent c) {
        this.component = (JComponent)FlatClientProperties.clientProperty((JComponent)c, (String)"Toast.component", null, JComponent.class);
        if (this.component != null) {
            this.installLayout(c);
            c.add(this.component);
        }
    }

    private void uninstallComponent(JComponent c) {
        if (this.component != null) {
            c.remove(this.component);
            this.component = null;
        }
    }

    private void installCloseButton(JComponent c) {
        if (FlatClientProperties.clientPropertyBoolean((JComponent)c, (String)"Toast.showCloseButton", (boolean)this.showCloseButton)) {
            this.closeButton = this.createCloseButton(c);
            this.installLayout(c);
            c.add(this.closeButton);
        }
    }

    private void uninstallCloseButton(JComponent c) {
        if (this.closeButton != null) {
            c.remove(this.closeButton);
            this.closeButton = null;
        }
    }

    protected JComponent createCloseButton(JComponent c) {
        JButton button = new JButton();
        button.setFocusable(false);
        button.setName("Toast.closeButton");
        button.putClientProperty("JButton.buttonType", "toolBarButton");
        button.putClientProperty("FlatLaf.style", "arc:999");
        button.setIcon(this.closeButtonIcon);
        button.addActionListener(e -> this.closeButtonClicked(c));
        return button;
    }

    protected void closeButtonClicked(JComponent c) {
        Object callback = c.getClientProperty("Toast.closeCallback");
        if (callback instanceof Runnable) {
            ((Runnable)callback).run();
        } else if (callback instanceof Consumer) {
            ((Consumer)callback).accept(c);
        }
    }

    public void installLayout(JComponent c) {
        if (this.layout == null) {
            this.layout = new PanelNotificationLayout(this);
        }
        c.setLayout((LayoutManager)this.layout);
    }

    protected void installStyle(JPanel c) {
        try {
            this.applyStyle(c, FlatStylingSupport.getResolvedStyle((JComponent)c, (String)"ToastPanel"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, (Throwable)ex);
        }
    }

    protected void applyStyle(JPanel c, Object style) {
        boolean oldShowCloseButton = this.showCloseButton;
        this.oldStyleValues = FlatStylingSupport.parseAndApply((Map)this.oldStyleValues, (Object)style, (key, value) -> this.applyStyleProperty(c, key, value));
        if (oldShowCloseButton != this.showCloseButton) {
            this.uninstallCloseButton((JComponent)c);
            this.installCloseButton((JComponent)c);
        }
    }

    protected Object applyStyleProperty(JPanel c, String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent((Object)this, (Object)c, (String)key, (Object)value);
    }

    public Map<String, Class<?>> getStyleableInfos(JComponent c) {
        return FlatStylingSupport.getAnnotatedStyleableInfos((Object)this);
    }

    public Object getStyleableValue(JComponent c, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue((Object)this, (String)key);
    }
}

