/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.components.ui;

import br.com.tracker.dfeconverter.view.components.ui.DialogLayerUtil;
import com.formdev.flatlaf.util.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DialogLayerUtil {
    private static final Logger log = LoggerFactory.getLogger(DialogLayerUtil.class);
    private static final Map<String, PanelDarkBackground> DARK_BACKGROUNDS = new HashMap();
    private static final Map<String, BufferedImage> BACKGROUND_IMAGES = new HashMap();
    private static final float MAX_OPACITY = 0.5f;
    private static final int ANIMATION_DURATION_OPEN = 120;
    private static final int ANIMATION_DURATION_CLOSE = 40;

    public static void registrar(JDialog dialog) {
        DialogLayerUtil.registrar(null, (JDialog)dialog);
    }

    public static void registrar(Window parent, JDialog dialog) {
        if (parent == null) {
            DialogLayerUtil.registrarGlobalOverlay((JDialog)dialog);
        } else {
            DialogLayerUtil.registrarParentOverlay((Window)parent, (JDialog)dialog);
        }
    }

    private static void registrarGlobalOverlay(JDialog dialog) {
        String identifier = "GlobalOverlay";
        if (DARK_BACKGROUNDS.containsKey("GlobalOverlay")) {
            log.warn("Global overlay j\u00e1 est\u00e1 registrado.");
            return;
        }
        JWindow overlayWindow = DialogLayerUtil.createOverlayWindow();
        PanelDarkBackground darkBackground = new PanelDarkBackground();
        darkBackground.setBounds(0, 0, overlayWindow.getWidth(), overlayWindow.getHeight());
        darkBackground.setOpacity(0.0f);
        overlayWindow.getContentPane().add((Component)darkBackground);
        DARK_BACKGROUNDS.put("GlobalOverlay", darkBackground);
        Animator openAnimator = DialogLayerUtil.createOpenAnimator((PanelDarkBackground)darkBackground, (String)"GlobalOverlay", (JLayeredPane)overlayWindow.getLayeredPane());
        dialog.addWindowListener((WindowListener)new DialogWindowListener("GlobalOverlay", openAnimator, null, dialog));
    }

    private static void registrarParentOverlay(Window parent, JDialog dialog) {
        String identifier = DialogLayerUtil.getWindowIdentifier((Window)parent);
        if (DARK_BACKGROUNDS.containsKey(identifier)) {
            log.warn("Overlay para '{}' j\u00e1 est\u00e1 registrado.", (Object)identifier);
            return;
        }
        JLayeredPane layeredPane = DialogLayerUtil.getLayeredPane((Window)parent);
        if (layeredPane == null) {
            log.error("LayeredPane n\u00e3o encontrado para o parent '{}'.", (Object)identifier);
            return;
        }
        BufferedImage backgroundImage = DialogLayerUtil.createSnapshot((Window)parent);
        BACKGROUND_IMAGES.put(identifier, backgroundImage);
        PanelDarkBackground darkBackground = new PanelDarkBackground(backgroundImage);
        darkBackground.setBounds(0, 0, parent.getWidth(), parent.getHeight());
        DARK_BACKGROUNDS.put(identifier, darkBackground);
        layeredPane.add((Component)darkBackground, JLayeredPane.MODAL_LAYER);
        Animator openAnimator = DialogLayerUtil.createOpenAnimator((PanelDarkBackground)darkBackground, (String)identifier, (JLayeredPane)layeredPane);
        dialog.addWindowListener((WindowListener)new DialogWindowListener(identifier, openAnimator, parent, dialog));
    }

    private static JWindow createOverlayWindow() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        Rectangle screenBounds = gd.getDefaultConfiguration().getBounds();
        JWindow overlayWindow = new JWindow();
        overlayWindow.setBounds(screenBounds);
        overlayWindow.setBackground(new Color(0, 0, 0, 0));
        overlayWindow.setLayout(null);
        overlayWindow.setVisible(true);
        return overlayWindow;
    }

    private static Animator createOpenAnimator(PanelDarkBackground darkBackground, String identifier, JLayeredPane layeredPane) {
        return new Animator(120, fraction -> {
            darkBackground.setOpacity(fraction * 0.5f);
            layeredPane.repaint();
        });
    }

    private static JLayeredPane getLayeredPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getLayeredPane();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getLayeredPane();
        }
        log.error("Tipo de parent n\u00e3o suportado: {}", (Object)window.getClass().getName());
        return null;
    }

    private static BufferedImage createSnapshot(Window window) {
        Rectangle contentBounds = window.getBounds();
        Insets insets = window.getInsets();
        int width = contentBounds.width - insets.left + insets.right;
        int height = contentBounds.height;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.translate(-insets.left, -insets.top);
        window.paint(g2);
        g2.dispose();
        return image;
    }

    private static String getWindowIdentifier(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getTitle();
        }
        if (window instanceof JDialog) {
            return ((JDialog)window).getTitle();
        }
        return "UnknownWindow";
    }

    private static void closeWithAnimation(String identifier, Window parent) {
        JLayeredPane layeredPane;
        PanelDarkBackground darkBackground = (PanelDarkBackground)DARK_BACKGROUNDS.get(identifier);
        if (darkBackground == null) {
            log.warn("PanelDarkBackground n\u00e3o encontrado para '{}'.", (Object)identifier);
            return;
        }
        JLayeredPane jLayeredPane = layeredPane = parent == null ? DialogLayerUtil.getGlobalOverlayLayeredPane() : DialogLayerUtil.getLayeredPane((Window)parent);
        if (layeredPane == null) {
            log.error("LayeredPane n\u00e3o encontrado para '{}'.", (Object)identifier);
            return;
        }
        Animator closeAnimator = new Animator(40, fraction -> {
            darkBackground.setOpacity(0.5f * (1.0f - fraction));
            layeredPane.repaint();
        }, () -> {
            layeredPane.remove((Component)darkBackground);
            layeredPane.revalidate();
            layeredPane.repaint();
            DARK_BACKGROUNDS.remove(identifier);
            BufferedImage backgroundImage = (BufferedImage)BACKGROUND_IMAGES.remove(identifier);
            if (backgroundImage != null) {
                backgroundImage.flush();
            }
            if (parent == null) {
                DialogLayerUtil.closeGlobalOverlay();
            }
        });
        closeAnimator.start();
    }

    private static JLayeredPane getGlobalOverlayLayeredPane() {
        Window[] windows;
        for (Window window : windows = Window.getWindows()) {
            if (!(window instanceof JWindow) || !window.isVisible()) continue;
            return ((JWindow)window).getLayeredPane();
        }
        log.error("Overlay window n\u00e3o encontrado.");
        return null;
    }

    private static void closeGlobalOverlay() {
        Window[] windows;
        for (Window window : windows = Window.getWindows()) {
            if (!(window instanceof JWindow) || !window.isVisible()) continue;
            window.dispose();
        }
    }

    private DialogLayerUtil() {
    }

    static /* synthetic */ void access$000(String x0, Window x1) {
        DialogLayerUtil.closeWithAnimation((String)x0, (Window)x1);
    }
}

