/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.forms;

import br.com.tracker.dfeconverter.view.forms.LightDarkMode;
import br.com.tracker.dfeconverter.view.util.PrefsUtil;
import br.com.tracker.dfeconverter.view.util.TrackerUtil;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class LightDarkMode
extends JPanel {
    private boolean menuFull = true;
    private JButton buttonLight;
    private JButton buttonDark;
    private JButton buttonLighDark;

    public void setMenuFull(boolean menuFull) {
        this.menuFull = menuFull;
        if (menuFull) {
            this.buttonLight.setVisible(true);
            this.buttonDark.setVisible(true);
            this.buttonLighDark.setVisible(false);
        } else {
            this.buttonLight.setVisible(false);
            this.buttonDark.setVisible(false);
            this.buttonLighDark.setVisible(true);
        }
    }

    public LightDarkMode() {
        this.init();
    }

    private void init() {
        this.setBorder((Border)new EmptyBorder(2, 2, 2, 2));
        this.setLayout((LayoutManager)new LightDarkModeLayout(this, null));
        Icon iconLight = TrackerUtil.createIcon((String)"icons/mode/light.svg", (Color)(FlatLaf.isLafDark() ? Color.WHITE : Color.black), (float)0.75f);
        this.buttonLight = new JButton("Claro", iconLight);
        this.buttonLight.setCursor(new Cursor(12));
        this.buttonLight.setFocusPainted(false);
        Icon iconDark = TrackerUtil.createIcon((String)"icons/mode/dark.svg", (Color)(FlatLaf.isLafDark() ? Color.WHITE : Color.black), (float)0.75f);
        this.buttonDark = new JButton("Escuro", iconDark);
        this.buttonDark.setCursor(new Cursor(12));
        this.buttonDark.setFocusPainted(false);
        this.buttonLighDark = new JButton();
        this.buttonLighDark.putClientProperty("FlatLaf.style", "arc:999;[dark]background:lighten(@background,5%);[light]background:darken(@background,8%);foreground:$Menu.foreground;focusWidth:0;borderWidth:0");
        this.buttonLighDark.addActionListener(e -> this.changeMode(!FlatLaf.isLafDark()));
        this.checkStyle();
        this.buttonDark.addActionListener(e -> this.changeMode(true));
        this.buttonLight.addActionListener(e -> this.changeMode(false));
        this.add((Component)this.buttonLight);
        this.add((Component)this.buttonDark);
        this.add((Component)this.buttonLighDark);
    }

    private void changeMode(boolean dark) {
        if (FlatLaf.isLafDark() != dark) {
            if (dark) {
                PrefsUtil.getState().put(PrefsUtil.TEMA, "escuro");
                EventQueue.invokeLater(() -> {
                    FlatAnimatedLafChange.showSnapshot();
                    FlatMacDarkLaf.setup();
                    FlatLaf.updateUI();
                    FlatAnimatedLafChange.hideSnapshotWithAnimation();
                    this.checkStyle();
                });
            } else {
                PrefsUtil.getState().put(PrefsUtil.TEMA, "claro");
                EventQueue.invokeLater(() -> {
                    FlatAnimatedLafChange.showSnapshot();
                    FlatMacLightLaf.setup();
                    FlatLaf.updateUI();
                    FlatAnimatedLafChange.hideSnapshotWithAnimation();
                    this.checkStyle();
                });
            }
        }
    }

    private void checkStyle() {
        boolean isDark = FlatLaf.isLafDark();
        this.addStyle(this.buttonLight, !isDark);
        this.addStyle(this.buttonDark, isDark);
        if (isDark) {
            Icon iconLight = TrackerUtil.createIcon((String)"icons/mode/dark.svg", (Color)Color.WHITE, (float)0.75f);
            this.buttonLighDark.setIcon(iconLight);
            this.buttonDark.setIcon(iconLight);
            Icon iconDark = TrackerUtil.createIcon((String)"icons/mode/light.svg", (Color)new Color(120, 120, 120), (float)0.75f);
            this.buttonLight.setIcon(iconDark);
        } else {
            Icon iconDark = TrackerUtil.createIcon((String)"icons/mode/light.svg", (Color)Color.WHITE, (float)0.75f);
            this.buttonLighDark.setIcon(iconDark);
            this.buttonLight.setIcon(iconDark);
            Icon iconLight = TrackerUtil.createIcon((String)"icons/mode/dark.svg", (Color)Color.BLACK, (float)0.75f);
            this.buttonDark.setIcon(iconLight);
        }
    }

    private void addStyle(JButton button, boolean style) {
        if (style) {
            button.putClientProperty("FlatLaf.styleClass", "primary-light-dark-active");
        } else {
            button.putClientProperty("FlatLaf.styleClass", "primary-light-dark-inative");
        }
    }

    static /* synthetic */ JButton access$100(LightDarkMode x0) {
        return x0.buttonDark;
    }

    static /* synthetic */ boolean access$200(LightDarkMode x0) {
        return x0.menuFull;
    }

    static /* synthetic */ JButton access$300(LightDarkMode x0) {
        return x0.buttonLight;
    }

    static /* synthetic */ JButton access$400(LightDarkMode x0) {
        return x0.buttonLighDark;
    }
}

