/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.forms;

import br.com.tracker.dfeconverter.exception.MainException;
import br.com.tracker.dfeconverter.model.dto.tracker.AuthDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.TokenDTO;
import br.com.tracker.dfeconverter.service.tracker.TrackerFeignClient;
import br.com.tracker.dfeconverter.view.components.button.ButtonPrimary;
import br.com.tracker.dfeconverter.view.forms.LoginWithTenantExtraction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.FeignException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginWithTenantExtraction
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(LoginWithTenantExtraction.class);
    private JTextField txtUsername;
    private JPasswordField txtPassword;
    private ButtonPrimary cmdLogin;
    private String extractedTenant;
    private TrackerFeignClient trackerClient;
    private JDialog parentDialog;

    public LoginWithTenantExtraction(TrackerFeignClient trackerClient) {
        this.trackerClient = trackerClient;
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("al center center"));
        this.createLogin();
    }

    private void createLogin() {
        JPanel panelLogin = new JPanel(new BorderLayout());
        panelLogin.setOpaque(false);
        panelLogin.setBorder(BorderFactory.createEmptyBorder());
        JPanel loginContent = new JPanel((LayoutManager)new MigLayout("fillx,wrap,insets 35 35 25 35", "[fill,300]"));
        JLabel lbTitle = new JLabel("Tracker Center - Login");
        lbTitle.putClientProperty("FlatLaf.style", "font:bold +12;");
        loginContent.add(lbTitle);
        this.txtUsername = new JTextField();
        this.txtPassword = new JPasswordField();
        this.cmdLogin = new ButtonPrimary("Login");
        this.setupUsernameFilter();
        this.txtUsername.putClientProperty("JTextField.placeholderText", "Informe seu usu\u00e1rio");
        this.txtPassword.putClientProperty("JTextField.placeholderText", "Informe sua senha");
        panelLogin.putClientProperty("FlatLaf.style", "[dark]background:tint($Panel.background,1%);");
        loginContent.putClientProperty("FlatLaf.style", "background:null;");
        this.txtUsername.putClientProperty("FlatLaf.style", "margin:4,10,4,10;arc:12;");
        this.txtPassword.putClientProperty("FlatLaf.style", "margin:4,10,4,10;arc:12;showRevealButton:true;");
        this.cmdLogin.putClientProperty((Object)"FlatLaf.style", (Object)"margin:4,10,4,10;arc:12;");
        loginContent.add((Component)new JLabel("Usu\u00e1rio"), "gapy 25");
        loginContent.add(this.txtUsername);
        loginContent.add((Component)new JLabel("Senha"), "gapy 10");
        loginContent.add(this.txtPassword);
        loginContent.add((Component)this.cmdLogin, "gapy 20");
        panelLogin.add(loginContent);
        this.add((Component)panelLogin);
        this.cmdLogin.addActionListener(e -> this.performLogin());
    }

    private void setupUsernameFilter() {
        AbstractDocument document = (AbstractDocument)this.txtUsername.getDocument();
        document.setDocumentFilter((DocumentFilter)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void performLogin() {
        String userName = this.txtUsername.getText().trim();
        String password = String.valueOf(this.txtPassword.getPassword());
        if (userName.isEmpty() || password.isEmpty()) {
            JOptionPane.showMessageDialog((Component)this, "Porfavor preencha todos os campos.", "Login Erro", 0);
            return;
        }
        log.info("Autenticando usuario {}", (Object)userName);
        this.cmdLogin.setEnabled(false);
        this.cmdLogin.setText("Authenticating...");
        2 loginWorker = new /* Unavailable Anonymous Inner Class!! */;
        loginWorker.execute();
    }

    private LoginResult authenticateWithTracker(String username, String password) {
        try {
            AuthDTO authDTO = new AuthDTO();
            authDTO.setLogin(username);
            authDTO.setSenha(password);
            TokenDTO tokenResponse = this.trackerClient.efetuaAutenticacao(authDTO);
            if (tokenResponse != null && tokenResponse.getAccessToken() != null) {
                String token = tokenResponse.getAccessToken();
                String tenant = this.extractTenantFromJWT(token);
                return new LoginResult(true, token, tenant, null);
            }
            return new LoginResult(false, null, null, "Token not received from server");
        }
        catch (FeignException.Unauthorized e) {
            return new LoginResult(false, null, null, "Invalid username or password");
        }
        catch (FeignException.BadRequest e) {
            return new LoginResult(false, null, null, "Invalid request format");
        }
        catch (FeignException e) {
            String errorMessage = "Server error: " + e.status();
            try {
                if (e.contentUTF8() != null && !e.contentUTF8().isEmpty()) {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode errorJson = mapper.readTree(e.contentUTF8());
                    if (errorJson.has("message")) {
                        errorMessage = errorJson.get("message").asText();
                    } else if (errorJson.has("error")) {
                        errorMessage = errorJson.get("error").asText();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new LoginResult(false, null, null, errorMessage);
        }
        catch (Exception e) {
            return new LoginResult(false, null, null, "Connection error: " + e.getMessage());
        }
    }

    private String extractTenantFromJWT(String jwtToken) {
        try {
            String[] parts = jwtToken.split("\\.");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid JWT token format");
            }
            ObjectMapper mapper = new ObjectMapper();
            byte[] decodedBytes = Base64.getUrlDecoder().decode(parts[1]);
            String payload = new String(decodedBytes, StandardCharsets.UTF_8);
            JsonNode jsonNode = mapper.readTree(payload);
            if (jsonNode.has("tenant")) {
                return jsonNode.get("tenant").asText();
            }
            throw new MainException("Tenant n\u00e3o encontrado no JWT");
        }
        catch (Exception e) {
            System.err.println("Error extracting tenant from JWT: " + e.getMessage());
            e.printStackTrace();
            return "default";
        }
    }

    private void handleLoginResult(LoginResult result) {
        if (result.isSuccess()) {
            this.extractedTenant = result.getTenant();
            if (this.parentDialog != null) {
                this.parentDialog.dispose();
            }
        } else {
            this.handleLoginError(result.getErrorMessage());
        }
    }

    private void handleLoginError(String errorMessage) {
        JOptionPane.showMessageDialog((Component)this, errorMessage, "Login Erro", 0);
    }

    public static String showLoginDialog(Frame parent, TrackerFeignClient trackerClient) {
        JDialog dialog = new JDialog(parent, "Login", true);
        LoginWithTenantExtraction loginPanel = new LoginWithTenantExtraction(trackerClient);
        loginPanel.setParentDialog(dialog);
        dialog.add((Component)loginPanel);
        dialog.setSize(450, 350);
        dialog.setLocationRelativeTo(parent);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        return loginPanel.getExtractedTenant();
    }

    public String getExtractedTenant() {
        return this.extractedTenant;
    }

    public void setParentDialog(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    static /* synthetic */ LoginResult access$000(LoginWithTenantExtraction x0, String x1, String x2) {
        return x0.authenticateWithTracker(x1, x2);
    }

    static /* synthetic */ void access$100(LoginWithTenantExtraction x0, LoginResult x1) {
        x0.handleLoginResult(x1);
    }

    static /* synthetic */ void access$200(LoginWithTenantExtraction x0, String x1) {
        x0.handleLoginError(x1);
    }

    static /* synthetic */ ButtonPrimary access$300(LoginWithTenantExtraction x0) {
        return x0.cmdLogin;
    }
}

