/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.forms;

import br.com.tracker.dfeconverter.SpringContext;
import br.com.tracker.dfeconverter.model.dto.ProxyRuleDTO;
import br.com.tracker.dfeconverter.service.ViewService;
import br.com.tracker.dfeconverter.view.components.button.ButtonAdicionar;
import br.com.tracker.dfeconverter.view.components.button.ButtonRemover;
import br.com.tracker.dfeconverter.view.components.renderer.ProxyRuleCellRenderer;
import br.com.tracker.dfeconverter.view.forms.Configuracoes;
import br.com.tracker.dfeconverter.view.forms.Eventos;
import br.com.tracker.dfeconverter.view.util.TableColumnAdjuster;
import com.towel.el.annotation.AnnotationResolver;
import com.towel.swing.table.ObjectTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfig
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(ProxyConfig.class);
    private static ProxyConfig eventos;
    private final ViewService viewService;
    private SwingWorker<List<ProxyRuleDTO>, Void> worker;
    AnnotationResolver resolverEventos = new AnnotationResolver(ProxyRuleDTO.class);
    final ObjectTableModel<ProxyRuleDTO> tableModelEventos = new ObjectTableModel(this.resolverEventos, "method:Metodo,route:Rota Interceptar,jsonPathSegments:Caminho JSON");
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private ButtonAdicionar jbAdicionar;
    private ButtonRemover jbRemover;
    private JComboBox<String> jcbMetodo;
    private JPanel jpFiltroEventos;
    private JPanel jpFundoEventos;
    private JTable jtLista;
    private JTextField jtfCaminhoJson;
    private JTextField jtfRota;

    public String get() {
        this.setVisible(true);
        List lista = this.tableModelEventos.getData();
        return lista.stream().map(ProxyRuleDTO::toString).collect(Collectors.joining(";"));
    }

    public static ProxyConfig getInstance(String proxyConfig) {
        if (eventos == null) {
            eventos = new ProxyConfig((Frame)Configuracoes.getInstance(), true, proxyConfig);
        }
        return eventos;
    }

    public ProxyConfig(Frame parent, boolean modal, String proxyConfig) {
        super(parent, modal);
        this.initComponents();
        super.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        Image imagem = Toolkit.getDefaultToolkit().createImage(Eventos.class.getClassLoader().getResource("icons/tracker-icon.png"));
        super.setIconImage(imagem);
        this.viewService = (ViewService)SpringContext.getBean(ViewService.class);
        this.setTitle(this.viewService.getAppInfo() + " - Proxy Configurar");
        this.jbAdicionar.addActionListener(evt -> {
            String metodo = (String)this.jcbMetodo.getSelectedItem();
            String rota = this.jtfRota.getText().trim();
            String caminho = this.jtfCaminhoJson.getText().trim();
            if (metodo != null && metodo.isEmpty() || rota.isEmpty() || caminho.isEmpty()) {
                JOptionPane.showMessageDialog((Component)this, "Preencha todos os campos para adicionar uma nova regra.", "Aten\u00e7\u00e3o", 2);
                return;
            }
            ProxyRuleDTO novaRegra = ProxyRuleDTO.fromString((String)(metodo + "|" + rota + "|" + caminho));
            if (novaRegra == null) {
                JOptionPane.showMessageDialog((Component)this, "Regra inv\u00e1lida. Verifique os dados e tente novamente.", "Aten\u00e7\u00e3o", 2);
                return;
            }
            this.tableModelEventos.add((Object)novaRegra);
            this.jtfRota.setText("");
            this.jtfCaminhoJson.setText("");
        });
        this.jbRemover.addActionListener(evt -> {
            int selectedRow = this.jtLista.getSelectedRow();
            if (selectedRow >= 0) {
                int modelRow = this.jtLista.convertRowIndexToModel(selectedRow);
                this.tableModelEventos.remove(modelRow);
            } else {
                JOptionPane.showMessageDialog((Component)this, "Selecione uma regra para remover.", "Aten\u00e7\u00e3o", 2);
            }
        });
        this.jtLista.setModel((TableModel)this.tableModelEventos);
        ProxyRuleCellRenderer cellRenderer = new ProxyRuleCellRenderer();
        this.jtLista.setDefaultRenderer(Object.class, (TableCellRenderer)cellRenderer);
        IntStream.range(0, this.tableModelEventos.getColumnCount()).forEach(columnIndex -> this.jtLista.getColumnModel().getColumn(columnIndex).setCellRenderer((TableCellRenderer)cellRenderer));
        TableColumnAdjuster tca = new TableColumnAdjuster(this.jtLista);
        tca.setDynamicAdjustment(true);
        tca.adjustColumn("Metodo", 55);
        tca.adjustColumn("Rota Interceptar", 300);
        tca.adjustColumn("Caminho JSON", 300);
        if (proxyConfig != null && !proxyConfig.isEmpty()) {
            List lista = Arrays.stream(proxyConfig.split(";")).map(ProxyRuleDTO::fromString).filter(Objects::nonNull).collect(Collectors.toList());
            this.tableModelEventos.addAll(lista);
        }
    }

    private void initComponents() {
        this.jpFiltroEventos = new JPanel();
        this.jcbMetodo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jtfRota = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jtfCaminhoJson = new JTextField();
        this.jbAdicionar = new ButtonAdicionar();
        this.jbRemover = new ButtonRemover();
        this.jpFundoEventos = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jtLista = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(764, 294));
        this.setPreferredSize(new Dimension(764, 294));
        this.jpFiltroEventos.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.jpFiltroEventos.setPreferredSize(new Dimension(70, 80));
        this.jcbMetodo.setModel(new DefaultComboBoxModel<String>(new String[]{"POST", "PUT", "PATCH"}));
        this.jcbMetodo.setPreferredSize(new Dimension(76, 35));
        this.jLabel2.setText("Metodo:");
        this.jtfRota.setPreferredSize(new Dimension(68, 35));
        this.jLabel3.setText("Rota para interceptar:");
        this.jLabel4.setText("Atributo com XML (JSON):");
        this.jtfCaminhoJson.setPreferredSize(new Dimension(68, 35));
        this.jbAdicionar.setText("");
        this.jbAdicionar.setPreferredSize(new Dimension(50, 35));
        this.jbRemover.setText("");
        this.jbRemover.setPreferredSize(new Dimension(50, 35));
        GroupLayout jpFiltroEventosLayout = new GroupLayout(this.jpFiltroEventos);
        this.jpFiltroEventos.setLayout(jpFiltroEventosLayout);
        jpFiltroEventosLayout.setHorizontalGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpFiltroEventosLayout.createSequentialGroup().addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jcbMetodo, -2, 94, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jtfRota, -1, 235, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpFiltroEventosLayout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 141, Short.MAX_VALUE)).addComponent(this.jtfCaminhoJson, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jbAdicionar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jbRemover, -2, -1, -2).addContainerGap()));
        jpFiltroEventosLayout.setVerticalGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpFiltroEventosLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jpFiltroEventosLayout.createSequentialGroup().addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jcbMetodo, -2, -1, -2).addComponent(this.jtfRota, -2, -1, -2))).addGroup(GroupLayout.Alignment.TRAILING, jpFiltroEventosLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpFiltroEventosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jbAdicionar, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jtfCaminhoJson, -2, -1, -2))).addComponent((Component)this.jbRemover, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
        this.getContentPane().add((Component)this.jpFiltroEventos, "North");
        this.jpFundoEventos.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        this.jpFundoEventos.setLayout(new BorderLayout());
        this.jtLista.setAutoResizeMode(0);
        this.jtLista.setSelectionMode(0);
        this.jtLista.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jtLista);
        this.jpFundoEventos.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jpFundoEventos, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    static /* synthetic */ ProxyConfig access$002(ProxyConfig x0) {
        eventos = x0;
        return eventos;
    }
}

