/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.view.util;

import java.util.InputMismatchException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class FormatterUtil {
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    public static String formatarCPFCNPJ(String cpfCnpj) {
        if (cpfCnpj == null || "".equals(cpfCnpj.trim())) {
            return "";
        }
        String cpfCnpjZeros = cpfCnpj.replaceAll("\\D", "");
        return cpfCnpjZeros.length() <= 11 ? FormatterUtil.formatarCPF((String)cpfCnpjZeros) : FormatterUtil.formatarCNPJ((String)cpfCnpjZeros);
    }

    public static String formatarCNPJ(String cnpj) {
        if (cnpj == null || "".equals(cnpj.replaceAll("\\D", ""))) {
            return "";
        }
        if (cnpj.length() == 3) {
            cnpj = cnpj.substring(0, 2) + "." + cnpj.substring(2, 3);
        } else if (cnpj.length() >= 4 && cnpj.length() <= 5) {
            cnpj = cnpj.substring(0, 2) + "." + cnpj.substring(2, cnpj.length());
        } else if (cnpj.length() >= 6 && cnpj.length() <= 8) {
            cnpj = cnpj.substring(0, 2) + "." + cnpj.substring(2, 5) + "." + cnpj.substring(5, cnpj.length());
        } else if (cnpj.length() >= 9 && cnpj.length() <= 12) {
            cnpj = cnpj.substring(0, 2) + "." + cnpj.substring(2, 5) + "." + cnpj.substring(5, 8) + "/" + cnpj.substring(8, cnpj.length());
        } else if (cnpj.length() >= 12 && cnpj.length() <= 14) {
            cnpj = cnpj.substring(0, 2) + "." + cnpj.substring(2, 5) + "." + cnpj.substring(5, 8) + "/" + cnpj.substring(8, 12) + "-" + cnpj.substring(12, cnpj.length());
        }
        return cnpj;
    }

    public static String formatarCPF(String cpf) {
        if (cpf == null || "".equals(cpf.replaceAll("\\D", ""))) {
            return "";
        }
        if (cpf.length() == 4) {
            cpf = cpf.substring(0, 3) + "." + cpf.substring(3, 4);
        } else if (cpf.length() >= 5 && cpf.length() <= 6) {
            cpf = cpf.substring(0, 3) + "." + cpf.substring(3, cpf.length());
        } else if (cpf.length() >= 7 && cpf.length() <= 9) {
            cpf = cpf.substring(0, 3) + "." + cpf.substring(3, 6) + "." + cpf.substring(6, cpf.length());
        } else if (cpf.length() >= 10 && cpf.length() <= 11) {
            cpf = cpf.substring(0, 3) + "." + cpf.substring(3, 6) + "." + cpf.substring(6, 9) + "-" + cpf.substring(9, cpf.length());
        }
        return cpf;
    }

    public static boolean isEmail(String emailStr) {
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailStr);
        return matcher.find();
    }

    public static boolean isCpf(String cpf) {
        cpf = cpf.replace(".", "");
        cpf = cpf.replace("-", "");
        try {
            Long.parseLong(cpf);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int d2 = 0;
        int d1 = 0;
        int resto = 0;
        int digito2 = 0;
        int digito1 = 0;
        for (int nCount = 1; nCount < cpf.length() - 1; ++nCount) {
            int digitoCPF = Integer.parseInt(cpf.substring(nCount - 1, nCount));
            d1 += (11 - nCount) * digitoCPF;
            d2 += (12 - nCount) * digitoCPF;
        }
        resto = d1 % 11;
        digito1 = resto < 2 ? 0 : 11 - resto;
        resto = (d2 += 2 * digito1) % 11;
        digito2 = resto < 2 ? 0 : 11 - resto;
        String nDigVerific = cpf.substring(cpf.length() - 2, cpf.length());
        String nDigResult = String.valueOf(digito1) + String.valueOf(digito2);
        return nDigVerific.equals(nDigResult);
    }

    public static boolean isCnpj(String cnpj) {
        cnpj = cnpj.replace(".", "");
        cnpj = cnpj.replace("-", "");
        cnpj = cnpj.replace("/", "");
        try {
            Long.parseLong(cnpj);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (cnpj.equals("00000000000000") || cnpj.equals("11111111111111") || cnpj.equals("22222222222222") || cnpj.equals("33333333333333") || cnpj.equals("44444444444444") || cnpj.equals("55555555555555") || cnpj.equals("66666666666666") || cnpj.equals("77777777777777") || cnpj.equals("88888888888888") || cnpj.equals("99999999999999") || cnpj.length() != 14) {
            return false;
        }
        try {
            int num;
            int i;
            int sm = 0;
            int peso = 2;
            for (i = 11; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int r = sm % 11;
            char dig13 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            sm = 0;
            peso = 2;
            for (i = 12; i >= 0; --i) {
                num = cnpj.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            r = sm % 11;
            char dig14 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            return dig13 == cnpj.charAt(12) && dig14 == cnpj.charAt(13);
        }
        catch (InputMismatchException erro) {
            return false;
        }
    }
}

