/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter;

import br.com.tracker.dfeconverter.view.components.ui.ENotificacao;
import br.com.tracker.dfeconverter.view.forms.Splashscreen;
import br.com.tracker.dfeconverter.view.util.PrefsUtil;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import java.awt.GraphicsEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableAsync
@EnableScheduling
@EnableFeignClients
@SpringBootApplication
public class Application {
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        boolean headlessFlag = "true".equalsIgnoreCase(System.getProperty("app.headless")) || "true".equalsIgnoreCase(System.getenv("APP_HEADLESS")) || GraphicsEnvironment.isHeadless();
        System.setProperty("java.awt.headless", String.valueOf(headlessFlag));
        try {
            PrefsUtil.init((String)"br/com/tracker/dfeconverter");
            if (!headlessFlag) {
                FlatLaf.registerCustomDefaultsSource((String)"tema");
                String tema = PrefsUtil.getState().get(PrefsUtil.TEMA, "claro");
                if ("claro".equalsIgnoreCase(tema)) {
                    FlatMacLightLaf.setup();
                } else {
                    FlatMacDarkLaf.setup();
                }
                Splashscreen.getInstance().setVisible(true);
            }
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{Application.class});
            builder.headless(headlessFlag);
            builder.run(args);
        }
        catch (Exception ex) {
            String mensagemErro = Application.getMessageException((Exception)ex);
            if (!Boolean.parseBoolean(System.getProperty("java.awt.headless"))) {
                ENotificacao.monta((ENotificacao.Tipo)ENotificacao.Tipo.ERRO, (String)"DFe Converter - Inicializa\u00e7\u00e3o", (String)mensagemErro).get();
            } else {
                System.err.println("DFe Converter - Inicializa\u00e7\u00e3o (headless): " + mensagemErro);
                log.error("Falha ao iniciar a aplica\u00e7\u00e3o", (Throwable)ex);
            }
            System.exit(1);
        }
    }

    private static String getMessageException(Exception ex) {
        String mensagemErro = ex.getMessage();
        mensagemErro = mensagemErro != null && mensagemErro.contains("Database may be already in use") ? "O banco de dados j\u00e1 est\u00e1 em uso!\nFeche outras inst\u00e2ncias do sistema ou reinicie o computador." : (mensagemErro != null && mensagemErro.contains("Unable to open JDBC Connection") ? "Problemas ao conectar no banco de dados.\nVerifique se aplica\u00e7\u00e3o j\u00e1 n\u00e3o est\u00e1 aberta ou contate o suporte." : "Erro ao iniciar a aplica\u00e7\u00e3o.\nDetalhes t\u00e9cnicos no log.");
        return mensagemErro;
    }
}

