/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.config;

import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.service.ConfigPort;
import feign.Client;
import java.net.Authenticator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class InternetProxyConfig
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(InternetProxyConfig.class);
    private static final int CONNECT_TIMEOUT_MS = 10000;
    private static final int READ_TIMEOUT_MS = 30000;
    private final ObjectProvider<ConfigPort> configPortProvider;
    private volatile boolean proxyConfigured = false;

    public InternetProxyConfig(ObjectProvider<ConfigPort> configPortProvider) {
        this.configPortProvider = configPortProvider;
    }

    private static String getPasswordOrEmpty(String password) {
        return StringUtils.defaultString((String)password, (String)"");
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.proxyConfigured) {
            return;
        }
        this.configureSystemProxy();
        this.proxyConfigured = true;
    }

    private void configureSystemProxy() {
        ConfigPort configPort = (ConfigPort)this.configPortProvider.getIfAvailable();
        if (configPort == null) {
            log.info("InternetProxy:  ConfigPort not available, system proxy not configured");
            return;
        }
        try {
            if (!configPort.existeConfiguracao()) {
                log.info("InternetProxy:  No configuration found, system proxy not configured");
                return;
            }
            Config config = configPort.buscar();
            if (config.isInternetProxyEnabled() && StringUtils.isNotBlank((CharSequence)config.getInternetProxyHost()) && config.getInternetProxyPort() != null) {
                String proxyHost = config.getInternetProxyHost();
                String proxyPort = String.valueOf(config.getInternetProxyPort());
                System.setProperty("http.proxyHost", proxyHost);
                System.setProperty("http.proxyPort", proxyPort);
                System.setProperty("https.proxyHost", proxyHost);
                System.setProperty("https.proxyPort", proxyPort);
                if (StringUtils.isNotBlank((CharSequence)config.getInternetProxyUsername())) {
                    String username = config.getInternetProxyUsername();
                    String password = InternetProxyConfig.getPasswordOrEmpty((String)config.getInternetProxyPassword());
                    Authenticator.setDefault((Authenticator)new /* Unavailable Anonymous Inner Class!! */);
                    System.setProperty("http.proxyUser", username);
                    System.setProperty("http.proxyPassword", password);
                    System.setProperty("https.proxyUser", username);
                    System.setProperty("https.proxyPassword", password);
                    log.info("InternetProxy: System proxy configured with authentication - {}:{} user={}", new Object[]{proxyHost, proxyPort, username});
                } else {
                    log.info("InternetProxy: System proxy configured without authentication - {}: {}", (Object)proxyHost, (Object)proxyPort);
                }
            } else {
                log.info("InternetProxy: Internet proxy is disabled or not fully configured");
            }
        }
        catch (Exception e) {
            log.warn("InternetProxy:  Error configuring system proxy", (Throwable)e);
        }
    }

    @Bean
    @Primary
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)this.createDefaultRequestFactory());
        return restTemplate;
    }

    @Bean
    @Primary
    public Client feignClient() {
        log.info("InternetProxy:  Feign client created (uses system proxy properties)");
        return new Client.Default(null, null);
    }

    private HttpComponentsClientHttpRequestFactory createDefaultRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(10000);
        factory.setReadTimeout(30000);
        return factory;
    }

    private CloseableHttpClient createHttpClient(Config config) {
        HttpClientBuilder builder = HttpClients.custom();
        if (config.isInternetProxyEnabled() && StringUtils.isNotBlank((CharSequence)config.getInternetProxyHost()) && config.getInternetProxyPort() != null) {
            HttpHost proxyHost = new HttpHost(config.getInternetProxyHost(), config.getInternetProxyPort().intValue());
            builder.setProxy(proxyHost);
            if (StringUtils.isNotBlank((CharSequence)config.getInternetProxyUsername())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(config.getInternetProxyHost(), config.getInternetProxyPort().intValue()), (Credentials)new UsernamePasswordCredentials(config.getInternetProxyUsername(), InternetProxyConfig.getPasswordOrEmpty((String)config.getInternetProxyPassword())));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                log.info("InternetProxy: HttpClient configured with proxy authentication for user: {}", (Object)config.getInternetProxyUsername());
            }
        }
        return builder.build();
    }
}

