/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.controller;

import br.com.tracker.dfeconverter.model.dto.ConverterAPIDTO;
import br.com.tracker.dfeconverter.service.ConverterAPIService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/converter"})
@Tag(name="Converter DFe")
public class ConverterController {
    private static final Logger log = LoggerFactory.getLogger(ConverterController.class);
    private final ConverterAPIService converterAPIService;

    @PostMapping(value={"/arquivo"})
    @Operation(summary="Converte Arquivo XML ou ZIP para novo padr\u00e3o da reforma tribut\u00e1ria")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Arquivo convertido com sucesso"), @ApiResponse(responseCode="400", description="Dados de entrada inv\u00e1lidos"), @ApiResponse(responseCode="500", description="Erro interno do servidor")})
    public ResponseEntity<ConverterAPIDTO> converterArquivo(@Validated @RequestBody ConverterAPIDTO dto) throws Exception {
        log.info("Recebida solicita\u00e7\u00e3o de convers\u00e3o - Tipo: {}, Arquivo: {}", (Object)(dto != null ? dto.getTipoDocumento() : null), (Object)(dto != null ? dto.getTipoArquivo() : null));
        ConverterAPIDTO resultado = this.converterAPIService.converterArquivo(dto);
        log.info("Convers\u00e3o conclu\u00edda com sucesso - Tipo: {}", (Object)(dto != null ? dto.getTipoDocumento() : null));
        return ResponseEntity.ok((Object)resultado);
    }

    @GetMapping(value={"/health"})
    @Operation(summary="Verifica se o servi\u00e7o de convers\u00e3o est\u00e1 funcionando")
    public ResponseEntity<String> health() {
        return ResponseEntity.ok((Object)"Servi\u00e7o de convers\u00e3o funcionando normalmente");
    }

    public ConverterController(ConverterAPIService converterAPIService) {
        this.converterAPIService = converterAPIService;
    }
}

