/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.filter;

import br.com.tracker.dfeconverter.exception.BadRequestException;
import br.com.tracker.dfeconverter.exception.ConverterNotFoundException;
import br.com.tracker.dfeconverter.exception.ConverterValidacaoException;
import br.com.tracker.dfeconverter.exception.IgnorarReformaTributariaException;
import br.com.tracker.dfeconverter.exception.MainException;
import br.com.tracker.dfeconverter.exception.NotFoundException;
import br.com.tracker.dfeconverter.exception.XmlMalformadoException;
import br.com.tracker.dfeconverter.model.dto.ErrorDTO;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice
public class GlobalExceptionFilter {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionFilter.class);

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ErrorDTO validationException(MethodArgumentNotValidException ex, HttpServletRequest request) {
        log.warn("GlobalExceptionHandler::validationException", (Throwable)ex);
        StringBuilder erro = new StringBuilder();
        for (FieldError fieldError : ex.getBindingResult().getFieldErrors()) {
            erro.append(String.format("Campo '%s' %s. ", fieldError.getField(), fieldError.getDefaultMessage()));
        }
        return ErrorDTO.builder().status(HttpStatus.BAD_REQUEST.value()).message(erro.toString()).timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MainException.class})
    public ErrorDTO mainException(HttpServletRequest request, MainException ex) {
        log.warn("GlobalExceptionHandler::mainException", (Throwable)ex);
        return ErrorDTO.builder().status(HttpStatus.BAD_REQUEST.value()).message(ex.getMessage()).timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConverterNotFoundException.class})
    public ErrorDTO converterNotFoundException(HttpServletRequest request, ConverterNotFoundException ex) {
        log.warn("GlobalExceptionHandler::converterNotFoundException", (Throwable)ex);
        String chave = ex.getChaveNfe();
        String cnpj = ex.getCnpjEmitente();
        StringBuilder msg = new StringBuilder();
        msg.append("Converter n\u00e3o encontrado.");
        if (chave != null) {
            msg.append(" Chave: ").append(chave).append(".");
        }
        msg.append(" Detalhe: ").append(ex.getMessage());
        return ErrorDTO.builder().status(HttpStatus.BAD_REQUEST.value()).message(msg.toString()).timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConverterValidacaoException.class, XmlMalformadoException.class, IgnorarReformaTributariaException.class, BadRequestException.class, IllegalArgumentException.class})
    public ErrorDTO handleBadRequestExceptions(HttpServletRequest request, Exception ex) {
        log.warn("GlobalExceptionHandler::handleBadRequestExceptions", (Throwable)ex);
        return ErrorDTO.builder().status(HttpStatus.BAD_REQUEST.value()).message(ex.getMessage() != null ? ex.getMessage() : "Requisi\u00e7\u00e3o inv\u00e1lida").timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    public ErrorDTO notFoundException(HttpServletRequest request, NotFoundException ex) {
        log.warn("GlobalExceptionHandler::notFoundException", (Throwable)ex);
        return ErrorDTO.builder().status(HttpStatus.NOT_FOUND.value()).message(ex.getMessage() + " inexistente.").timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public ErrorDTO exception(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        log.error("GlobalExceptionHandler::exception", (Throwable)ex);
        response.setContentType("application/json");
        return ErrorDTO.builder().status(HttpStatus.INTERNAL_SERVER_ERROR.value()).message(ex.getMessage() != null ? ex.getMessage() : "Erro interno").timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorDTO handleTypeMismatch(MethodArgumentTypeMismatchException ex, HttpServletRequest request) {
        if (ex.getRequiredType() != null && ex.getRequiredType().isEnum()) {
            String campo = ex.getName();
            String valorInvalido = Objects.toString(ex.getValue(), "");
            String permitidos = Arrays.stream(ex.getRequiredType().getEnumConstants()).map(Object::toString).collect(Collectors.joining(", "));
            String mensagem = String.format("'%s' n\u00e3o \u00e9 um valor v\u00e1lido para '%s'. Valores permitidos: %s", valorInvalido, campo, permitidos);
            return ErrorDTO.builder().status(HttpStatus.BAD_REQUEST.value()).message(mensagem).timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
        }
        return ErrorDTO.builder().status(HttpStatus.BAD_REQUEST.value()).message(ex.getMessage()).timestamp(LocalDateTime.now()).uriRequest(request.getRequestURI()).build();
    }
}

