/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.model.entity;

import br.com.tracker.dfeconverter.model.dto.evento.EventoDTO;
import br.com.tracker.dfeconverter.model.entity.Evento;
import br.com.tracker.dfeconverter.model.enums.StatusEvento;
import br.com.tracker.dfeconverter.model.enums.TipoDocumento;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;

@Entity
public class Evento {
    @Id
    @SequenceGenerator(name="EVENTO_ID_GENERATOR", sequenceName="EVENTO_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EVENTO_ID_GENERATOR")
    private Long id;
    @Column(columnDefinition="TEXT")
    private String descricao;
    @Enumerated(value=EnumType.STRING)
    private StatusEvento status;
    @Enumerated(value=EnumType.STRING)
    private TipoDocumento tipoDocumento;
    private LocalDateTime dataEvento;

    public EventoDTO toDTO() {
        return EventoDTO.builder().descricao(this.descricao).status(this.status).dataEvento(this.dataEvento).build();
    }

    public static EventoBuilder builder() {
        return new EventoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public StatusEvento getStatus() {
        return this.status;
    }

    public TipoDocumento getTipoDocumento() {
        return this.tipoDocumento;
    }

    public LocalDateTime getDataEvento() {
        return this.dataEvento;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setStatus(StatusEvento status) {
        this.status = status;
    }

    public void setTipoDocumento(TipoDocumento tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public void setDataEvento(LocalDateTime dataEvento) {
        this.dataEvento = dataEvento;
    }

    public String toString() {
        return "Evento(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", status=" + this.getStatus() + ", tipoDocumento=" + this.getTipoDocumento() + ", dataEvento=" + this.getDataEvento() + ")";
    }

    public Evento(Long id, String descricao, StatusEvento status, TipoDocumento tipoDocumento, LocalDateTime dataEvento) {
        this.id = id;
        this.descricao = descricao;
        this.status = status;
        this.tipoDocumento = tipoDocumento;
        this.dataEvento = dataEvento;
    }

    public Evento() {
    }
}

