/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.monitor;

import br.com.tracker.dfeconverter.monitor.StatusNotifier;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadlessNotifier
implements StatusNotifier {
    private static final Logger log = LoggerFactory.getLogger(HeadlessNotifier.class);
    private final AtomicReference<String> proxSyncHHmm = new AtomicReference<String>("-");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");

    public void onUpdate(int arquivosAguardando, boolean carregando) {
        log.info("Arquivos aguardando: {}, carregando: {}", (Object)arquivosAguardando, (Object)carregando);
    }

    public void onNextSync(LocalDateTime nextRun) {
        String hhmm = nextRun != null ? nextRun.format(DATE_TIME_FORMATTER) : "-";
        this.proxSyncHHmm.set(hhmm);
        log.info("Proxima sincronizacao agendada para {}", (Object)hhmm);
    }
}

