/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.conditions.NotHeadlessCondition;
import br.com.tracker.dfeconverter.model.dto.ProxyRuleDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.repository.ConfigRepository;
import br.com.tracker.dfeconverter.service.ConfigPort;
import br.com.tracker.dfeconverter.service.SincronizacaoService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={NotHeadlessCondition.class})
public class ConfigService
implements ConfigPort {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);
    private final ConfigRepository repository;
    private final ObjectProvider<SincronizacaoService> sincronizacaoServiceProvider;

    public ConfigService(ConfigRepository repository, ObjectProvider<SincronizacaoService> sincronizacaoServiceProvider) {
        this.repository = repository;
        this.sincronizacaoServiceProvider = sincronizacaoServiceProvider;
    }

    public void salvar(Config config) {
        config.setId(Long.valueOf(1L));
        this.repository.save((Object)config);
        SincronizacaoService sincronizacaoService = (SincronizacaoService)this.sincronizacaoServiceProvider.getIfAvailable();
        if (sincronizacaoService != null) {
            sincronizacaoService.agendaSchedulers(config);
        } else {
            log.warn("SincronizacaoService nao disponivel para agendar schedulers");
        }
    }

    public Config buscar() {
        return this.repository.findById((Object)1L).orElse(new Config());
    }

    public List<ProxyRuleDTO> obterProxyRules() {
        Config config = this.buscar();
        String raw = config.getProxyConfig();
        if (StringUtils.isBlank((CharSequence)raw)) {
            return Collections.emptyList();
        }
        return Arrays.stream(raw.split(";")).map(String::trim).map(ProxyRuleDTO::fromString).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean existeConfiguracao() {
        return this.repository.existsById((Object)1L);
    }
}

