/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.exception.BadRequestException;
import br.com.tracker.dfeconverter.exception.ConverterNotFoundException;
import br.com.tracker.dfeconverter.exception.IgnorarReformaTributariaException;
import br.com.tracker.dfeconverter.model.dto.ConverterAPIDTO;
import br.com.tracker.dfeconverter.model.dto.ProcessamentoDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterRelatorioDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.model.enums.ModuloDfeConverterEnum;
import br.com.tracker.dfeconverter.model.enums.StatusDfeConverterEnum;
import br.com.tracker.dfeconverter.model.enums.TipoArquivoDocumento;
import br.com.tracker.dfeconverter.model.enums.TipoDocumento;
import br.com.tracker.dfeconverter.service.ConfigPort;
import br.com.tracker.dfeconverter.service.ConverterAPIService;
import br.com.tracker.dfeconverter.service.NfeService;
import br.com.tracker.dfeconverter.service.NfeTotvsService;
import br.com.tracker.dfeconverter.service.RelatorioService;
import br.com.tracker.dfeconverter.service.tracker.TrackerConvertersProvider;
import br.com.tracker.dfeconverter.service.tracker.TrackerCstCClassProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConverterAPIService {
    private static final Logger log = LoggerFactory.getLogger(ConverterAPIService.class);
    private final NfeService nfeService;
    private final NfeTotvsService nfeTotvsService;
    private final TrackerConvertersProvider convertersProvider;
    private final TrackerCstCClassProvider trackerCstCClassProvider;
    private final ConfigPort configService;
    private final RelatorioService relatorioService;

    public ConverterAPIDTO converterArquivo(ConverterAPIDTO dto) throws Exception {
        this.validarEntrada(dto);
        Config config = this.configService.buscar();
        switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$TipoArquivoDocumento[dto.getTipoArquivo().ordinal()]) {
            case 1: 
            case 2: {
                return this.processarArquivoXML(dto, config);
            }
            case 3: {
                return this.processarArquivoZIP(dto, config);
            }
        }
        throw new BadRequestException("Tipo de arquivo n\u00e3o suportado: " + dto.getTipoArquivo());
    }

    private void validarEntrada(ConverterAPIDTO dto) {
        if (dto == null) {
            throw new BadRequestException("DTO n\u00e3o pode ser nulo");
        }
        if (dto.getTipoDocumento() == null) {
            throw new BadRequestException("Tipo de documento \u00e9 obrigat\u00f3rio");
        }
        if (dto.getTipoArquivo() == null) {
            throw new BadRequestException("Tipo de arquivo \u00e9 obrigat\u00f3rio");
        }
        if (dto.getArquivoBase64() == null || dto.getArquivoBase64().length == 0) {
            throw new BadRequestException("Arquivo \u00e9 obrigat\u00f3rio");
        }
        if (!TipoDocumento.NFE.equals((Object)dto.getTipoDocumento())) {
            throw new BadRequestException("Apenas NFe \u00e9 suportada no momento. Tipo recebido: " + dto.getTipoDocumento());
        }
    }

    private ConverterAPIDTO processarArquivoXML(ConverterAPIDTO dto, Config config) throws Exception {
        log.info("Processando arquivo XML \u00fanico via API");
        String xmlContent = new String(dto.getArquivoBase64(), StandardCharsets.UTF_8);
        if (TipoArquivoDocumento.XML_TOTVS.equals((Object)dto.getTipoArquivo())) {
            xmlContent = "<NFe xmlns=\"http://www.portalfiscal.inf.br/nfe\">" + xmlContent.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "") + "</NFe>";
        }
        if (!TipoDocumento.NFE.equals((Object)dto.getTipoDocumento())) {
            log.warn("Tipo de documento {} n\u00e3o implementado, ignorando", (Object)dto.getTipoDocumento());
            try {
                DfeConverterRelatorioDTO rel = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(null).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.IGNORADO).descricaoStatus("Tipo de documento n\u00e3o implementado").tenant(config != null ? config.getTenant() : null).conteudoArquivo(xmlContent).build();
                this.relatorioService.appendRelatorio(rel, config != null ? config.getNfePastaRelatorio() : null);
            }
            catch (Exception e) {
                log.debug("Falha ao gravar relat\u00f3rio para arquivo ignorado via API", (Throwable)e);
            }
            return this.criarRespostaIgnorada(dto, "Tipo de documento n\u00e3o implementado");
        }
        try {
            String xmlConvertido;
            String cnpj = this.nfeService.extrairCpfCnpjEmitente(xmlContent);
            String chave = null;
            try {
                chave = this.nfeService.extrairChaveNfe(xmlContent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                xmlConvertido = this.processarXMLNFe(xmlContent, config, dto);
            }
            catch (IgnorarReformaTributariaException ire) {
                log.info("Arquivo API cont\u00e9m tags da reforma tribut\u00e1ria e ser\u00e1 ignorado (API).");
                try {
                    DfeConverterRelatorioDTO rel = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpj).chave(chave).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.IGNORADO_CONTEM_TAGS_RT).descricaoStatus("NF-e j\u00e1 cont\u00e9m campos da reforma tribut\u00e1ria").erroInternoStackTrace(null).tenant(config != null ? config.getTenant() : null).conteudoArquivo(xmlContent).build();
                    this.relatorioService.appendRelatorio(rel, config != null ? config.getNfePastaRelatorio() : null);
                }
                catch (Exception e) {
                    log.debug("Falha ao gravar relat\u00f3rio para arquivo ignorado (RT) via API", (Throwable)e);
                }
                return ConverterAPIDTO.builder().tipoDocumento(dto.getTipoDocumento()).tipoArquivo(TipoArquivoDocumento.XML).arquivoBase64(xmlContent.getBytes(StandardCharsets.UTF_8)).build();
            }
            catch (ConverterNotFoundException cnfEx) {
                String chaveDoErro = cnfEx.getChaveNfe();
                if (chaveDoErro == null) {
                    try {
                        chaveDoErro = this.nfeService.extrairChaveNfe(xmlContent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    String stack = ExceptionUtils.getStackTrace((Throwable)cnfEx);
                    DfeConverterRelatorioDTO rel = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpj).chave(chaveDoErro).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.ERRO).descricaoStatus(cnfEx.getMessage()).erroInternoStackTrace(stack).tenant(config != null ? config.getTenant() : null).conteudoArquivo(xmlContent).build();
                    this.relatorioService.appendRelatorio(rel, config != null ? config.getNfePastaRelatorio() : null);
                }
                catch (Exception e) {
                    log.debug("Falha ao gravar relat\u00f3rio de erro para ConverterNotFoundException (API)", (Throwable)e);
                }
                throw cnfEx;
            }
            try {
                DfeConverterRelatorioDTO rel = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpj).chave(chave).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.SUCESSO).descricaoStatus("Processado com sucesso").erroInternoStackTrace(null).tenant(config != null ? config.getTenant() : null).conteudoArquivo(xmlContent).build();
                this.relatorioService.appendRelatorio(rel, config != null ? config.getNfePastaRelatorio() : null);
            }
            catch (Exception e) {
                log.debug("Falha ao gravar relat\u00f3rio de sucesso via API", (Throwable)e);
            }
            return ConverterAPIDTO.builder().tipoDocumento(dto.getTipoDocumento()).tipoArquivo(TipoArquivoDocumento.XML).arquivoBase64(xmlConvertido.getBytes(StandardCharsets.UTF_8)).build();
        }
        catch (Exception ex) {
            log.error("Erro ao processar XML via API", (Throwable)ex);
            try {
                String stack = ExceptionUtils.getStackTrace((Throwable)ex);
                String cnpj = null;
                String chave = null;
                try {
                    cnpj = this.nfeService.extrairCpfCnpjEmitente(xmlContent);
                    chave = this.nfeService.extrairChaveNfe(xmlContent);
                }
                catch (Exception chaveDoErro) {
                    // empty catch block
                }
                DfeConverterRelatorioDTO rel = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpj).chave(chave).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.ERRO).descricaoStatus(ex.getMessage()).erroInternoStackTrace(stack).tenant(config != null ? config.getTenant() : null).conteudoArquivo(xmlContent).build();
                this.relatorioService.appendRelatorio(rel, config != null ? config.getNfePastaRelatorio() : null);
            }
            catch (Exception e2) {
                log.debug("Falha ao gravar relat\u00f3rio de erro via API", (Throwable)e2);
            }
            throw ex;
        }
    }

    private ConverterAPIDTO processarArquivoZIP(ConverterAPIDTO dto, Config config) throws Exception {
        ArrayList<String> arquivosComErro;
        ArrayList<String> arquivosIgnorados;
        HashMap<String, String> arquivosConvertidos;
        block40: {
            log.info("Processando arquivo ZIP via API");
            arquivosConvertidos = new HashMap<String, String>();
            arquivosIgnorados = new ArrayList<String>();
            arquivosComErro = new ArrayList<String>();
            ZipInputStream zipInput = new ZipInputStream(new ByteArrayInputStream(dto.getArquivoBase64()));
            Throwable throwable = null;
            block32: while (true) {
                try {
                    ZipEntry entry;
                    while ((entry = zipInput.getNextEntry()) != null) {
                        DfeConverterRelatorioDTO rel;
                        if (entry.isDirectory()) continue;
                        String nomeArquivo = entry.getName();
                        if (!nomeArquivo.toLowerCase().endsWith(".xml")) {
                            log.debug("Arquivo {} ignorado - n\u00e3o \u00e9 XML", (Object)nomeArquivo);
                            arquivosIgnorados.add(nomeArquivo);
                            try {
                                DfeConverterRelatorioDTO rel2 = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(null).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.IGNORADO).descricaoStatus("N\u00e3o \u00e9 XML").tenant(config != null ? config.getTenant() : null).nomeArquivo(nomeArquivo).build();
                                this.relatorioService.appendRelatorio(rel2, config != null ? config.getNfePastaRelatorio() : null);
                            }
                            catch (Exception e) {
                                log.debug("Falha ao gravar relat\u00f3rio para arquivo ignorado no ZIP", (Throwable)e);
                            }
                            continue;
                        }
                        try {
                            DfeConverterRelatorioDTO rel3;
                            byte[] conteudoArquivo = this.lerEntradaZip(zipInput);
                            String xmlContent = new String(conteudoArquivo, StandardCharsets.UTF_8);
                            if (!TipoDocumento.NFE.equals((Object)dto.getTipoDocumento())) {
                                arquivosIgnorados.add(nomeArquivo);
                                log.debug("Arquivo {} ignorado - tipo n\u00e3o implementado", (Object)nomeArquivo);
                                try {
                                    rel = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(null).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.IGNORADO).descricaoStatus("Tipo de documento n\u00e3o implementado").tenant(config != null ? config.getTenant() : null).nomeArquivo(nomeArquivo).conteudoArquivo(xmlContent).build();
                                    this.relatorioService.appendRelatorio(rel, config != null ? config.getNfePastaRelatorio() : null);
                                    continue block32;
                                }
                                catch (Exception e) {
                                    log.debug("Falha ao gravar relat\u00f3rio para arquivo ignorado (tipo) no ZIP", (Throwable)e);
                                    continue;
                                }
                            }
                            try {
                                String xmlConvertido = this.processarXMLNFe(xmlContent, config, dto);
                                arquivosConvertidos.put(nomeArquivo, xmlConvertido);
                                log.debug("Arquivo {} convertido com sucesso", (Object)nomeArquivo);
                                String cnpj = null;
                                String chave = null;
                                try {
                                    cnpj = this.nfeService.extrairCpfCnpjEmitente(xmlContent);
                                    chave = this.nfeService.extrairChaveNfe(xmlContent);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    DfeConverterRelatorioDTO rel4 = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpj).chave(chave).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.SUCESSO).descricaoStatus("Processado com sucesso").erroInternoStackTrace(null).tenant(config != null ? config.getTenant() : null).nomeArquivo(nomeArquivo).conteudoArquivo(xmlConvertido).build();
                                    this.relatorioService.appendRelatorio(rel4, config != null ? config.getNfePastaRelatorio() : null);
                                }
                                catch (Exception e) {
                                    log.debug("Falha ao gravar relat\u00f3rio de sucesso para arquivo no ZIP", (Throwable)e);
                                }
                            }
                            catch (IgnorarReformaTributariaException ire) {
                                log.info("Arquivo {} do ZIP cont\u00e9m tags da reforma tribut\u00e1ria e ser\u00e1 ignorado.", (Object)nomeArquivo);
                                arquivosIgnorados.add(nomeArquivo);
                                try {
                                    String cnpj = null;
                                    String chave = null;
                                    try {
                                        cnpj = this.nfeService.extrairCpfCnpjEmitente(xmlContent);
                                        chave = this.nfeService.extrairChaveNfe(xmlContent);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    rel3 = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(cnpj).chave(chave).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.IGNORADO_CONTEM_TAGS_RT).descricaoStatus("NF-e j\u00e1 cont\u00e9m campos da reforma tribut\u00e1ria").erroInternoStackTrace(null).tenant(config != null ? config.getTenant() : null).nomeArquivo(nomeArquivo).conteudoArquivo(xmlContent).build();
                                    this.relatorioService.appendRelatorio(rel3, config != null ? config.getNfePastaRelatorio() : null);
                                }
                                catch (Exception e) {
                                    log.debug("Falha ao gravar relat\u00f3rio para arquivo ignorado (RT) no ZIP", (Throwable)e);
                                }
                            }
                            catch (ConverterNotFoundException cnfEx) {
                                String chaveErro = cnfEx.getChaveNfe();
                                try {
                                    if (chaveErro == null) {
                                        chaveErro = this.nfeService.extrairChaveNfe(xmlContent);
                                    }
                                }
                                catch (Exception chave) {
                                    // empty catch block
                                }
                                try {
                                    String stack = ExceptionUtils.getStackTrace((Throwable)cnfEx);
                                    rel3 = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(null).chave(chaveErro).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.ERRO).descricaoStatus(cnfEx.getMessage()).erroInternoStackTrace(stack).tenant(config != null ? config.getTenant() : null).nomeArquivo(nomeArquivo).conteudoArquivo(xmlContent).build();
                                    this.relatorioService.appendRelatorio(rel3, config != null ? config.getNfePastaRelatorio() : null);
                                }
                                catch (Exception e) {
                                    log.debug("Falha ao gravar relat\u00f3rio para ConverterNotFoundException no ZIP", (Throwable)e);
                                }
                                arquivosComErro.add(nomeArquivo + " - " + cnfEx.getMessage());
                            }
                            continue block32;
                        }
                        catch (Exception e) {
                            log.error("Erro ao processar arquivo {} do ZIP: {}", (Object)nomeArquivo, (Object)e.getMessage());
                            arquivosComErro.add(nomeArquivo + " - " + e.getMessage());
                            try {
                                String stack = ExceptionUtils.getStackTrace((Throwable)e);
                                rel = DfeConverterRelatorioDTO.builder().data(LocalDateTime.now()).cnpjEmitente(null).tipoDocumento(dto.getTipoDocumento()).modulo(ModuloDfeConverterEnum.API).status(StatusDfeConverterEnum.ERRO).descricaoStatus(e.getMessage()).erroInternoStackTrace(stack).tenant(config != null ? config.getTenant() : null).nomeArquivo(nomeArquivo).build();
                                this.relatorioService.appendRelatorio(rel, config != null ? config.getNfePastaRelatorio() : null);
                                continue block32;
                            }
                            catch (Exception rEx) {
                                log.debug("Falha ao gravar relat\u00f3rio de erro para arquivo no ZIP", (Throwable)rEx);
                            }
                        }
                    }
                    break block40;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (zipInput != null) {
                    if (throwable != null) {
                        try {
                            zipInput.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        zipInput.close();
                    }
                }
            }
        }
        byte[] zipResposta = this.criarZipResposta(arquivosConvertidos, arquivosIgnorados, arquivosComErro);
        return ConverterAPIDTO.builder().tipoDocumento(dto.getTipoDocumento()).tipoArquivo(TipoArquivoDocumento.ZIP).arquivoBase64(zipResposta).build();
    }

    private String processarXMLNFe(String xmlContent, Config config, ConverterAPIDTO dto) throws Exception {
        List converters = this.convertersProvider.getConverters(config);
        List classesTributarias = this.trackerCstCClassProvider.getClasseTributaria();
        ProcessamentoDTO processamentoDTO = ProcessamentoDTO.builder().tipoDocumento(dto.getTipoDocumento()).converters(converters).classesTributarias(classesTributarias).config(config).build();
        if (TipoArquivoDocumento.XML_TOTVS.equals((Object)dto.getTipoArquivo())) {
            return this.nfeTotvsService.processarXmlTotvs(xmlContent, processamentoDTO);
        }
        return this.nfeService.processarXml(xmlContent, processamentoDTO, ModuloDfeConverterEnum.API);
    }

    private byte[] lerEntradaZip(ZipInputStream zipInput) throws IOException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = zipInput.read(buffer)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    private byte[] criarZipResposta(Map<String, String> arquivosConvertidos, List<String> arquivosIgnorados, List<String> arquivosComErro) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutput = new ZipOutputStream(baos);){
            for (Map.Entry<String, String> entry : arquivosConvertidos.entrySet()) {
                ZipEntry zipEntry = new ZipEntry("convertidos/" + entry.getKey());
                zipOutput.putNextEntry(zipEntry);
                zipOutput.write(entry.getValue().getBytes(StandardCharsets.UTF_8));
                zipOutput.closeEntry();
            }
            if (!arquivosIgnorados.isEmpty() || !arquivosComErro.isEmpty()) {
                String relatorio = this.criarRelatorioProcessamento(arquivosConvertidos.size(), arquivosIgnorados, arquivosComErro);
                ZipEntry relatorioEntry = new ZipEntry("relatorio_processamento.txt");
                zipOutput.putNextEntry(relatorioEntry);
                zipOutput.write(relatorio.getBytes(StandardCharsets.UTF_8));
                zipOutput.closeEntry();
            }
        }
        return baos.toByteArray();
    }

    private String criarRelatorioProcessamento(int convertidos, List<String> ignorados, List<String> erros) {
        StringBuilder sb = new StringBuilder();
        sb.append("=== RELAT\u00d3RIO DE PROCESSAMENTO ===\n\n");
        sb.append("Arquivos convertidos com sucesso: ").append(convertidos).append("\n");
        sb.append("Arquivos ignorados: ").append(ignorados.size()).append("\n");
        sb.append("Arquivos com erro: ").append(erros.size()).append("\n\n");
        if (!ignorados.isEmpty()) {
            sb.append("ARQUIVOS IGNORADOS:\n");
            ignorados.forEach(arquivo -> sb.append("- ").append((String)arquivo).append("\n"));
            sb.append("\n");
        }
        if (!erros.isEmpty()) {
            sb.append("ARQUIVOS COM ERRO:\n");
            erros.forEach(arquivo -> sb.append("- ").append((String)arquivo).append("\n"));
        }
        return sb.toString();
    }

    private ConverterAPIDTO criarRespostaIgnorada(ConverterAPIDTO dto, String motivo) {
        return ConverterAPIDTO.builder().tipoDocumento(dto.getTipoDocumento()).tipoArquivo(dto.getTipoArquivo()).arquivoBase64(motivo.getBytes(StandardCharsets.UTF_8)).build();
    }

    public ConverterAPIService(NfeService nfeService, NfeTotvsService nfeTotvsService, TrackerConvertersProvider convertersProvider, TrackerCstCClassProvider trackerCstCClassProvider, ConfigPort configService, RelatorioService relatorioService) {
        this.nfeService = nfeService;
        this.nfeTotvsService = nfeTotvsService;
        this.convertersProvider = convertersProvider;
        this.trackerCstCClassProvider = trackerCstCClassProvider;
        this.configService = configService;
        this.relatorioService = relatorioService;
    }
}

