/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.conditions.HeadlessCondition;
import br.com.tracker.dfeconverter.exception.NegocioException;
import br.com.tracker.dfeconverter.model.dto.ProxyRuleDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.model.enums.EstrategiaErroProxy;
import br.com.tracker.dfeconverter.service.ConfigPort;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Conditional(value={HeadlessCondition.class})
public class FileConfigService
implements ConfigPort {
    private static final Logger log = LoggerFactory.getLogger(FileConfigService.class);
    @Value(value="${sync.config.file:}")
    private String configFileProp;

    private String resolveConfigPath() {
        String v;
        String string = v = this.configFileProp != null ? this.configFileProp.trim() : "";
        if (v.isEmpty()) {
            throw new NegocioException("Caminho do arquivo de configura\u00e7\u00e3o n\u00e3o informado. Passe --sync.config.file=/caminho/arquivo.properties");
        }
        return v;
    }

    public Config buscar() {
        String cfgPath = this.resolveConfigPath();
        try {
            Path p = Paths.get(cfgPath, new String[0]);
            if (!Files.exists(p, new LinkOption[0])) {
                throw new NegocioException("Arquivo de configura\u00e7\u00e3o n\u00e3o encontrado: " + p.toAbsolutePath());
            }
            Properties props = new Properties();
            try (FileInputStream in = new FileInputStream(p.toFile());){
                props.load(in);
            }
            Config cfg = new Config();
            cfg.setId(Long.valueOf(1L));
            cfg.setIntervaloMinutos(Integer.valueOf(FileConfigService.req((Properties)props, (String)"sync.intervaloMinutos", (String)"60")));
            cfg.setTenant(FileConfigService.req((Properties)props, (String)"sync.tenant"));
            String padraoSaidaTr = FileConfigService.req((Properties)props, (String)"sync.padraoSaidaTr", (String)"false");
            cfg.setPadraoSaidaTr("true".equalsIgnoreCase(padraoSaidaTr) || "1".equals(padraoSaidaTr) || "sim".equalsIgnoreCase(padraoSaidaTr));
            String ignorarTagsReformaTributaria = FileConfigService.req((Properties)props, (String)"sync.ignorarTagsReformaTributaria", (String)"false");
            cfg.setIgnorarTagsReformaTributaria("true".equalsIgnoreCase(ignorarTagsReformaTributaria) || "1".equals(ignorarTagsReformaTributaria) || "sim".equalsIgnoreCase(ignorarTagsReformaTributaria));
            cfg.setNfePastasSincronizacao(FileConfigService.req((Properties)props, (String)"nfe.pastas.sincronizacao", (String)""));
            cfg.setNfePastaConvertido(FileConfigService.req((Properties)props, (String)"nfe.pasta.convertido", (String)".\\convertidos\\nfe"));
            cfg.setNfePastaProcessamento(FileConfigService.req((Properties)props, (String)"nfe.pasta.processamento", (String)".\\processamento\\nfe"));
            cfg.setNfePastaRelatorio(FileConfigService.req((Properties)props, (String)"nfe.pasta.relatorio", (String)".\\relatorios\\nfe"));
            String criarTagVNFTot = FileConfigService.req((Properties)props, (String)"nfe.criarTagVNFTot", (String)"false");
            cfg.setNfeCriarTagVNFTot("true".equalsIgnoreCase(criarTagVNFTot) || "1".equals(criarTagVNFTot) || "sim".equalsIgnoreCase(criarTagVNFTot));
            cfg.setCtePastasSincronizacao(FileConfigService.req((Properties)props, (String)"cte.pastas.sincronizacao", (String)""));
            cfg.setCtePastaConvertido(FileConfigService.req((Properties)props, (String)"cte.pasta.convertido", (String)".\\convertidos\\cte"));
            cfg.setCtePastaProcessamento(FileConfigService.req((Properties)props, (String)"cte.pasta.processamento", (String)".\\processamento\\cte"));
            cfg.setCtePastaRelatorio(FileConfigService.req((Properties)props, (String)"cte.pasta.relatorio", (String)".\\relatorios\\cte"));
            cfg.setNfsePastasSincronizacao(FileConfigService.req((Properties)props, (String)"nfse.pastas.sincronizacao", (String)""));
            cfg.setNfsePastaConvertido(FileConfigService.req((Properties)props, (String)"nfse.pasta.convertido", (String)".\\convertidos\\nfse"));
            cfg.setNfsePastaProcessamento(FileConfigService.req((Properties)props, (String)"nfse.pasta.processamento", (String)".\\processamento\\nfse"));
            cfg.setNfsePastaRelatorio(FileConfigService.req((Properties)props, (String)"nfse.pasta.relatorio", (String)".\\relatorios\\nfse"));
            cfg.setProxyTargetBaseUrl(FileConfigService.req((Properties)props, (String)"sync.proxyBaseUrl", (String)"https://ws.h.dfe.mastersaf.com.br"));
            String proxyEstrategiaErro = FileConfigService.req((Properties)props, (String)"sync.proxyEstrategiaErro", (String)"IGNORAR");
            cfg.setProxyEstrategiaErro(EstrategiaErroProxy.fromDescricao((String)proxyEstrategiaErro));
            cfg.setProxyConfig(FileConfigService.req((Properties)props, (String)"sync.proxyConfig", (String)""));
            String salvarArquivoConvertido = FileConfigService.req((Properties)props, (String)"sync.proxySalvarArquivoConvertido", (String)"true");
            cfg.setProxySalvarArquivoConvertido("true".equalsIgnoreCase(salvarArquivoConvertido) || "1".equals(salvarArquivoConvertido) || "sim".equalsIgnoreCase(salvarArquivoConvertido));
            String salvarArquivoOriginal = FileConfigService.req((Properties)props, (String)"sync.proxySalvarArquivoOriginal", (String)"true");
            cfg.setProxySalvarArquivoOriginal("true".equalsIgnoreCase(salvarArquivoOriginal) || "1".equals(salvarArquivoOriginal) || "sim".equalsIgnoreCase(salvarArquivoOriginal));
            cfg.setProxyConfig(FileConfigService.req((Properties)props, (String)"sync.proxyConfig", (String)""));
            String vLote = FileConfigService.req((Properties)props, (String)"sync.tamanhoLoteEnvio", (String)"500");
            cfg.setTamanhoLoteEnvio(Integer.valueOf(!vLote.trim().isEmpty() ? Integer.parseInt(vLote.trim()) : 500));
            String internetProxyEnabled = FileConfigService.req((Properties)props, (String)"internet.proxy.enabled", (String)"false");
            cfg.setInternetProxyEnabled("true".equalsIgnoreCase(internetProxyEnabled) || "1".equals(internetProxyEnabled) || "sim".equalsIgnoreCase(internetProxyEnabled));
            cfg.setInternetProxyHost(FileConfigService.req((Properties)props, (String)"internet.proxy.host", (String)""));
            String internetProxyPort = FileConfigService.req((Properties)props, (String)"internet.proxy.port", (String)"81");
            if (!internetProxyPort.isEmpty()) {
                try {
                    int port = Integer.parseInt(internetProxyPort.trim());
                    if (port < 1 || port > 65535) {
                        throw new NegocioException("Porta do proxy de Internet inv\u00e1lida: " + port + ". Deve estar entre 1 e 65535.");
                    }
                    cfg.setInternetProxyPort(Integer.valueOf(port));
                }
                catch (NumberFormatException e) {
                    throw new NegocioException("Valor inv\u00e1lido para internet.proxy.port: " + internetProxyPort);
                }
            }
            cfg.setInternetProxyUsername(FileConfigService.req((Properties)props, (String)"internet.proxy.username", (String)""));
            cfg.setInternetProxyPassword(FileConfigService.req((Properties)props, (String)"internet.proxy.password", (String)""));
            return cfg;
        }
        catch (NegocioException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Falha ao ler arquivo de configura\u00e7\u00e3o", (Throwable)e);
            throw new NegocioException("Falha ao ler arquivo de configura\u00e7\u00e3o (detalhes no log).");
        }
    }

    public List<ProxyRuleDTO> obterProxyRules() {
        Config config = this.buscar();
        String raw = config.getProxyConfig();
        if (StringUtils.isBlank((CharSequence)raw)) {
            return Collections.emptyList();
        }
        return Arrays.stream(raw.split(";")).map(String::trim).map(ProxyRuleDTO::fromString).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean existeConfiguracao() {
        try {
            return Files.exists(Paths.get(this.resolveConfigPath(), new String[0]), new LinkOption[0]);
        }
        catch (NegocioException e) {
            return false;
        }
    }

    public void salvar(Config config) {
        throw new NegocioException("Salvar configura\u00e7\u00e3o n\u00e3o \u00e9 suportado em modo headless (somente leitura).");
    }

    private static String req(Properties p, String k) {
        String v = p.getProperty(k);
        if (v == null || v.trim().isEmpty()) {
            throw new NegocioException("Propriedade obrigat\u00f3ria ausente: " + k);
        }
        return v.trim();
    }

    private static String req(Properties p, String k, String defaultValue) {
        String v = p.getProperty(k);
        if (v == null || v.trim().isEmpty()) {
            return defaultValue;
        }
        return v.trim();
    }
}

