/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.swconsultoria.nfe.exception.NfeException;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TIBSCBSMonoTot;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TNFe;
import br.com.swconsultoria.nfe.schema_4.enviNFe.TTribNFe;
import br.com.swconsultoria.nfe.util.XmlNfeUtil;
import br.com.tracker.dfeconverter.exception.ConverterNotFoundException;
import br.com.tracker.dfeconverter.exception.ConverterValidacaoException;
import br.com.tracker.dfeconverter.exception.IgnorarReformaTributariaException;
import br.com.tracker.dfeconverter.model.dto.ProcessamentoDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.ClasseTributariaDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterNfeDTO;
import br.com.tracker.dfeconverter.service.NfeService;
import br.com.tracker.dfeconverter.util.Util;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NfeTotvsService {
    private static final Logger log = LoggerFactory.getLogger(NfeTotvsService.class);
    private static final String TOTAL_BC_IBS_CBS = "TOTAL_BC_IBS_CBS";
    private static final String TOTAL_IBS_UF = "TOTAL_IBS_UF";
    private static final String TOTAL_IBS_MUN = "TOTAL_IBS_MUN";
    private static final String TOTAL_CBS = "TOTAL_CBS";
    private static final Pattern IMPOSTO_PATTERN = Pattern.compile(Pattern.quote("<imposto>"));

    public String processarXmlTotvs(String xmlNormal, ProcessamentoDTO processamentoDTO) throws NfeException, JAXBException, ConverterNotFoundException, ConverterValidacaoException, IgnorarReformaTributariaException {
        String xmlOriginal = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xmlNormal.replace("<NFe xmlns=\"http://www.portalfiscal.inf.br/nfe\">", "").replace("</NFe>", "");
        HashMap<String, BigDecimal> mapTotais = new HashMap<String, BigDecimal>();
        mapTotais.put(TOTAL_BC_IBS_CBS, BigDecimal.ZERO);
        mapTotais.put(TOTAL_IBS_UF, BigDecimal.ZERO);
        mapTotais.put(TOTAL_IBS_MUN, BigDecimal.ZERO);
        mapTotais.put(TOTAL_CBS, BigDecimal.ZERO);
        TNFe nfeRt = (TNFe)XmlNfeUtil.xmlToObject((String)xmlNormal, TNFe.class);
        String cpfCnpjEmitente = nfeRt.getInfNFe().getEmit().getCNPJ() != null ? nfeRt.getInfNFe().getEmit().getCNPJ() : nfeRt.getInfNFe().getEmit().getCPF();
        String chNFe = nfeRt.getInfNFe().getId().substring(3);
        log.info("Processando NFe TOTVs - Chave: {}, Emitente: {}", (Object)chNFe, (Object)cpfCnpjEmitente);
        List converters = processamentoDTO.getConverters().stream().filter(c -> c.getCnpjEmitente().equals(cpfCnpjEmitente)).collect(Collectors.toList());
        String docTipo = "NFE";
        LocalDate dataNota = Util.converteStringToLocalDate((String)nfeRt.getInfNFe().getIde().getDhEmi());
        for (int i = 1; i <= nfeRt.getInfNFe().getDet().size(); ++i) {
            int indexInicial = xmlOriginal.indexOf("<det nItem=\"" + i + "\">");
            int indexFinal = xmlOriginal.indexOf("</det>", indexInicial);
            String xmlDet = xmlOriginal.substring(indexInicial, indexFinal + 6);
            DfeConverterNfeDTO converter = this.getConverterByDet(xmlDet, converters, cpfCnpjEmitente, chNFe);
            ClasseTributariaDTO classeTributaria = NfeService.getClassificacaoTributaria((ProcessamentoDTO)processamentoDTO, (DfeConverterNfeDTO)converter, (LocalDate)dataNota, (String)"NFE");
            TNFe.InfNFe.Det det = (TNFe.InfNFe.Det)nfeRt.getInfNFe().getDet().get(i - 1);
            BigDecimal baseCalculo = this.calcularBaseCalculoIBSCBS(det, xmlDet);
            TTribNFe ibsCbs = NfeService.montaImpostosIBSCBS((DfeConverterNfeDTO)converter, (BigDecimal)baseCalculo, mapTotais, (ClasseTributariaDTO)classeTributaria, (String)chNFe);
            String xmlIbsCbs = "<imposto><codigo>IBSCBS</codigo>" + XmlNfeUtil.objectToXml((Object)ibsCbs, TTribNFe.class, (String)"Tributo").replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", "").replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "").replace(" xmlns=\"http://www.portalfiscal.inf.br/nfe\"", "") + "</imposto>";
            int indexCofins = xmlOriginal.indexOf("<codigo>COFINS</codigo>", indexInicial);
            int indexUltimoImposto = xmlOriginal.indexOf("</imposto>", indexCofins) + 10;
            xmlOriginal = xmlOriginal.substring(0, indexUltimoImposto) + xmlIbsCbs + xmlOriginal.substring(indexUltimoImposto);
        }
        TIBSCBSMonoTot totaisIbsCsb = NfeService.preencheTotaisIbsCsb(mapTotais);
        String totaisIbsCbs = XmlNfeUtil.objectToXml((Object)totaisIbsCsb, TIBSCBSMonoTot.class, (String)"IBSCBSTot").replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", "").replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "").replace(" xmlns=\"http://www.portalfiscal.inf.br/nfe\"", "");
        int indexVnTot = xmlOriginal.indexOf("<vNFTot>");
        if (indexVnTot == -1) {
            indexVnTot = xmlOriginal.indexOf("</total>");
        }
        xmlOriginal = xmlOriginal.substring(0, indexVnTot) + totaisIbsCbs + xmlOriginal.substring(indexVnTot);
        if (processamentoDTO.getConfig().isNfeCriarTagVNFTot()) {
            BigDecimal bigDecimal = new BigDecimal(nfeRt.getInfNFe().getTotal().getICMSTot().getVNF()).add((BigDecimal)mapTotais.get(TOTAL_IBS_UF)).add((BigDecimal)mapTotais.get(TOTAL_IBS_MUN)).add((BigDecimal)mapTotais.get(TOTAL_CBS));
        }
        return xmlOriginal;
    }

    private BigDecimal calcularBaseCalculoIBSCBS(TNFe.InfNFe.Det det, String detXml) {
        BigDecimal vProd = Util.getBigDecimalOrZero((String)det.getProd().getVProd());
        BigDecimal vFrete = Util.getBigDecimalOrZero((String)det.getProd().getVFrete());
        BigDecimal vSeg = Util.getBigDecimalOrZero((String)det.getProd().getVSeg());
        BigDecimal vOutro = Util.getBigDecimalOrZero((String)det.getProd().getVOutro());
        BigDecimal vDesc = Util.getBigDecimalOrZero((String)det.getProd().getVDesc());
        BigDecimal vPIS = BigDecimal.ZERO;
        BigDecimal vCOFINS = BigDecimal.ZERO;
        BigDecimal vICMS = BigDecimal.ZERO;
        BigDecimal vICMSUFDest = BigDecimal.ZERO;
        BigDecimal vFCP = BigDecimal.ZERO;
        BigDecimal vFCPUFDest = BigDecimal.ZERO;
        BigDecimal vICMSMono = BigDecimal.ZERO;
        BigDecimal vISSQN = BigDecimal.ZERO;
        Matcher m = IMPOSTO_PATTERN.matcher(detXml);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        int ultimoIndex = 0;
        for (int i = 0; i < count; ++i) {
            int indexInicial = detXml.indexOf("<imposto>", ultimoIndex);
            String xmlImposto = detXml.substring(indexInicial, (ultimoIndex = detXml.indexOf("</imposto>", indexInicial)) + 10);
            if (xmlImposto.contains("<codigo>ICMS</codigo>")) {
                vICMS = new BigDecimal(Util.getConteudoTag((String)xmlImposto, (String)"valor"));
                continue;
            }
            if (xmlImposto.contains("<codigo>ICMSST</codigo>")) {
                vICMSUFDest = new BigDecimal(Util.getConteudoTag((String)xmlImposto, (String)"valor"));
                continue;
            }
            if (xmlImposto.contains("<codigo>PIS</codigo>")) {
                vPIS = new BigDecimal(Util.getConteudoTag((String)xmlImposto, (String)"valor"));
                continue;
            }
            if (!xmlImposto.contains("<codigo>COFINS</codigo>")) continue;
            vCOFINS = new BigDecimal(Util.getConteudoTag((String)xmlImposto, (String)"valor"));
        }
        return vProd.add(vFrete).add(vSeg).add(vOutro).subtract(vDesc).subtract(vPIS).subtract(vCOFINS).subtract(vICMS).subtract(vICMSUFDest).subtract(vFCP).subtract(vFCPUFDest).subtract(vICMSMono).subtract(vISSQN);
    }

    private DfeConverterNfeDTO getConverterByDet(String det, List<DfeConverterNfeDTO> converters, String cpfCnpjEmitente, String chaveNfe) throws ConverterNotFoundException {
        String cfop = Util.getConteudoTag((String)det, (String)"CFOP");
        String ncm = Util.getConteudoTag((String)det, (String)"NCM");
        String cstIcms = null;
        String cstIpi = null;
        String cstPis = null;
        String cstCofins = null;
        Matcher m = IMPOSTO_PATTERN.matcher(det);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        int ultimoIndex = 0;
        for (int i = 0; i < count; ++i) {
            int indexInicial = det.indexOf("<imposto>", ultimoIndex);
            String xmlImposto = det.substring(indexInicial, (ultimoIndex = det.indexOf("</imposto>", indexInicial)) + 10);
            if (xmlImposto.contains("<codigo>IPI</codigo>")) {
                cstIpi = Util.getConteudoTag((String)xmlImposto, (String)"CST");
                continue;
            }
            if (xmlImposto.contains("<codigo>ICMS</codigo>")) {
                cstIcms = Util.getConteudoTag((String)xmlImposto, (String)"CST");
                continue;
            }
            if (xmlImposto.contains("<codigo>PIS</codigo>")) {
                cstPis = Util.getConteudoTag((String)xmlImposto, (String)"CST");
                continue;
            }
            if (!xmlImposto.contains("<codigo>COFINS</codigo>")) continue;
            cstCofins = Util.getConteudoTag((String)xmlImposto, (String)"CST");
        }
        String fCstIcms = cstIcms;
        String fCstIpi = cstIpi;
        String fCstPis = cstPis;
        String fCstCofins = cstCofins;
        log.debug("Valores extra\u00eddos - CFOP: {}, CST_ICMS: {}, CST_IPI: {}, CST_PIS: {}, CST_COFINS: {}, NCM: {}", new Object[]{cfop, fCstIcms, fCstIpi, fCstPis, fCstCofins, ncm});
        return converters.stream().filter(c -> cfop.endsWith(c.getCfop()) && Util.equalsCode((String)fCstIcms, (String)c.getCstIcms()) && Util.equalsCode((String)fCstIpi, (String)c.getCstIpi()) && Util.equalsCode((String)fCstPis, (String)c.getCstPis()) && Util.equalsCode((String)fCstCofins, (String)c.getCstCofins()) && Util.equalsCode((String)ncm, (String)c.getNcm())).findFirst().orElseThrow(() -> new ConverterNotFoundException(String.format("Converter n\u00e3o encontrado para CNPJ_EMITENTE=%s, CFOP=%s%s%s%s%s%s", cpfCnpjEmitente, cfop, ", CST_ICMS/CSOSN=" + fCstIcms, ", CST_IPI=" + fCstIpi, ", CST_PIS=" + fCstPis, ", CST_COFINS=" + fCstCofins, ", NCM=" + ncm), chaveNfe, cpfCnpjEmitente));
    }
}

