/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.model.dto.ProcessamentoDTO;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterRelatorioDTO;
import br.com.tracker.dfeconverter.service.RelatorioService;
import br.com.tracker.dfeconverter.service.tracker.TrackerService;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RelatorioService {
    private static final Logger log = LoggerFactory.getLogger(RelatorioService.class);
    private final TrackerService trackerService;
    private static final String HEADER_CSV = "modulo;tipoDocumento;data;cnpjEmitente;chave;nomeArquivo;caminhoOrigem;caminhoDestino;rotaRedirecionada;rotaInterceptada;status;descricaoStatus;dfeConverterNfeId;tenant";
    private static final String BOM = "\ufeff";
    private static final DateTimeFormatter FILENAME_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final ConcurrentHashMap<Path, Object> fileLocks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRelatorio(DfeConverterRelatorioDTO item, String pastaRelatorio) {
        Object jvmLock;
        if (item == null) {
            log.warn("Item de relat\u00f3rio nulo. Ignorando appendRelatorio.");
            return;
        }
        try {
            log.info("tenant={} Enviando relat\u00f3rio para o Tracker: m\u00f3dulo={}, tipoDocumento={}, chave={}, status={}", new Object[]{item.getTenant(), item.getModulo(), item.getTipoDocumento(), item.getChave(), item.getStatus()});
            this.trackerService.saveRelatorio(item);
        }
        catch (Exception e) {
            log.error("Erro ao enviar relat\u00f3rio para o Tracker.", (Throwable)e);
        }
        String pastaRelatorioEffective = this.resolvePastaRelatorioOrDefault(pastaRelatorio);
        LocalDate dataRegistro = Optional.ofNullable(item.getData()).map(LocalDateTime::toLocalDate).orElse(LocalDate.now());
        String nomeArquivo = String.format("Relatorio-%s.csv", dataRegistro.format(FILENAME_DATE));
        Path caminho = Paths.get(pastaRelatorioEffective, nomeArquivo).toAbsolutePath();
        Object object = jvmLock = this.fileLocks.computeIfAbsent(caminho, k -> new Object());
        synchronized (object) {
            Path parent = caminho.getParent() == null ? Paths.get(pastaRelatorioEffective, new String[0]) : caminho.getParent();
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("N\u00e3o foi poss\u00edvel criar diret\u00f3rio do relat\u00f3rio: {}", (Object)parent, (Object)e);
                return;
            }
            try (FileChannel channel = FileChannel.open(caminho, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                 FileLock lock = channel.lock();){
                long size = channel.size();
                boolean empty = size == 0L;
                channel.position(size);
                StringBuilder sb = new StringBuilder();
                if (empty) {
                    sb.append(BOM).append(HEADER_CSV).append("\n");
                }
                sb.append(this.montarLinhaCSV(item)).append("\n");
                byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                while (buffer.hasRemaining()) {
                    channel.write(buffer);
                }
                channel.force(true);
            }
            catch (IOException e) {
                log.error("Erro ao escrever relat\u00f3rio di\u00e1rio (append) em pasta: {}", (Object)pastaRelatorioEffective, (Object)e);
            }
        }
    }

    public void gerarRelatorioCSV(List<DfeConverterRelatorioDTO> itensRelatorio, ProcessamentoDTO processamentoDTO, LocalDateTime dataHoraProcessamento) throws IOException {
        if (itensRelatorio == null || itensRelatorio.isEmpty()) {
            log.info("Nenhum item para gerar relat\u00f3rio do tipo {}", processamentoDTO != null ? processamentoDTO.getTipoDocumento() : "N/A");
            return;
        }
        String pastaRelatorio = this.getPastaRelatorio(processamentoDTO);
        String pastaRelatorioEffective = this.resolvePastaRelatorioOrDefault(pastaRelatorio);
        LocalDate dataRegistro = dataHoraProcessamento.toLocalDate();
        String nomeArquivo = String.format("Relatorio-%s.csv", dataRegistro.format(FILENAME_DATE));
        Path caminho = Paths.get(pastaRelatorioEffective, nomeArquivo);
        Path parent = caminho.getParent() == null ? Paths.get(pastaRelatorioEffective, new String[0]) : caminho.getParent();
        Files.createDirectories(parent, new FileAttribute[0]);
        try (FileChannel channel = FileChannel.open(caminho, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            StringBuilder sb = new StringBuilder();
            sb.append(BOM).append(HEADER_CSV).append("\n");
            for (DfeConverterRelatorioDTO item : itensRelatorio) {
                sb.append(this.montarLinhaCSV(item)).append("\n");
            }
            byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
            channel.force(true);
        }
        log.info("Relat\u00f3rio CSV gerado (snapshot): {} (Itens: {})", (Object)caminho, (Object)itensRelatorio.size());
    }

    private String getPastaRelatorio(ProcessamentoDTO processamentoDTO) {
        if (processamentoDTO == null || processamentoDTO.getConfig() == null) {
            return null;
        }
        switch (1.$SwitchMap$br$com$tracker$dfeconverter$model$enums$TipoDocumento[processamentoDTO.getTipoDocumento().ordinal()]) {
            case 1: {
                return processamentoDTO.getConfig().getNfePastaRelatorio();
            }
            case 2: {
                return processamentoDTO.getConfig().getCtePastaRelatorio();
            }
            case 3: {
                return processamentoDTO.getConfig().getNfsePastaRelatorio();
            }
        }
        return processamentoDTO.getConfig().getNfePastaRelatorio();
    }

    private String resolvePastaRelatorioOrDefault(String pastaRelatorio) {
        if (pastaRelatorio != null && !pastaRelatorio.isEmpty()) {
            return pastaRelatorio;
        }
        String userDir = System.getProperty("user.dir");
        Path defaultPath = Paths.get(userDir, "relatorio");
        return defaultPath.toString();
    }

    private String montarLinhaCSV(DfeConverterRelatorioDTO item) {
        String modulo = item.getModulo() != null ? item.getModulo().name() : "";
        String tipoDoc = item.getTipoDocumento() != null ? item.getTipoDocumento().name() : "";
        String data = Optional.ofNullable(item.getData()).map(d -> d.format(TIMESTAMP_FORMAT)).orElse("");
        String cnpj = Optional.ofNullable(item.getCnpjEmitente()).orElse("");
        String chave = Optional.ofNullable(item.getChave()).orElse("");
        String nomeArquivo = Optional.ofNullable(item.getNomeArquivo()).orElse("");
        String caminhoOrigem = Optional.ofNullable(item.getCaminhoOrigem()).orElse("");
        String caminhoDestino = Optional.ofNullable(item.getCaminhoDestino()).orElse("");
        String rotaRed = Optional.ofNullable(item.getRotaRedirecionada()).orElse("");
        String rotaInt = Optional.ofNullable(item.getRotaInterceptada()).orElse("");
        String status = item.getStatus() != null ? item.getStatus().getDescricao() : "";
        String descricao = Optional.ofNullable(item.getDescricaoStatus()).orElse("");
        String dfeId = item.getDfeConverterNfeId() != null ? item.getDfeConverterNfeId().toString() : "";
        String tenant = Optional.ofNullable(item.getTenant()).orElse("");
        return String.join((CharSequence)";", this.escaparCSV(modulo), this.escaparCSV(tipoDoc), this.escaparCSV(data), this.escaparCSV(cnpj), this.escaparCSV(chave), this.escaparCSV(nomeArquivo), this.escaparCSV(caminhoOrigem), this.escaparCSV(caminhoDestino), this.escaparCSV(rotaRed), this.escaparCSV(rotaInt), this.escaparCSV(status), this.escaparCSV(descricao), this.escaparCSV(dfeId), this.escaparCSV(tenant));
    }

    private String escaparCSV(String valor) {
        if (valor == null) {
            return "";
        }
        String limpo = valor.replace("\"", "\"\"");
        if (limpo.contains(";") || limpo.contains("\"") || limpo.contains("\n") || limpo.contains("\r")) {
            limpo = "\"" + limpo + "\"";
        }
        return limpo;
    }

    public RelatorioService(TrackerService trackerService) {
        this.trackerService = trackerService;
    }
}

