/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.monitor.StatusNotifier;
import br.com.tracker.dfeconverter.service.ArquivoService;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class SincronizacaoService {
    private static final Logger log = LoggerFactory.getLogger(SincronizacaoService.class);
    private final ArquivoService arquivoService;
    private final ThreadPoolTaskScheduler scheduler;
    private final StatusNotifier notifier;
    private ScheduledFuture<?> scheduledSincronizacao;

    public void executaSincronizacao(Config config) {
        if (config == null) {
            return;
        }
        try {
            log.info("Iniciando Sincronizacao das pastas {}", (Object)config.getPastasMonitorar());
            this.arquivoService.verificaPastas(config);
            log.info("Finalizada Sincronizacao.");
        }
        catch (Exception e) {
            log.error("Erro ao executar Sincroniza\u00e7\u00e3o", (Throwable)e);
        }
    }

    public void agendaSchedulers(Config config) {
        if (this.scheduledSincronizacao != null) {
            this.scheduledSincronizacao.cancel(false);
        }
        int intervalo = Optional.ofNullable(config.getIntervaloMinutos()).orElse(60);
        this.atualizarProximaSincronizacao(intervalo);
        Instant tempoInicial = Instant.now().plusSeconds(TimeUnit.MINUTES.toSeconds(intervalo));
        Duration periodoExecucao = Duration.ofMinutes(intervalo);
        this.scheduledSincronizacao = this.scheduler.scheduleAtFixedRate(() -> {
            this.executaSincronizacao(config);
            this.atualizarProximaSincronizacao(intervalo);
        }, tempoInicial, periodoExecucao);
    }

    private void atualizarProximaSincronizacao(int intervalInMinutes) {
        LocalDateTime nextExecutionTime = LocalDateTime.now().plusMinutes(intervalInMinutes);
        this.notifier.onNextSync(nextExecutionTime);
    }

    public void executaSincronizacaoManual(Config config) {
        this.scheduler.execute(() -> this.executaSincronizacao(config));
    }

    public SincronizacaoService(ArquivoService arquivoService, ThreadPoolTaskScheduler scheduler, StatusNotifier notifier) {
        this.arquivoService = arquivoService;
        this.scheduler = scheduler;
        this.notifier = notifier;
    }
}

