/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.model.dto.tracker.ClasseTributariaDTO;
import java.time.LocalDate;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidacaoTributacaoHelper {
    public static String validarCstECClass(LocalDate dataNota, ClasseTributariaDTO classeTributariaDTO, String docTipo) {
        if (!ValidacaoTributacaoHelper.isPermitidoParaDocumento((ClasseTributariaDTO)classeTributariaDTO, (String)docTipo)) {
            return "CST " + classeTributariaDTO.getCodigoCst() + " e Classe Trib. " + classeTributariaDTO.getCodigoClassTrib() + " IBS/CBS n\u00e3o permitido para " + docTipo;
        }
        if (classeTributariaDTO.getVigenciaInicio() != null && dataNota.isBefore(classeTributariaDTO.getVigenciaInicio())) {
            return "Classe Trib. " + classeTributariaDTO.getCodigoClassTrib() + " est\u00e1 fora da vig\u00eancia inicial";
        }
        if (classeTributariaDTO.getVigenciaFim() != null && dataNota.isAfter(classeTributariaDTO.getVigenciaFim())) {
            return "Classe Trib. " + classeTributariaDTO.getCodigoClassTrib() + " est\u00e1 fora da vig\u00eancia final";
        }
        return null;
    }

    private static boolean isPermitidoParaDocumento(ClasseTributariaDTO dto, String docTipo) {
        if (dto == null || docTipo == null) {
            return false;
        }
        switch (docTipo.toUpperCase()) {
            case "NFE": {
                return dto.isIndNFe();
            }
            case "NFCE": {
                return dto.isIndNFCe();
            }
            case "CTE": {
                return dto.isIndCTe();
            }
            case "CTEOS": {
                return dto.isIndCTeOS();
            }
            case "BPE": {
                return dto.isIndBPe();
            }
            case "BPE_TM": {
                return dto.isIndBPeTM();
            }
            case "NF3E": {
                return dto.isIndNF3e();
            }
            case "NFCOM": {
                return dto.isIndNFCom();
            }
            case "NFSE": {
                return dto.isIndNFSE();
            }
        }
        return false;
    }
}

