/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service;

import br.com.tracker.dfeconverter.model.dto.evento.EventoDTO;
import br.com.tracker.dfeconverter.model.dto.evento.EventoQueryDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.model.entity.Evento;
import br.com.tracker.dfeconverter.model.enums.StatusEvento;
import br.com.tracker.dfeconverter.service.ConfigPort;
import br.com.tracker.dfeconverter.service.EventoService;
import br.com.tracker.dfeconverter.service.SincronizacaoService;
import br.com.tracker.dfeconverter.view.components.toast.Notifications;
import br.com.tracker.dfeconverter.view.components.ui.ENotificacao;
import br.com.tracker.dfeconverter.view.forms.Configuracoes;
import br.com.tracker.dfeconverter.view.forms.Eventos;
import br.com.tracker.dfeconverter.view.forms.PainelTray;
import br.com.tracker.dfeconverter.view.forms.Splashscreen;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseListener;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ViewService {
    private static final Logger log = LoggerFactory.getLogger(ViewService.class);
    @Value(value="${app.version}")
    private String versao;
    @Value(value="${ambiente}")
    private String activeProfile;
    private final EventoService eventoService;
    private final ConfigPort configService;
    private final SincronizacaoService sincronizacaoService;

    public String getAppInfo() {
        return String.format("DF-e Converter - %s - %s", this.getVersao(), this.getActiveProfile());
    }

    public void iniciaSistema(boolean headless) {
        String appVersao = this.getVersao();
        String appActiveProfile = this.getActiveProfile().toUpperCase();
        log.info("DFE-CONVERTER v{} INICIALIZADO!", (Object)appVersao);
        if (headless) {
            return;
        }
        if (SystemTray.isSupported()) {
            Image imagem = Toolkit.getDefaultToolkit().createImage(this.getClass().getClassLoader().getResource("icons/tracker-icon.png"));
            TrayIcon trayIcon = new TrayIcon(imagem, String.format("DFE-CONVERTER - %s - %s", appVersao, appActiveProfile));
            PopupMenu popup = new PopupMenu();
            trayIcon.setImageAutoSize(true);
            SystemTray tray = SystemTray.getSystemTray();
            MenuItem eventos = new MenuItem("Eventos");
            eventos.addActionListener(evt -> Eventos.getInstance().setVisible(true));
            popup.add(eventos);
            popup.addSeparator();
            MenuItem configuracoes = new MenuItem("Configura\u00e7\u00f5es");
            configuracoes.addActionListener(evt -> Configuracoes.getInstance().setVisible(true));
            popup.add(configuracoes);
            MenuItem sincronizarManual = new MenuItem("Sincronizar Manual");
            sincronizarManual.addActionListener(evt -> {
                Notifications.getInstance().show(Notifications.Type.INFO, "Executando sincroniza\u00e7\u00e3o manual, aguarde...");
                this.sincronizacaoManual();
            });
            popup.add(sincronizarManual);
            popup.addSeparator();
            MenuItem sairItem = new MenuItem("Sair");
            sairItem.addActionListener(evt -> {
                ENotificacao.TipoRetorno tipoRetorno = ENotificacao.monta((ENotificacao.Tipo)ENotificacao.Tipo.PERGUNTAR, (String)"DF-e Converter - Finalizar o sistema?", (String)"Esta a\u00e7\u00e3o ir\u00e1 parar os servi\u00e7os de sincroniza\u00e7\u00e3o").get();
                if (tipoRetorno == ENotificacao.TipoRetorno.SIM) {
                    PainelTray.getInstancia().pararMonitorarPastasProcessar();
                    System.exit(0);
                }
            });
            popup.add(sairItem);
            PainelTray painelTray = PainelTray.getInstancia();
            trayIcon.setPopupMenu(popup);
            trayIcon.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
            try {
                Notifications.getInstance().show(Notifications.Type.INFO, String.format("DFE-CONVERTER %s [%s] Ativo", appVersao, appActiveProfile));
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                Notifications.getInstance().show(Notifications.Type.ERROR, "Problemas ao configurar tray icon!");
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!this.configService.existeConfiguracao()) {
            Configuracoes.getInstance().setVisible(true);
        } else {
            Config config = this.configService.buscar();
            this.sincronizacaoService.agendaSchedulers(config);
            if (StringUtils.hasText((String)config.getPastasMonitorar())) {
                PainelTray.getInstancia().setPastasProcessarParaMonitorar(config.getPastasMonitorar());
            }
        }
        PainelTray.getInstancia().carregarErroIgnorados();
        PainelTray.getInstancia().monitorarPastasParaProcessar();
        Splashscreen.getInstance().dispose();
    }

    public void sincronizacaoManual() {
        Config config = this.configService.buscar();
        this.sincronizacaoService.executaSincronizacaoManual(config);
    }

    public void saveConfig(Config config) {
        this.configService.salvar(config);
    }

    public Config getConfig() {
        return this.configService.buscar();
    }

    public List<EventoDTO> getAllEventos(EventoQueryDTO filtro) {
        return this.eventoService.findAll(filtro).stream().map(Evento::toDTO).sorted(Comparator.comparing(EventoDTO::getDataEvento).reversed()).collect(Collectors.toList());
    }

    public Long getEventosErroIgnorado() {
        LocalDateTime dataInicial = LocalDateTime.now().minusHours(24L);
        LocalDateTime dataFinal = LocalDateTime.now();
        List<StatusEvento> status = Arrays.asList(StatusEvento.ERRO, StatusEvento.IGNORADO);
        return this.eventoService.countByStatusInAndDataEventoBetween(status, dataInicial, dataFinal);
    }

    public ViewService(EventoService eventoService, ConfigPort configService, SincronizacaoService sincronizacaoService) {
        this.eventoService = eventoService;
        this.configService = configService;
        this.sincronizacaoService = sincronizacaoService;
    }

    public String getVersao() {
        return this.versao;
    }

    public String getActiveProfile() {
        return this.activeProfile;
    }
}

