/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service.tracker;

import br.com.tracker.dfeconverter.exception.MainException;
import br.com.tracker.dfeconverter.model.dto.tracker.DfeConverterNfeDTO;
import br.com.tracker.dfeconverter.model.entity.Config;
import br.com.tracker.dfeconverter.service.tracker.TrackerLocalCache;
import br.com.tracker.dfeconverter.service.tracker.TrackerService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrackerConvertersProvider {
    private static final Logger log = LoggerFactory.getLogger(TrackerConvertersProvider.class);
    private final TrackerService trackerService;
    private final TrackerLocalCache trackerLocalCache;

    public List<DfeConverterNfeDTO> getConverters(Config config) {
        String tenant = StringUtils.trimToEmpty((String)config.getTenant());
        if (StringUtils.isBlank((CharSequence)tenant)) {
            log.warn("Config invalida: tenant vazio.");
            throw new MainException("Tenant nao pode ser vazio.");
        }
        try {
            LocalDateTime ultima = this.buscarUltimaAtualizacaoComTimeout(tenant);
            if (ultima == null) {
                log.info("Servidor respondeu ultimaAtualizacao = null; usando cache local do tenant.");
                return this.obterConvertersDoCache(tenant);
            }
            Optional cached = this.trackerLocalCache.readFor(tenant, ultima);
            if (cached.isPresent()) {
                log.info("Usando cache local para tenant={}, data={}, itens={}", new Object[]{tenant, ultima, ((TrackerLocalCache.CachePayload)cached.get()).getConverters().size()});
                return ((TrackerLocalCache.CachePayload)cached.get()).getConverters();
            }
            log.info("Cache nao encontrado para data={}.  Consultando converters no servidor...", (Object)ultima);
            List list = this.trackerService.converters(tenant);
            if (list == null || list.isEmpty()) {
                log.warn("Servidor retornou lista vazia de converters.  Tentando cache local...");
                return this.obterConvertersDoCache(tenant);
            }
            this.trackerLocalCache.write(tenant, ultima, list);
            log.info("Converters obtidos do servidor:  {} itens", (Object)list.size());
            return list;
        }
        catch (Exception e) {
            log.warn("Falha ao consultar servidor ({}). Usando fallback do cache local.", (Object)e.getMessage());
            return this.obterConvertersDoCache(tenant);
        }
    }

    private LocalDateTime buscarUltimaAtualizacaoComTimeout(String tenant) {
        try {
            return this.trackerService.ultimaAtualizacao(tenant);
        }
        catch (Exception e) {
            log.debug("Erro ao buscar ultimaAtualizacao:  {}", (Object)e.getMessage());
            throw e;
        }
    }

    private List<DfeConverterNfeDTO> obterConvertersDoCache(String tenant) {
        Optional cached = this.trackerLocalCache.readLatestForTenant(tenant);
        if (cached.isPresent()) {
            TrackerLocalCache.CachePayload payload = (TrackerLocalCache.CachePayload)cached.get();
            log.info("Fallback:  usando cache local do tenant={}, data={}, itens={}", new Object[]{tenant, payload.getDataAtualizacao(), payload.getConverters().size()});
            return payload.getConverters();
        }
        log.error("Nenhum cache local encontrado para tenant={}. Aplicacao nao pode funcionar offline.", (Object)tenant);
        throw new MainException("Servidor indisponivel e nenhuma configuracao local encontrada para o tenant:  " + tenant + ". Execute a aplicacao com acesso ao servidor pelo menos uma vez para criar o cache local.");
    }

    public boolean existeCacheLocal(String tenant) {
        return this.trackerLocalCache.existeCacheParaTenant(tenant);
    }

    public void forcarAtualizacaoCache(Config config) {
        String tenant = StringUtils.trimToEmpty((String)config.getTenant());
        if (StringUtils.isBlank((CharSequence)tenant)) {
            throw new MainException("Tenant nao pode ser vazio.");
        }
        try {
            LocalDateTime ultima = this.trackerService.ultimaAtualizacao(tenant);
            if (ultima == null) {
                log.warn("Servidor retornou ultimaAtualizacao null. Cache nao atualizado.");
                return;
            }
            List list = this.trackerService.converters(tenant);
            if (list != null && !list.isEmpty()) {
                this.trackerLocalCache.write(tenant, ultima, list);
                log.info("Cache forcado atualizado:  tenant={}, data={}, itens={}", new Object[]{tenant, ultima, list.size()});
            }
        }
        catch (Exception e) {
            log.error("Erro ao forcar atualizacao de cache: {}", (Object)e.getMessage());
            throw new MainException("Falha ao atualizar cache:  " + e.getMessage());
        }
    }

    public TrackerConvertersProvider(TrackerService trackerService, TrackerLocalCache trackerLocalCache) {
        this.trackerService = trackerService;
        this.trackerLocalCache = trackerLocalCache;
    }
}

