/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service.tracker;

import br.com.tracker.dfeconverter.model.dto.tracker.ClasseTributariaDTO;
import br.com.tracker.dfeconverter.service.tracker.TrackerCstCClassLocalCache;
import br.com.tracker.dfeconverter.util.PropUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TrackerCstCClassLocalCache {
    private static final Logger log = LoggerFactory.getLogger(TrackerCstCClassLocalCache.class);
    private static final String EXT = ".classetrib.tracker";
    private static final String EXT_TRACKER = ".tracker";
    private static final DateTimeFormatter ISO = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter DATE_FILE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public Optional<CachePayload> readClasseTribFor(LocalDate dataAtualizacao) {
        this.limparArquivosOrfaos(dataAtualizacao);
        Path file = this.getFile(dataAtualizacao);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                CacheFile json = (CacheFile)this.mapper.readValue(Files.readAllBytes(file), CacheFile.class);
                log.debug("Cache ClasseTributaria lido com sucesso:  {} | itens={}", (Object)file.getFileName(), (Object)json.getList().size());
                return Optional.of(new CachePayload(json.getDataAtualizacao(), json.getList()));
            }
            catch (Exception e) {
                log.warn("Falha lendo cache ClasseTributaria {} | erro={} | Removendo arquivo corrompido.. .", (Object)file.getFileName(), (Object)e.getMessage());
                this.removerArquivoSeguro(file);
            }
        } else {
            log.debug("Cache ClasseTributaria nao encontrado:  {}", (Object)file.getFileName());
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<CachePayload> readLatestClasseTrib() {
        Path base = this.ensureBaseDir();
        String tenant = PropUtil.get((String)"sync.tenant", (String)"tenant");
        try (Stream<Path> stream = Files.list(base);){
            List arquivos = stream.filter(p -> p.getFileName().toString().endsWith(".classetrib.tracker")).filter(p -> p.getFileName().toString().startsWith(tenant + "-")).collect(Collectors.toList());
            if (arquivos.isEmpty()) {
                log.debug("Nenhum cache ClasseTributaria encontrado para tenant={}", (Object)tenant);
                Optional<CachePayload> optional = Optional.empty();
                return optional;
            }
            arquivos.sort((a, b) -> {
                try {
                    return Files.getLastModifiedTime(b, new LinkOption[0]).compareTo(Files.getLastModifiedTime(a, new LinkOption[0]));
                }
                catch (IOException e) {
                    return 0;
                }
            });
            for (Path arquivo : arquivos) {
                try {
                    CacheFile json = (CacheFile)this.mapper.readValue(Files.readAllBytes(arquivo), CacheFile.class);
                    log.info("Usando cache ClasseTributaria local (fallback): data={}, itens={}", (Object)json.getDataAtualizacao(), (Object)json.getList().size());
                    Optional<CachePayload> optional = Optional.of(new CachePayload(json.getDataAtualizacao(), json.getList()));
                    return optional;
                }
                catch (Exception e) {
                    log.warn("Cache ClasseTributaria corrompido {}:  {}. Tentando proximo...", (Object)arquivo.getFileName(), (Object)e.getMessage());
                    this.removerArquivoSeguro(arquivo);
                }
            }
            Optional optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            log.warn("Falha listando diretorio de cache ClasseTributaria: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public void writeClasseTrib(LocalDate dataAtualizacao, List<ClasseTributariaDTO> list) {
        Path base = this.ensureBaseDir();
        Path novoArquivo = this.getFile(dataAtualizacao);
        String tenant = PropUtil.get((String)"sync.tenant", (String)"tenant");
        this.removerArquivosAntigosPorExtensao(base, tenant, ".classetrib.tracker", novoArquivo);
        CacheFile content = new CacheFile(dataAtualizacao, list);
        try {
            byte[] bytes = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)content);
            Files.write(novoArquivo, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            TrackerCstCClassLocalCache.hideFileIfPossible((Path)novoArquivo);
            log.info("Cache ClasseTributaria gravado: {} | itens={} | bytes={}", new Object[]{novoArquivo.getFileName(), list.size(), bytes.length});
        }
        catch (IOException e) {
            log.warn("Falha ao gravar cache ClasseTributaria {} | erro={}", (Object)novoArquivo.getFileName(), (Object)e.getMessage());
        }
    }

    public boolean existeCache() {
        return this.readLatestClasseTrib().isPresent();
    }

    private void removerArquivosAntigosPorExtensao(Path baseDir, String tenant, String extensao, Path arquivoAtual) {
        try (Stream<Path> stream = Files.list(baseDir);){
            List arquivosParaRemover = stream.filter(p -> p.getFileName().toString().endsWith(extensao)).filter(p -> p.getFileName().toString().startsWith(tenant + "-")).filter(p -> !p.equals(arquivoAtual)).collect(Collectors.toList());
            int removidos = 0;
            for (Path arquivo : arquivosParaRemover) {
                if (!this.removerArquivoSeguro(arquivo)) continue;
                ++removidos;
            }
            if (removidos > 0) {
                log.info("Limpeza de cache ClasseTributaria: {} arquivo(s) antigo(s) removido(s) para tenant={}", (Object)removidos, (Object)tenant);
            }
        }
        catch (IOException e) {
            log.warn("Erro ao listar arquivos para limpeza de cache ClasseTributaria: {}", (Object)e.getMessage());
        }
    }

    public void limparArquivosOrfaos(LocalDate dataAtualizacao) {
        Path base = this.ensureBaseDir();
        try (Stream<Path> stream = Files.list(base);){
            List arquivosTracker = stream.filter(p -> p.getFileName().toString().endsWith(".classetrib.tracker")).collect(Collectors.toList());
            int removidos = 0;
            for (Path arquivo : arquivosTracker) {
                LocalDate fileDataAtualizacao;
                String fileName = arquivo.getFileName().toString();
                String timestampStr = fileName.substring(fileName.indexOf("-") + 1, fileName.indexOf(".classetrib.tracker"));
                try {
                    fileDataAtualizacao = LocalDate.parse(timestampStr, DATE_FILE_FORMAT);
                }
                catch (Exception e) {
                    log.warn("Nome de arquivo invalido para limpeza geral {}: {}. Removendo arquivo...", (Object)fileName, (Object)e.getMessage());
                    if (!this.removerArquivoSeguro(arquivo)) continue;
                    ++removidos;
                    continue;
                }
                if (fileDataAtualizacao.equals(dataAtualizacao) || !this.removerArquivoSeguro(arquivo)) continue;
                ++removidos;
            }
            if (removidos > 0) {
                log.info("Limpeza geral:  {} arquivo(s) orfao(s)/corrompido(s) removido(s)", (Object)removidos);
            }
        }
        catch (IOException e) {
            log.warn("Erro ao listar diretorio de cache para limpeza geral: {}", (Object)e.getMessage());
        }
    }

    private boolean removerArquivoSeguro(Path arquivo) {
        try {
            arquivo.toFile().delete();
            log.info("Arquivo de cache ClasseTributaria removido: {}", (Object)arquivo.getFileName());
            return true;
        }
        catch (Exception e) {
            log.warn("Nao foi possivel remover arquivo de cache ClasseTributaria {}: {}", (Object)arquivo.getFileName(), (Object)e.getMessage());
            return false;
        }
    }

    private Path getFile(LocalDate dataAtualizacao) {
        Path base = this.ensureBaseDir();
        String tenant = PropUtil.get((String)"sync.tenant", (String)"tenant");
        String fileName = tenant + "-" + ISO.format(dataAtualizacao) + ".classetrib.tracker";
        return base.resolve(fileName);
    }

    private Path ensureBaseDir() {
        Path dir = Paths.get(".", ".tracker").toAbsolutePath().normalize();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            TrackerCstCClassLocalCache.hideDirIfPossible((Path)dir);
        }
        catch (IOException e) {
            log.warn("Nao foi possivel criar a pasta de cache {} | erro={}", (Object)dir, (Object)e.getMessage());
        }
        return dir;
    }

    private static void hideDirIfPossible(Path dir) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                Files.setAttribute(dir, "dos:hidden", true, new LinkOption[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void hideFileIfPossible(Path file) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                Files.setAttribute(file, "dos: hidden", true, new LinkOption[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

