/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service.tracker;

import br.com.tracker.dfeconverter.exception.MainException;
import br.com.tracker.dfeconverter.model.dto.tracker.ClasseTributariaDTO;
import br.com.tracker.dfeconverter.service.tracker.TrackerCstCClassLocalCache;
import br.com.tracker.dfeconverter.service.tracker.TrackerService;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrackerCstCClassProvider {
    private static final Logger log = LoggerFactory.getLogger(TrackerCstCClassProvider.class);
    private final TrackerService trackerService;
    private final TrackerCstCClassLocalCache cache;

    public List<ClasseTributariaDTO> getClasseTributaria() {
        try {
            LocalDate ultima = this.buscarUltimaAtualizacaoComTimeout();
            if (ultima == null) {
                log.info("Servidor respondeu ultimaAtualizacao = null; usando cache local.");
                return this.obterClasseTributariaDoCache();
            }
            Optional cached = this.cache.readClasseTribFor(ultima);
            if (cached.isPresent()) {
                log.debug("Usando cache ClasseTributaria local para data={}, itens={}", (Object)ultima, (Object)((TrackerCstCClassLocalCache.CachePayload)cached.get()).getList().size());
                return ((TrackerCstCClassLocalCache.CachePayload)cached.get()).getList();
            }
            log.info("Cache ClasseTributaria nao encontrado para data={}. Consultando servidor...", (Object)ultima);
            List list = this.trackerService.classeTributaria();
            if (list == null || list.isEmpty()) {
                log.warn("Servidor retornou lista vazia de ClasseTributaria.  Tentando cache local...");
                return this.obterClasseTributariaDoCache();
            }
            this.cache.writeClasseTrib(ultima, list);
            log.info("ClasseTributaria obtida do servidor:  {} itens", (Object)list.size());
            return list;
        }
        catch (Exception e) {
            log.warn("Falha ao consultar servidor ({}). Usando fallback do cache local.", (Object)e.getMessage());
            return this.obterClasseTributariaDoCache();
        }
    }

    private LocalDate buscarUltimaAtualizacaoComTimeout() {
        try {
            return this.trackerService.ultimaAtualizacao();
        }
        catch (Exception e) {
            log.debug("Erro ao buscar ultimaAtualizacao ClasseTributaria: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private List<ClasseTributariaDTO> obterClasseTributariaDoCache() {
        Optional cached = this.cache.readLatestClasseTrib();
        if (cached.isPresent()) {
            TrackerCstCClassLocalCache.CachePayload payload = (TrackerCstCClassLocalCache.CachePayload)cached.get();
            log.info("Fallback: usando cache ClasseTributaria local, data={}, itens={}", (Object)payload.getDataAtualizacao(), (Object)payload.getList().size());
            return payload.getList();
        }
        log.warn("Nenhum cache ClasseTributaria local encontrado. Retornando lista vazia.");
        return Collections.emptyList();
    }

    public boolean existeCacheLocal() {
        return this.cache.existeCache();
    }

    public void forcarAtualizacaoCache() {
        try {
            LocalDate ultima = this.trackerService.ultimaAtualizacao();
            if (ultima == null) {
                log.warn("Servidor retornou ultimaAtualizacao null. Cache ClasseTributaria nao atualizado.");
                return;
            }
            List list = this.trackerService.classeTributaria();
            if (list != null && !list.isEmpty()) {
                this.cache.writeClasseTrib(ultima, list);
                log.info("Cache ClasseTributaria forcado atualizado: data={}, itens={}", (Object)ultima, (Object)list.size());
            }
        }
        catch (Exception e) {
            log.error("Erro ao forcar atualizacao de cache ClasseTributaria: {}", (Object)e.getMessage());
            throw new MainException("Falha ao atualizar cache ClasseTributaria:  " + e.getMessage());
        }
    }

    public TrackerCstCClassProvider(TrackerService trackerService, TrackerCstCClassLocalCache cache) {
        this.trackerService = trackerService;
        this.cache = cache;
    }
}

