/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.service.tracker;

import br.com.tracker.dfeconverter.exception.BadRequestException;
import br.com.tracker.dfeconverter.exception.InternalServerErrorException;
import br.com.tracker.dfeconverter.exception.NotFoundException;
import br.com.tracker.dfeconverter.exception.UnauthorizedException;
import br.com.tracker.dfeconverter.service.tracker.TrackerErrorDecoder;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(TrackerErrorDecoder.class);
    private final ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Exception decode(String methodKey, Response response) {
        String requestUrl = response.request().url();
        int status = response.status();
        String reason = response.reason();
        String responseBody = this.extractResponseBody(response);
        log.error("Error occurred while calling {}. Status code: {}. URL: {}. Reason: {}. Response Body: {}", new Object[]{methodKey, status, requestUrl, reason, responseBody});
        switch (status) {
            case 400: {
                String detailedMessage400 = this.parseDetailedMessage(responseBody, "Bad Request");
                return new BadRequestException(detailedMessage400);
            }
            case 401: {
                String detailedMessage401 = this.parseDetailedMessage(responseBody, "Unauthorized");
                return new UnauthorizedException(detailedMessage401);
            }
            case 404: {
                String detailedMessage404 = this.parseDetailedMessage(responseBody, "Not Found");
                return new NotFoundException(detailedMessage404);
            }
            case 500: {
                String detailedMessage500 = this.parseDetailedMessage(responseBody, "Internal Server Error");
                return new InternalServerErrorException(detailedMessage500);
            }
        }
        return this.defaultErrorDecoder.decode(methodKey, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractResponseBody(Response response) {
        if (response.body() == null) {
            return "No response body";
        }
        try (Scanner scanner = new Scanner(response.body().asInputStream(), StandardCharsets.UTF_8.name());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "Empty response body";
            return string;
        }
        catch (IOException e) {
            log.warn("Failed to read the response body: {}", (Object)e.getMessage());
            return "Failed to read response body";
        }
    }

    private String parseDetailedMessage(String responseBody, String defaultMsg) {
        try {
            ErrorResponse errorResponse = (ErrorResponse)this.objectMapper.readValue(responseBody, ErrorResponse.class);
            return errorResponse.getMessage() != null ? errorResponse.getMessage() : defaultMsg;
        }
        catch (IOException e) {
            log.warn("Failed to parse error response body: {}", (Object)e.getMessage());
            return defaultMsg + ": " + responseBody;
        }
    }
}

