/*
 * Decompiled with CFR 0.152.
 */
package br.com.tracker.dfeconverter.util;

import br.com.tracker.dfeconverter.model.enums.SchemaXsd;
import br.com.tracker.dfeconverter.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlSchemaValidatorUtil {
    private static final StringBuilder erros = new StringBuilder();

    public static boolean validarPorSchema(String xmlCompleto, SchemaXsd schemaEnum) {
        erros.setLength(0);
        try {
            String fragmento = Util.getExtrairTagContent((String)xmlCompleto, (String)schemaEnum.getTag());
            if (fragmento == null || fragmento.trim().isEmpty()) {
                erros.append("Tag '").append(schemaEnum.getTag()).append("' n\u00e3o encontrada no XML.\n");
                return false;
            }
            InputStream xsdStream = XmlSchemaValidatorUtil.class.getResourceAsStream(schemaEnum.getClasspath());
            if (xsdStream == null) {
                erros.append("XSD n\u00e3o encontrado no classpath: ").append(schemaEnum.getClasspath()).append("\n");
                return false;
            }
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(new StreamSource(xsdStream));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(fragmento)));
            return true;
        }
        catch (SAXException e) {
            erros.append("Erro na valida\u00e7\u00e3o XSD: ").append(XmlSchemaValidatorUtil.tratarMensagemSax((String)e.getMessage())).append("\n");
            return false;
        }
        catch (IOException e) {
            erros.append("Erro de IO durante valida\u00e7\u00e3o: ").append(e.getMessage()).append("\n");
            return false;
        }
        catch (Exception e) {
            erros.append("Erro inesperado durante valida\u00e7\u00e3o: ").append(e.getMessage()).append("\n");
            return false;
        }
    }

    public static String getErros() {
        return erros.toString();
    }

    private static String tratarMensagemSax(String msg) {
        if (msg == null) {
            return "";
        }
        msg = msg.replaceAll("\\{", "");
        msg = msg.replaceAll("\\}", "");
        msg = msg.replaceAll("\"", "");
        msg = msg.replace("http://www.portalfiscal.inf.br/nfe:", "");
        return msg;
    }
}

